/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.h2.engine.SysProperties;
import org.h2.expression.ParameterInterface;
import org.h2.message.TraceWriter;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public class Trace {
    public static final String COMMAND = "command";
    public static final String CONSTRAINT = "constraint";
    public static final String DATABASE = "database";
    public static final String FUNCTION = "function";
    public static final String FILE_LOCK = "fileLock";
    public static final String INDEX = "index";
    public static final String JDBC = "jdbc";
    public static final String LOCK = "lock";
    public static final String SCHEMA = "schema";
    public static final String SEQUENCE = "sequence";
    public static final String SETTING = "setting";
    public static final String TABLE = "table";
    public static final String TRIGGER = "trigger";
    public static final String USER = "user";
    public static final String PAGE_STORE = "pageStore";
    private final TraceWriter traceWriter;
    private final String module;
    private final String lineSeparator;
    private int traceLevel = -1;

    Trace(TraceWriter traceWriter, String string) {
        this.traceWriter = traceWriter;
        this.module = string;
        this.lineSeparator = SysProperties.LINE_SEPARATOR;
    }

    public void setLevel(int n) {
        this.traceLevel = n;
    }

    private boolean isEnabled(int n) {
        if (this.traceLevel == -1) {
            return this.traceWriter.isEnabled(n);
        }
        return n <= this.traceLevel;
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(2);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(3);
    }

    public void error(Throwable throwable, String string) {
        if (this.isEnabled(1)) {
            this.traceWriter.write(1, this.module, string, throwable);
        }
    }

    public void error(Throwable throwable, String string, Object ... objectArray) {
        if (this.isEnabled(1)) {
            string = MessageFormat.format(string, objectArray);
            this.traceWriter.write(1, this.module, string, throwable);
        }
    }

    public void info(String string) {
        if (this.isEnabled(2)) {
            this.traceWriter.write(2, this.module, string, null);
        }
    }

    public void info(String string, Object ... objectArray) {
        if (this.isEnabled(2)) {
            string = MessageFormat.format(string, objectArray);
            this.traceWriter.write(2, this.module, string, null);
        }
    }

    void info(Throwable throwable, String string) {
        if (this.isEnabled(2)) {
            this.traceWriter.write(2, this.module, string, throwable);
        }
    }

    public static String formatParams(ArrayList<? extends ParameterInterface> arrayList) {
        if (arrayList.size() == 0) {
            return "";
        }
        StatementBuilder statementBuilder = new StatementBuilder();
        int n = 0;
        boolean bl = false;
        for (ParameterInterface parameterInterface : arrayList) {
            if (!parameterInterface.isValueSet()) continue;
            if (!bl) {
                statementBuilder.append(" {");
                bl = true;
            }
            statementBuilder.appendExceptFirst(", ");
            Value value = parameterInterface.getParamValue();
            statementBuilder.append(++n).append(": ").append(value.getTraceSQL());
        }
        if (bl) {
            statementBuilder.append('}');
        }
        return statementBuilder.toString();
    }

    public void infoSQL(String string, String string2, int n, long l) {
        if (!this.isEnabled(2)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 20);
        stringBuilder.append(this.lineSeparator).append("/*SQL");
        boolean bl = false;
        if (string2.length() > 0) {
            bl = true;
            stringBuilder.append(" l:").append(string.length());
        }
        if (n > 0) {
            bl = true;
            stringBuilder.append(" #:").append(n);
        }
        if (l > 0L) {
            bl = true;
            stringBuilder.append(" t:").append(l);
        }
        if (!bl) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("*/").append(StringUtils.javaEncode(string)).append(StringUtils.javaEncode(string2)).append(';');
        string = stringBuilder.toString();
        this.traceWriter.write(2, this.module, string, null);
    }

    public void debug(String string, Object ... objectArray) {
        if (this.isEnabled(3)) {
            string = MessageFormat.format(string, objectArray);
            this.traceWriter.write(3, this.module, string, null);
        }
    }

    public void debug(String string) {
        if (this.isEnabled(3)) {
            this.traceWriter.write(3, this.module, string, null);
        }
    }

    public void debug(Throwable throwable, String string) {
        if (this.isEnabled(3)) {
            this.traceWriter.write(3, this.module, string, throwable);
        }
    }

    public void infoCode(String string) {
        if (this.isEnabled(2)) {
            this.traceWriter.write(2, this.module, this.lineSeparator + "/**/" + string, null);
        }
    }

    void debugCode(String string) {
        if (this.isEnabled(3)) {
            this.traceWriter.write(3, this.module, this.lineSeparator + "/**/" + string, null);
        }
    }
}

