package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class DemandeListUI extends JPanel implements FaxToMailUI<DemandeListUIModel, DemandeListUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ARCHIVE_MENU_ENABLED = "archiveMenu.enabled";
    public static final String BINDING_COMPUTE_QUANTITIES_BY_RANGE_MENU_ENABLED = "computeQuantitiesByRangeMenu.enabled";
    public static final String BINDING_CURRENT_PAGE_LABEL_TEXT = "currentPageLabel.text";
    public static final String BINDING_DEMAND_NB_FIELD_TEXT = "demandNbField.text";
    public static final String BINDING_MOVE_MENU_ENABLED = "moveMenu.enabled";
    public static final String BINDING_NEW_DEMAND_MENU_ENABLED = "newDemandMenu.enabled";
    public static final String BINDING_NEXT_PAGE_BUTTON_ENABLED = "nextPageButton.enabled";
    public static final String BINDING_PF_NB_FIELD_TEXT = "pfNbField.text";
    public static final String BINDING_PREVIOUS_PAGE_BUTTON_ENABLED = "previousPageButton.enabled";
    public static final String BINDING_PRINT_MENU_ENABLED = "printMenu.enabled";
    public static final String BINDING_QUOTATION_NB_FIELD_TEXT = "quotationNbField.text";
    public static final String BINDING_REPLY_MENU_ENABLED = "replyMenu.enabled";
    public static final String BINDING_SAV_NB_FIELD_TEXT = "savNbField.text";
    public static final String BINDING_TOTAL_DEMAND_COUNT_VALUE_TEXT = "totalDemandCountValue.text";
    public static final String BINDING_TOTAL_PAGE_NUMBER_LABEL_TEXT = "totalPageNumberLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(DemandeListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuItem archiveMenu;
    protected JMenuItem computeQuantitiesByRangeMenu;
    protected JLabel currentPageLabel;
    protected JXTable dataTable;
    protected JLabel demandNbField;
    protected JLabel demandNbLabel;
    protected DemandeListUI demandeListPanel = this;
    protected final DemandeListUIHandler handler = createHandler();
    protected JSplitPane mainSplitPane;
    protected DemandeListUIModel model;
    protected JMenuItem moveMenu;
    protected JTree navigationTree;
    protected JMenuItem newDemandMenu;
    protected JButton nextPageButton;
    protected JLabel pageNumberLabel;
    protected JLabel pfNbField;
    protected JLabel pfNbLabel;
    protected JButton previousPageButton;
    protected JMenuItem printMenu;
    protected JLabel quotationNbField;
    protected JLabel quotationNbLabel;
    protected JMenuItem replyMenu;
    protected JComboBox<Integer> resultPerPageCombo;
    protected JLabel resultsPerPageLabel;
    protected JLabel savNbField;
    protected JLabel savNbLabel;
    protected JPopupMenu tablePopup;
    protected JLabel totalDemandCountLabel;
    protected JLabel totalDemandCountValue;
    protected JLabel totalPageNumberLabel;
    protected JPopupMenu treePopup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandeListUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public DemandeListUI() {
        $initialize();
    }

    public DemandeListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandeListUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandeListUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandeListUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DemandeListUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandeListUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DemandeListUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__computeQuantitiesByRangeMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.computeQuantitiesByRange();
    }

    public void doActionPerformed__on__newDemandMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.newDemand();
    }

    public void doActionPerformed__on__nextPageButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.goToNextPage();
    }

    public void doActionPerformed__on__previousPageButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.goToPreviousPage();
    }

    public void doActionPerformed__on__printMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.print();
    }

    public void doKeyPressed__on__dataTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__dataTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    public void doMouseClicked__on__navigationTree(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectNodeInTree(event, treePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenuItem getArchiveMenu() {
        return archiveMenu;
    }

    public JMenuItem getComputeQuantitiesByRangeMenu() {
        return computeQuantitiesByRangeMenu;
    }

    public JLabel getCurrentPageLabel() {
        return currentPageLabel;
    }

    public JXTable getDataTable() {
        return dataTable;
    }

    public JLabel getDemandNbField() {
        return demandNbField;
    }

    public JLabel getDemandNbLabel() {
        return demandNbLabel;
    }

    public DemandeListUIHandler getHandler() {
        return handler;
    }

    public JSplitPane getMainSplitPane() {
        return mainSplitPane;
    }

    public DemandeListUIModel getModel() {
        return model;
    }

    public JMenuItem getMoveMenu() {
        return moveMenu;
    }

    public JTree getNavigationTree() {
        return navigationTree;
    }

    public JMenuItem getNewDemandMenu() {
        return newDemandMenu;
    }

    public JButton getNextPageButton() {
        return nextPageButton;
    }

    public JLabel getPageNumberLabel() {
        return pageNumberLabel;
    }

    public JLabel getPfNbField() {
        return pfNbField;
    }

    public JLabel getPfNbLabel() {
        return pfNbLabel;
    }

    public JButton getPreviousPageButton() {
        return previousPageButton;
    }

    public JMenuItem getPrintMenu() {
        return printMenu;
    }

    public JLabel getQuotationNbField() {
        return quotationNbField;
    }

    public JLabel getQuotationNbLabel() {
        return quotationNbLabel;
    }

    public JMenuItem getReplyMenu() {
        return replyMenu;
    }

    public JComboBox<Integer> getResultPerPageCombo() {
        return resultPerPageCombo;
    }

    public JLabel getResultsPerPageLabel() {
        return resultsPerPageLabel;
    }

    public JLabel getSavNbField() {
        return savNbField;
    }

    public JLabel getSavNbLabel() {
        return savNbLabel;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JLabel getTotalDemandCountLabel() {
        return totalDemandCountLabel;
    }

    public JLabel getTotalDemandCountValue() {
        return totalDemandCountValue;
    }

    public JLabel getTotalPageNumberLabel() {
        return totalPageNumberLabel;
    }

    public JPopupMenu getTreePopup() {
        return treePopup;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDemandeListPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainSplitPane, BorderLayout.CENTER);
    }

    protected void addChildrenToMainSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        mainSplitPane.add($JScrollPane0, JSplitPane.LEFT);
        mainSplitPane.add($JPanel0, JSplitPane.RIGHT);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(printMenu);
        tablePopup.add(replyMenu);
        tablePopup.add(archiveMenu);
        tablePopup.add(moveMenu);
    }

    protected void addChildrenToTreePopup() {
        if (!allComponentsCreated) {
            return;
        }
        treePopup.add(computeQuantitiesByRangeMenu);
        treePopup.add(newDemandMenu);
    }

    protected void createArchiveMenu() {
        $objectMap.put("archiveMenu", archiveMenu = new JMenuItem());
        
        archiveMenu.setName("archiveMenu");
        archiveMenu.setText(t("faxtomail.demandeList.action.archive"));
        archiveMenu.setToolTipText(t("faxtomail.demandeList.action.archive.tip"));
        archiveMenu.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.actions.ArchiveFromListAction.class );
    }

    protected void createComputeQuantitiesByRangeMenu() {
        $objectMap.put("computeQuantitiesByRangeMenu", computeQuantitiesByRangeMenu = new JMenuItem());
        
        computeQuantitiesByRangeMenu.setName("computeQuantitiesByRangeMenu");
        computeQuantitiesByRangeMenu.setText(t("faxtomail.demandeList.action.computeQuantitiesByRange"));
        computeQuantitiesByRangeMenu.setToolTipText(t("faxtomail.demandeList.action.computeQuantitiesByRange.tip"));
        computeQuantitiesByRangeMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__computeQuantitiesByRangeMenu"));
    }

    protected void createCurrentPageLabel() {
        $objectMap.put("currentPageLabel", currentPageLabel = new JLabel());
        
        currentPageLabel.setName("currentPageLabel");
    }

    protected void createDataTable() {
        $objectMap.put("dataTable", dataTable = new JXTable());
        
        dataTable.setName("dataTable");
        dataTable.setSortable(false);
        dataTable.setEditable(true);
        dataTable.setAutoCreateRowSorter(true);
        dataTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__dataTable"));
        dataTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__dataTable"));
    }

    protected void createDemandNbField() {
        $objectMap.put("demandNbField", demandNbField = new JLabel());
        
        demandNbField.setName("demandNbField");
    }

    protected void createDemandNbLabel() {
        $objectMap.put("demandNbLabel", demandNbLabel = new JLabel());
        
        demandNbLabel.setName("demandNbLabel");
        demandNbLabel.setText(t("faxtomail.demandeList.demandNbLabel"));
        if (demandNbLabel.getFont() != null) {
            demandNbLabel.setFont(demandNbLabel.getFont().deriveFont(demandNbLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected DemandeListUIHandler createHandler() {
        return new DemandeListUIHandler();
    }

    protected void createMainSplitPane() {
        $objectMap.put("mainSplitPane", mainSplitPane = new JSplitPane());
        
        mainSplitPane.setName("mainSplitPane");
        mainSplitPane.setResizeWeight(0.2);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DemandeListUIModel.class));
    }

    protected void createMoveMenu() {
        $objectMap.put("moveMenu", moveMenu = new JMenuItem());
        
        moveMenu.setName("moveMenu");
        moveMenu.setText(t("faxtomail.demandeList.action.transmit"));
        moveMenu.setToolTipText(t("faxtomail.demandeList.action.transmit.tip"));
        moveMenu.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.actions.OpenMailFolderChooserFromListAction.class );
    }

    protected void createNavigationTree() {
        $objectMap.put("navigationTree", navigationTree = new JTree());
        
        navigationTree.setName("navigationTree");
        navigationTree.setRootVisible(false);
        if (navigationTree.getFont() != null) {
            navigationTree.setFont(navigationTree.getFont().deriveFont((float) 11));
        }
        navigationTree.setShowsRootHandles(true);
        navigationTree.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__navigationTree"));
    }

    protected void createNewDemandMenu() {
        $objectMap.put("newDemandMenu", newDemandMenu = new JMenuItem());
        
        newDemandMenu.setName("newDemandMenu");
        newDemandMenu.setText(t("faxtomail.demandeList.action.newDemand"));
        newDemandMenu.setToolTipText(t("faxtomail.demandeList.action.newDemand.tip"));
        newDemandMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newDemandMenu"));
    }

    protected void createNextPageButton() {
        $objectMap.put("nextPageButton", nextPageButton = new JButton());
        
        nextPageButton.setName("nextPageButton");
        nextPageButton.setText(t("faxtomail.demandeList.goToNextPage"));
        nextPageButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__nextPageButton"));
    }

    protected void createPageNumberLabel() {
        $objectMap.put("pageNumberLabel", pageNumberLabel = new JLabel());
        
        pageNumberLabel.setName("pageNumberLabel");
        pageNumberLabel.setText(t("faxtomail.demandeList.pages"));
    }

    protected void createPfNbField() {
        $objectMap.put("pfNbField", pfNbField = new JLabel());
        
        pfNbField.setName("pfNbField");
    }

    protected void createPfNbLabel() {
        $objectMap.put("pfNbLabel", pfNbLabel = new JLabel());
        
        pfNbLabel.setName("pfNbLabel");
        pfNbLabel.setText(t("faxtomail.demandeList.pfNbLabel"));
        if (pfNbLabel.getFont() != null) {
            pfNbLabel.setFont(pfNbLabel.getFont().deriveFont(pfNbLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createPreviousPageButton() {
        $objectMap.put("previousPageButton", previousPageButton = new JButton());
        
        previousPageButton.setName("previousPageButton");
        previousPageButton.setText(t("faxtomail.demandeList.goToPreviousPage"));
        previousPageButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__previousPageButton"));
    }

    protected void createPrintMenu() {
        $objectMap.put("printMenu", printMenu = new JMenuItem());
        
        printMenu.setName("printMenu");
        printMenu.setText(t("faxtomail.demandeList.action.print"));
        printMenu.setToolTipText(t("faxtomail.demandeList.action.print.tip"));
        printMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printMenu"));
    }

    protected void createQuotationNbField() {
        $objectMap.put("quotationNbField", quotationNbField = new JLabel());
        
        quotationNbField.setName("quotationNbField");
    }

    protected void createQuotationNbLabel() {
        $objectMap.put("quotationNbLabel", quotationNbLabel = new JLabel());
        
        quotationNbLabel.setName("quotationNbLabel");
        quotationNbLabel.setText(t("faxtomail.demandeList.quotationNbLabel"));
        if (quotationNbLabel.getFont() != null) {
            quotationNbLabel.setFont(quotationNbLabel.getFont().deriveFont(quotationNbLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createReplyMenu() {
        $objectMap.put("replyMenu", replyMenu = new JMenuItem());
        
        replyMenu.setName("replyMenu");
        replyMenu.setText(t("faxtomail.demandeList.action.reply"));
        replyMenu.setToolTipText(t("faxtomail.demandeList.action.reply.tip"));
        replyMenu.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.actions.OpenReplyFormAction.class );
    }

    protected void createResultPerPageCombo() {
        $objectMap.put("resultPerPageCombo", resultPerPageCombo = new JComboBox<Integer>());
        
        resultPerPageCombo.setName("resultPerPageCombo");
    }

    protected void createResultsPerPageLabel() {
        $objectMap.put("resultsPerPageLabel", resultsPerPageLabel = new JLabel());
        
        resultsPerPageLabel.setName("resultsPerPageLabel");
        resultsPerPageLabel.setText(t("faxtomail.demandeList.resultPerPage"));
    }

    protected void createSavNbField() {
        $objectMap.put("savNbField", savNbField = new JLabel());
        
        savNbField.setName("savNbField");
    }

    protected void createSavNbLabel() {
        $objectMap.put("savNbLabel", savNbLabel = new JLabel());
        
        savNbLabel.setName("savNbLabel");
        savNbLabel.setText(t("faxtomail.demandeList.savNbLabel"));
        if (savNbLabel.getFont() != null) {
            savNbLabel.setFont(savNbLabel.getFont().deriveFont(savNbLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
    }

    protected void createTotalDemandCountLabel() {
        $objectMap.put("totalDemandCountLabel", totalDemandCountLabel = new JLabel());
        
        totalDemandCountLabel.setName("totalDemandCountLabel");
        totalDemandCountLabel.setText(t("faxtomail.demandeList.totalCount"));
    }

    protected void createTotalDemandCountValue() {
        $objectMap.put("totalDemandCountValue", totalDemandCountValue = new JLabel());
        
        totalDemandCountValue.setName("totalDemandCountValue");
    }

    protected void createTotalPageNumberLabel() {
        $objectMap.put("totalPageNumberLabel", totalPageNumberLabel = new JLabel());
        
        totalPageNumberLabel.setName("totalPageNumberLabel");
    }

    protected void createTreePopup() {
        $objectMap.put("treePopup", treePopup = new JPopupMenu());
        
        treePopup.setName("treePopup");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDemandeListPanel();
        addChildrenToTreePopup();
        addChildrenToTablePopup();
        addChildrenToMainSplitPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(navigationTree);
        // inline complete setup of $JPanel0
        $JPanel0.add($JPanel1, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane1, BorderLayout.CENTER);
        $JPanel0.add($JPanel2, BorderLayout.SOUTH);
        // inline complete setup of $JPanel1
        $JPanel1.add(demandNbLabel);
        $JPanel1.add(demandNbField);
        $JPanel1.add($JLabel0);
        $JPanel1.add(quotationNbLabel);
        $JPanel1.add(quotationNbField);
        $JPanel1.add($JLabel1);
        $JPanel1.add(pfNbLabel);
        $JPanel1.add(pfNbField);
        $JPanel1.add($JLabel2);
        $JPanel1.add(savNbLabel);
        $JPanel1.add(savNbField);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(dataTable);
        // inline complete setup of $JPanel2
        $JPanel2.add(totalDemandCountLabel);
        $JPanel2.add(totalDemandCountValue);
        $JPanel2.add($JLabel3);
        $JPanel2.add(resultsPerPageLabel);
        $JPanel2.add(resultPerPageCombo);
        $JPanel2.add($JLabel4);
        $JPanel2.add(pageNumberLabel);
        $JPanel2.add(previousPageButton);
        $JPanel2.add(currentPageLabel);
        $JPanel2.add($JLabel5);
        $JPanel2.add(totalPageNumberLabel);
        $JPanel2.add(nextPageButton);
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        computeQuantitiesByRangeMenu.setIcon(SwingUtil.createActionIcon("compute"));
        newDemandMenu.setIcon(SwingUtil.createActionIcon("new-demand"));
        printMenu.setIcon(SwingUtil.createActionIcon("print"));
        replyMenu.setIcon(SwingUtil.createActionIcon("reply"));
        archiveMenu.setIcon(SwingUtil.createActionIcon("archive"));
        moveMenu.setIcon(SwingUtil.createActionIcon("transmit"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("demandeListPanel", demandeListPanel);
        createModel();
        createTreePopup();
        createComputeQuantitiesByRangeMenu();
        createNewDemandMenu();
        createTablePopup();
        createPrintMenu();
        createReplyMenu();
        createArchiveMenu();
        createMoveMenu();
        createMainSplitPane();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNavigationTree();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new FlowLayout(FlowLayout.LEADING));
        createDemandNbLabel();
        createDemandNbField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t(" | "));
        createQuotationNbLabel();
        createQuotationNbField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t(" | "));
        createPfNbLabel();
        createPfNbField();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t(" | "));
        createSavNbLabel();
        createSavNbField();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createDataTable();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new FlowLayout(FlowLayout.LEADING));
        createTotalDemandCountLabel();
        createTotalDemandCountValue();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t(" | "));
        createResultsPerPageLabel();
        createResultPerPageCombo();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t(" | "));
        createPageNumberLabel();
        createPreviousPageButton();
        createCurrentPageLabel();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("/"));
        createTotalPageNumberLabel();
        createNextPageButton();
        // inline creation of demandeListPanel
        setName("demandeListPanel");
        setLayout(new BorderLayout());
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMPUTE_QUANTITIES_BY_RANGE_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("computeQuantitiesByRangeEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    computeQuantitiesByRangeMenu.setEnabled( model.isComputeQuantitiesByRangeEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("computeQuantitiesByRangeEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_DEMAND_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("newDemandEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    newDemandMenu.setEnabled( model.isNewDemandEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("newDemandEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINT_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("printEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    printMenu.setEnabled( model.isPrintEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("printEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLY_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("replyEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    replyMenu.setEnabled( model.isReplyEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("replyEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVE_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("archiveEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    archiveMenu.setEnabled( model.isArchiveEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("archiveEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MOVE_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("transmitEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    moveMenu.setEnabled( model.isTransmitEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("transmitEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEMAND_NB_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("paginationResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getPaginationResult() != null) {
                    demandNbField.setText(t( String.valueOf(model.getPaginationResult().getCount()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("paginationResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUOTATION_NB_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quotationNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quotationNbField.setText(t( String.valueOf(model.getQuotationNb()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quotationNb", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PF_NB_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("pfNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    pfNbField.setText(t( String.valueOf(model.getPfNb()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("pfNb", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAV_NB_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("savNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    savNbField.setText(t( String.valueOf(model.getSavNb()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("savNb", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_DEMAND_COUNT_VALUE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("paginationResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getPaginationResult() != null) {
                    totalDemandCountValue.setText(t( String.valueOf(model.getPaginationResult().getCount()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("paginationResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PREVIOUS_PAGE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("paginationResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getPaginationResult() != null) {
                    previousPageButton.setEnabled( model.getPaginationResult().hasPreviousPage() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("paginationResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CURRENT_PAGE_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("paginationParameter", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null && getModel().getPaginationParameter() != null) {
                    currentPageLabel.setText(t( String.valueOf(getModel().getPaginationParameter().getPageNumber() + 1) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("paginationParameter", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_PAGE_NUMBER_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("paginationResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null && getModel().getPaginationResult() != null && getModel().getPaginationResult().getLastPage() != null) {
                    totalPageNumberLabel.setText(t( String.valueOf(getModel().getPaginationResult().getLastPage().getPageNumber() + 1) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("paginationResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEXT_PAGE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("paginationResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getPaginationResult() != null) {
                    nextPageButton.setEnabled( model.getPaginationResult().hasNextPage() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("paginationResult", this);
                }
            }
        });
    }

}