/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.util;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeRowModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FolderTreeNode;
import java.awt.Desktop;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.Icon;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.util.ApplicationUIUtil;
import org.nuiton.util.FileUtil;

public final class FaxToMailUIUtil
extends ApplicationUIUtil {
    private static final Log log = LogFactory.getLog(FaxToMailUIUtil.class);

    private FaxToMailUIUtil() {
    }

    public static FaxToMailUIContext getApplicationContext(JAXXObject ui) {
        return (FaxToMailUIContext)ApplicationUIUtil.getApplicationContext((JAXXObject)ui);
    }

    public static void setParentUI(JAXXObject ui, FaxToMailUI<?, ?> parentUI) {
        JAXXUtil.initContext((JAXXObject)ui, parentUI);
        FaxToMailUIUtil.setApplicationContext((JAXXObject)ui, (ApplicationUIContext)((AbstractFaxToMailUIHandler)parentUI.getHandler()).getContext());
    }

    public static Map<MailFolder, DefaultMutableTreeNode> initFolderTree(FaxToMailUIContext context, JTree navigationTree, Collection<MailFolder> folders) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        List<MailFolder> foldersToExpand = context.getExpandedFolders();
        HashMap<MailFolder, DefaultMutableTreeNode> nodesByFolder = new HashMap<MailFolder, DefaultMutableTreeNode>();
        for (MailFolder folder : folders) {
            nodesByFolder.putAll(FaxToMailUIUtil.createFolderTree(root, folder));
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        navigationTree.setModel(treeModel);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        Icon folderIcon = renderer.getDefaultClosedIcon();
        renderer.setLeafIcon(folderIcon);
        navigationTree.setCellRenderer(renderer);
        for (MailFolder folder : foldersToExpand) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodesByFolder.get(folder);
            navigationTree.expandPath(new TreePath(node.getPath()));
        }
        return nodesByFolder;
    }

    protected static Map<MailFolder, DefaultMutableTreeNode> createFolderTree(DefaultMutableTreeNode parent, MailFolder folder) {
        HashMap<MailFolder, DefaultMutableTreeNode> result = new HashMap<MailFolder, DefaultMutableTreeNode>();
        FolderTreeNode node = new FolderTreeNode(folder);
        result.put(folder, node);
        parent.add(node);
        if (folder.isChildrenNotEmpty()) {
            ArrayList children = new ArrayList(folder.getChildren());
            Collections.sort(children, new Comparator<MailFolder>(){

                @Override
                public int compare(MailFolder o1, MailFolder o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (MailFolder child : children) {
                result.putAll(FaxToMailUIUtil.createFolderTree(node, child));
            }
        }
        return result;
    }

    public static Map<String, Integer> computeQuantities(Collection<RangeRowModel> rangeRows) {
        int quotationNb = 0;
        int pfNb = 0;
        int savNb = 0;
        for (RangeRowModel rangeRow : rangeRows) {
            Integer savQuantity;
            Integer productQuantity;
            if (!rangeRow.isValid()) continue;
            Integer quotationQuantity = rangeRow.getQuotationQuantity();
            if (quotationQuantity != null) {
                quotationNb += quotationQuantity.intValue();
            }
            if ((productQuantity = rangeRow.getProductQuantity()) != null) {
                pfNb += productQuantity.intValue();
            }
            if ((savQuantity = rangeRow.getSavQuantity()) == null) continue;
            savNb += savQuantity.intValue();
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("quotationNb", quotationNb);
        result.put("pfNb", pfNb);
        result.put("savNb", savNb);
        return result;
    }

    public static boolean isFileAPDF(AttachmentFile file) {
        return FileUtil.extension((String)file.getFilename(), (String[])new String[0]).toUpperCase().equals("PDF");
    }

    public static boolean isFileATxt(AttachmentFile file) {
        return FileUtil.extension((String)file.getFilename(), (String[])new String[0]).toUpperCase().equals("TXT");
    }

    public static boolean isFileATif(AttachmentFile file) {
        return FileUtil.extension((String)file.getFilename(), (String[])new String[0]).toUpperCase().equals("TIF");
    }

    public static void setEmailContentInTextPane(JTextPane textPane, DemandeUIModel demandeUIModel) {
        String content = demandeUIModel.getHtmlContent();
        if (content != null) {
            textPane.setContentType("text/html");
            HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
            textPane.setEditorKit(htmlEditorKit);
            textPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        FaxToMailUIUtil.openLink((URL)e.getURL());
                    }
                }
            });
            content = content.replaceAll("<meta (.*?)>(</meta>)?", "");
            Iterator<Attachment> i$ = demandeUIModel.getAttachment().iterator();
            if (i$.hasNext()) {
                Attachment attachment = i$.next();
                AttachmentFile file = attachment.getOriginalFile();
                log.info((Object)("file " + file.getFilename()));
                String key = file.getFilename();
                throw new RuntimeException("Fix it");
            }
        } else {
            content = demandeUIModel.getPlainContent();
        }
        textPane.setText(content);
    }

    public static Desktop getDesktopForPrint() {
        if (!Desktop.isDesktopSupported()) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.desktop.not.supported", (Object[])new Object[0]));
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.PRINT)) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.desktop.print.not.supported", (Object[])new Object[0]));
        }
        return desktop;
    }

    public static void print(AttachmentFile attachmentFile, boolean defaultPrinter) {
        try {
            FileInputStream textStream = new FileInputStream(attachmentFile.getFile());
            DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            SimpleDoc mydoc = new SimpleDoc(textStream, flavor, null);
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, aset);
            PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
            if (defaultPrinter) {
                DocPrintJob job;
                if (defaultService == null) {
                    if (services.length == 0) {
                        throw new ApplicationBusinessException(I18n.t((String)"jaxx.application.error.noPrinter", (Object[])new Object[0]));
                    }
                    job = services[0].createPrintJob();
                } else {
                    job = defaultService.createPrintJob();
                }
                job.print(mydoc, aset);
            } else {
                if (services.length == 0) {
                    if (defaultService == null) {
                        throw new ApplicationBusinessException(I18n.t((String)"jaxx.application.error.noPrinter", (Object[])new Object[0]));
                    }
                    services = new PrintService[]{defaultService};
                }
                PrintService service = ServiceUI.printDialog(null, 200, 200, services, defaultService, flavor, aset);
                System.out.print("service " + service);
                if (service != null) {
                    DocPrintJob job = service.createPrintJob();
                    job.print(mydoc, aset);
                }
            }
        }
        catch (IOException | PrintException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.cannot.print", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static String getEditedFileName(AttachmentFile originalFile) {
        return I18n.t((String)"faxtomail.attachment.editedFile.name", (Object[])new Object[]{originalFile.getFilename()}) + "-.pdf";
    }
}

