package com.franciaflex.faxtomail.ui.swing.util;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Franciaflex
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeRowModel;

import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.util.ApplicationUIUtil;
import org.nuiton.util.FileUtil;

import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.*;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import java.awt.*;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n.t;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public final class FaxToMailUIUtil extends ApplicationUIUtil {

    /** Logger. */
    private static final Log log = LogFactory.getLog(FaxToMailUIUtil.class);

    private FaxToMailUIUtil() {
        // never instanciate util class
    }

    public static FaxToMailUIContext getApplicationContext(JAXXObject ui) {
        return (FaxToMailUIContext) ApplicationUIUtil.getApplicationContext(ui);
    }

    public static void setParentUI(JAXXObject ui, FaxToMailUI<?, ?> parentUI) {
        JAXXUtil.initContext(ui, parentUI);
        setApplicationContext(ui, parentUI.getHandler().getContext());
    }

    public static Map<MailFolder, DefaultMutableTreeNode> initFolderTree(FaxToMailUIContext context,
                                                                         JTree navigationTree,
                                                                         Collection<MailFolder> folders) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");

        List<MailFolder> foldersToExpand = context.getExpandedFolders();
        Map<MailFolder, DefaultMutableTreeNode> nodesByFolder = new HashMap<MailFolder, DefaultMutableTreeNode>();
        for (MailFolder folder : folders) {
            nodesByFolder.putAll(FaxToMailUIUtil.createFolderTree(root, folder));
        }

        TreeModel treeModel = new DefaultTreeModel(root);
        navigationTree.setModel(treeModel);

        // use the folder icon for the leaf
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        Icon folderIcon = renderer.getDefaultClosedIcon();
        renderer.setLeafIcon(folderIcon);
        navigationTree.setCellRenderer(renderer);

        // expand nodes
        for (MailFolder folder : foldersToExpand) {
            DefaultMutableTreeNode node = nodesByFolder.get(folder);
            navigationTree.expandPath(new TreePath(node.getPath()));
        }

        return nodesByFolder;
    }

    /**
     * Creates the tree nodes and returns a map of the nodes by folder
     * @param parent the node parent
     * @param folder the folder to add to the tree
     * @return the map of the nodes by folder
     */
    protected static Map<MailFolder, DefaultMutableTreeNode> createFolderTree(DefaultMutableTreeNode parent,
                                                                              MailFolder folder) {
        Map<MailFolder, DefaultMutableTreeNode> result = new HashMap<MailFolder, DefaultMutableTreeNode>();

        DefaultMutableTreeNode node = new FolderTreeNode(folder);
        result.put(folder, node);

        parent.add(node);
        if (folder.isChildrenNotEmpty()) {
            List<MailFolder> children = new ArrayList<MailFolder>(folder.getChildren());
            Collections.sort(children, new Comparator<MailFolder>() {
                @Override
                public int compare(MailFolder o1, MailFolder o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (MailFolder child : children) {
                result.putAll(createFolderTree(node, child));
            }
        }
        return result;
    }

    public static Map<String, Integer> computeQuantities(Collection<RangeRowModel> rangeRows) {
        int quotationNb = 0;
        int pfNb = 0;
        int savNb = 0;
        for (RangeRowModel rangeRow : rangeRows) {
            if (rangeRow.isValid()) {
                Integer quotationQuantity = rangeRow.getQuotationQuantity();
                if (quotationQuantity != null) {
                    quotationNb += quotationQuantity;
                }

                Integer productQuantity = rangeRow.getProductQuantity();
                if (productQuantity != null) {
                    pfNb += productQuantity;
                }

                Integer savQuantity = rangeRow.getSavQuantity();
                if (savQuantity != null) {
                    savNb += savQuantity;
                }
            }
        }
        Map<String, Integer> result = new HashMap<String, Integer>();
        result.put(DemandeUIModel.PROPERTY_QUOTATION_NB, quotationNb);
        result.put(DemandeUIModel.PROPERTY_PF_NB, pfNb);
        result.put(DemandeUIModel.PROPERTY_SAV_NB, savNb);
        return result;
    }

    /*public static boolean isFileAPDF(File file) {
        return FileUtil.extension(file).toUpperCase().equals("PDF");
    }

    public static boolean isFileATxt(File file) {
        return FileUtil.extension(file).toUpperCase().equals("TXT");
    }

    public static boolean isFileATif(File file) {
        return FileUtil.extension(file).toUpperCase().equals("TIF");
    }*/

    public static boolean isFileAPDF(AttachmentFile file) {
        return FileUtil.extension(file.getFilename()).toUpperCase().equals("PDF");
    }

    public static boolean isFileATxt(AttachmentFile file) {
        return FileUtil.extension(file.getFilename()).toUpperCase().equals("TXT");
    }

    public static boolean isFileATif(AttachmentFile file) {
        return FileUtil.extension(file.getFilename()).toUpperCase().equals("TIF");
    }

    public static void setEmailContentInTextPane(JTextPane textPane, DemandeUIModel demandeUIModel) {
        String content = demandeUIModel.getHtmlContent();
        if (content != null) {
            textPane.setContentType("text/html");

            HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
            textPane.setEditorKit(htmlEditorKit);
            textPane.addHyperlinkListener(new HyperlinkListener() {
                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        FaxToMailUIUtil.openLink(e.getURL());
                    }
                }
            });

            // the meta tag makes the content is not displayed
            content = content.replaceAll("<meta (.*?)>(</meta>)?", "");

            for (Attachment attachment : demandeUIModel.getAttachment()) {
                AttachmentFile file = attachment.getOriginalFile();
                log.info("file " + file.getFilename());
                String key = file.getFilename();
                // replace the inline attachments with the extracted attachment file url
                //content = content.replaceAll("<img src=\"cid:" + key + "\"(.*?>)", "<img src=\"file://" + file.getAbsolutePath() + "\"$1");
                throw new RuntimeException("Fix it");
            }

        } else {
            content = demandeUIModel.getPlainContent();
        }
        textPane.setText(content);
    }

    public static Desktop getDesktopForPrint() {

        if (!Desktop.isDesktopSupported()) {
            throw new ApplicationTechnicalException(
                    t("jaxx.application.error.desktop.not.supported"));
        }

        Desktop desktop = Desktop.getDesktop();

        if (!desktop.isSupported(Desktop.Action.PRINT)) {

            throw new ApplicationTechnicalException(
                    t("jaxx.application.error.desktop.print.not.supported"));
        }

        return desktop;
    }

    public static void print(AttachmentFile attachmentFile, boolean defaultPrinter) {

        try {
            FileInputStream textStream = new FileInputStream(attachmentFile.getFile());

            DocFlavor flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            Doc mydoc = new SimpleDoc(textStream, flavor, null);

            PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();

            PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, aset);
            PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();

            if (defaultPrinter) {
                DocPrintJob job;

                if (defaultService == null) {
                    if (services.length == 0) {
                        throw new ApplicationBusinessException(t("jaxx.application.error.noPrinter"));
                    }
                    job = services[0].createPrintJob();

                } else {
                    job = defaultService.createPrintJob();
                }
                job.print(mydoc, aset);

            } else {

                if (services.length == 0) {
                    if(defaultService == null) {
                        throw new ApplicationBusinessException(t("jaxx.application.error.noPrinter"));

                    } else {
                        services = new PrintService[] {
                                defaultService
                        };
                    }
                }

                //built in UI for printing you may not use this
                PrintService service = ServiceUI.printDialog(null, 200, 200, services, defaultService, flavor, aset);

                System.out.print("service " + service);
                if (service != null) {
                    DocPrintJob job = service.createPrintJob();
                    job.print(mydoc, aset);
                }
            }

        } catch (PrintException | IOException e) {

            throw new ApplicationTechnicalException(
                    t("jaxx.application.error.cannot.print"), e);
        }

    }

    public static String getEditedFileName(AttachmentFile originalFile) {
        return t("faxtomail.attachment.editedFile.name", originalFile.getFilename()) + "-.pdf";
    }
}
