package com.franciaflex.faxtomail.ui.swing.content.search;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.HasLabel;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class SearchUI extends JPanel implements FaxToMailUI<SearchUIModel, SearchUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ARCHIVED_BETWEEN_END_DATE_PICKER_DATE = "archivedBetweenEndDatePicker.date";
    public static final String BINDING_ARCHIVED_BETWEEN_START_DATE_PICKER_DATE = "archivedBetweenStartDatePicker.date";
    public static final String BINDING_ARCHIVED_BY_COMBO_BOX_SELECTED_ITEM = "archivedByComboBox.selectedItem";
    public static final String BINDING_BODY_FIELD_TEXT = "bodyField.text";
    public static final String BINDING_EDI_CODE_NUMBER_FIELD_TEXT = "ediCodeNumberField.text";
    public static final String BINDING_GO_TO_FOLDER_MENU_ENABLED = "goToFolderMenu.enabled";
    public static final String BINDING_LOCAL_REFERENCE_FIELD_TEXT = "localReferenceField.text";
    public static final String BINDING_MESSAGE_FIELD_TEXT = "messageField.text";
    public static final String BINDING_MODIFIED_BETWEEN_END_DATE_PICKER_DATE = "modifiedBetweenEndDatePicker.date";
    public static final String BINDING_MODIFIED_BETWEEN_START_DATE_PICKER_DATE = "modifiedBetweenStartDatePicker.date";
    public static final String BINDING_MODIFIED_BY_COMBO_BOX_SELECTED_ITEM = "modifiedByComboBox.selectedItem";
    public static final String BINDING_OBJECT_FIELD_TEXT = "objectField.text";
    public static final String BINDING_PRINTED_BETWEEN_END_DATE_PICKER_DATE = "printedBetweenEndDatePicker.date";
    public static final String BINDING_PRINTED_BETWEEN_START_DATE_PICKER_DATE = "printedBetweenStartDatePicker.date";
    public static final String BINDING_PRINTED_BY_COMBO_BOX_SELECTED_ITEM = "printedByComboBox.selectedItem";
    public static final String BINDING_PROJECT_REFERENCE_FIELD_TEXT = "projectReferenceField.text";
    public static final String BINDING_RECEIVED_BETWEEN_END_DATE_PICKER_DATE = "receivedBetweenEndDatePicker.date";
    public static final String BINDING_RECEIVED_BETWEEN_START_DATE_PICKER_DATE = "receivedBetweenStartDatePicker.date";
    public static final String BINDING_REPLIED_BETWEEN_END_DATE_PICKER_DATE = "repliedBetweenEndDatePicker.date";
    public static final String BINDING_REPLIED_BETWEEN_START_DATE_PICKER_DATE = "repliedBetweenStartDatePicker.date";
    public static final String BINDING_REPLIED_BY_COMBO_BOX_SELECTED_ITEM = "repliedByComboBox.selectedItem";
    public static final String BINDING_SENDER_FIELD_TEXT = "senderField.text";
    public static final String BINDING_TAKEN_BY_COMBO_BOX_SELECTED_ITEM = "takenByComboBox.selectedItem";
    public static final String BINDING_TRANSFER_BETWEEN_END_DATE_PICKER_DATE = "transferBetweenEndDatePicker.date";
    public static final String BINDING_TRANSFER_BETWEEN_START_DATE_PICKER_DATE = "transferBetweenStartDatePicker.date";
    public static final String BINDING_TRANSFER_BY_COMBO_BOX_SELECTED_ITEM = "transferByComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVazXMdRxEfK5JtfVhyrFhYWFIU26Scy8oYcsFAIskSWCUlKulRuNAhzNsdSWvv29nszrOeSmWKA9yp4h+AMxwIxQ0OUKTgzIELlX8hRXHgStEzu293Z3dmdvQ2h5dkp+fX3b/p+ehu/fZLNJHE6J0XeDBw4n7I/B5xdtafP/+4+4K47ClJ3NiPGI1R+s+VMTR2hKa9/HvC0P2jXT59LZu+tkl7EQ1JWJr9ZBdNJew8IMkpIYyhZXmGmyRrh/nwk0HUj4eouVEq1F/9599jv/B++usxhAYRWLcLrqw2zSo8Gd9FY77H0C3Q9AqvBTg8ATNiPzwBe2/wb5sBTpKPcI98in6Cru2iqxGOAYyhe/YuCwwxfxAxNJ0QHLun+zgkAUPfcmnPOY5x6Pr4OCAD5xgPGO1hP3D6vpOcgSmOS0MGyE460TkU//rBsygSoFcZmuhRj4N9MDrYHkcoEKcY7gZkn0Z9sHiBEzHI5u+Ij3sk7BfSsye0Q7dp4JGYDzB0W5rBvz1jpMel5/JJMw92DqPAZ5yIR1Ul+QgXnsznXH+wI3gD+VuyUfwrF7qdy95MPTx0YxoEfJyhr8g68hE+404+8dqDDncedNyRIimdJsa45N18wlsxcYn/ingbhJ0REu7iLl8N2ULxkU9YyeetVOYdMhyzp5iRfd99SWKGVml84ryArfaS0SgFGjg7zwsRGQ/YEVoe8f+/L8YYmu+m4I9Dbx/ghcBwwlLFgK3Qk7HflRXMMPyShBvnuS/35fG5bBw2Q5du0AFD7ysYJJ4Pu8PpEhw6G/Cz7QeMxJzW4TwZ9S2Ibv/Yl+lVaF+pyFXoVPgzJOzr1oRVVDQRNpfLazm7VYiU3X9U4YDBrk6OSdzEQUXOnoPH1hxUVDRykMvrOShETBzw7VzdZioOKnL2HHzDmoOKikYOcnk9B4WIgYP5CC4n1kjBsixmz8A3bRm4K2toImB2KK71/81cwuR+TOBiaHZfFrN3/31r92UNje4PxfXu5xIG9+HpEMIdq8PIhrd9EnjVC7VDBkwMyFOmTnCvR3SAN8RocZrL17r6tJ6m4t2otTEdzk15VblhPOp2ziOtRXPZeFn3RWUjwf2yCa+Zj/q9rp4rWUpnzu0optzcAwKHEwldrV01QR3iDQhzGvtMGwg3hwIGF6cThlk/0UHMpsMGgJsEJNYZfwhqXZovyRigZnokSfCJFmY4riNk2oWwD/Xxkg7rZk92qaelUgzqZs4H1MVB48JWxHRoi9jzvhfTfkS8rYD0wOLNU+K+7Cp2Df9e2zXDh614iXyV/xTv0Zn0IbvRZwze7mhegku/csnf1MAe52DFq/jGg9K7Vxwvy/zndwVpHmZYPHLhlFO/P/Mn8O8jSLfuSk88SOScIpErMq0rR2gi7sNneFUf1XO/AxhKs747layPA4rR/y3M//OPX/xhe5jqbYPu20rRUqYKKRjszAge0z5XPZfmeX3mB2t7OHpyhCYTEsC+FWnsksKww2wYjAN9b/LpDp/ufB8npwAxce1ff/nrwo//8QYa20ZTAcXeNubyz9AkO42BBciKBtEHHwqLZs6uw+9NbhucQJAudmjfPd0aRDj0UsbHWdwnA6BhSUFDbkt38u//nT/87MMhFVfAtEWteEHHxI/QVT8M/JCIvJcv4TVNnjsdJaTv0SJ1VSWzCJLDqSJXyxLCP4nfP9d8fgOiD/g4e0pcGmMwDBLXYxwk3G2eDEDmdSES2dcQhVzwgCS8VJBxwkE/F87y//ob172gTh8a7ADuZz9Jl/3jcJu6fVj6qxdcyWullplyxtWMPc7gqmXoa0XunaXa8nPCCfiJo1AYRYanh07vOJBHQk4C3PyLF6uCR8dPeOq9lX5/+N7q69y6ezXrIGp9GjonlGWZPCxt+u0ZLxmg8cBPYOI0ozTo+FFHwLzbDOMwP6p7WasZRNbEvl3o9EgPdg5xsrRTR2klcW1SNSaOXB4exONlC4izIaEnhHVSpJTN69nhcg70ZypU6qt5sb2zdYIrGajeZ2XabKMZLgDYkvdKPu/54Z4AczFfXb4buP8qrQ1J+Ij68cBWvzFDt+f9HT3vhjCrpvuXj7TFstc5WC3YpgpFKjsUNYU2IVdJ+A0hp6pS2C/5ihxynQzMGG7meseIuvHARrexEGLP9z3FeZaXQwyxVimrtIu1Tg5Wj7VCkTLW6rWbNrFWqUgaYk1VdLVf77flWDsAsKjxbDPXa0dUjgdWyo212jaMV0pZBsZV9beRd/d6BmYk3FzJG3l32+g2lvha7e6i0GfY3ZWCYbvdvZ6D1Xd3oUi5u+tVSXvf609guWiod19V5hw50vY5FqSuptU2F0xHDjQb1aZK6kgPlmGc5QVVPc+Vsmy7KBs6q4qyKB9TmVGv/bYJMrk0awgyRTHZfqXvVi+QKDg3RpixJj2iXn53NOg1VapbhVdesDaEl1z2bpd4CU9ViVecDigDq1ZVt3d5pe5yWrvW+1uufdsrWrzIfXwqFKV/efHwPeV6lgvorZxJmwUGZ0rNBntF84Uzh2K+zo1Sr6KVG2l92OBGqb7cqsiQdR4MRYZy72KkA2yoSupN6BUqOh0WWyxTu1TaWltlnGyD8S59WpNMi3TNBlxyLVeVN5Zofehdltsn7eJfNElM8V80WewV3VesZtFH0WurdWTsVT5UESl3o/R61R2uS2wU6QEgQ+muJHWzbKQcZuiw3KUx3PmKro+94uWSs7sSkM5VVfuo1Snk0l7PeN5J/Th7VeWbdi9F0PkkdfTsNSzVneH9Ob0nRW/vMtdP4cYGTNf5ULQGWx3UfDXgPxoPaknuki6VD+rNMo7ON1nbJZ1crjsp/ghA71zpTwhGOrOGZYhqA1WvUd9stb/+luvtGdFJTbUCiZ/gCJ6OacF5XTQ1GFq/WLX4C8u0BZJkf1qZzoVnCk4SzX4q93ctPJjHfUY3YwLP+AN6dkhjxps1oksm3duavlm5xWuxYFcDfE7BNDT7bT5tteuHHnj53RrwFf47ZYE4DRc4rJlgFoTGfq6GWmiE4pN/ZkBYtDDmOu888lebAWfNypJfGhC+0xphpzXCD1sjNB8jTQiftl7TzwDh/ypeSrSzLgAA";
    private static final Log log = LogFactory.getLog(SearchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox addGroupedElementCheckbox;
    protected JXDatePicker archivedBetweenEndDatePicker;
    protected JLabel archivedBetweenLabel;
    protected JXDatePicker archivedBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> archivedByComboBox;
    protected JLabel archivedByLabel;
    protected JTextField bodyField;
    protected JLabel bodyLabel;
    protected JTextField clientField;
    protected JLabel clientLabel;
    protected JXTable dataTable;
    protected JComboBox docTypeComboBox;
    protected JLabel docTypeLabel;
    protected JTextField ediCodeNumberField;
    protected JLabel ediCodeNumberLabel;
    protected JComboBox etatAttenteComboBox;
    protected JLabel etatAttenteLabel;
    protected JComboBox gammeComboBox;
    protected JLabel gammeLabel;
    protected JMenuItem goToFolderMenu;
    protected final SearchUIHandler handler = new SearchUIHandler();
    protected JTextField localReferenceField;
    protected JLabel localReferenceLabel;
    protected JTextField messageField;
    protected JLabel messageLabel;
    protected SearchUIModel model;
    protected JXDatePicker modifiedBetweenEndDatePicker;
    protected JLabel modifiedBetweenLabel;
    protected JXDatePicker modifiedBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> modifiedByComboBox;
    protected JLabel modifiedByLabel;
    protected JTextField objectField;
    protected JLabel objectLabel;
    protected JXDatePicker printedBetweenEndDatePicker;
    protected JLabel printedBetweenLabel;
    protected JXDatePicker printedBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> printedByComboBox;
    protected JLabel printedByLabel;
    protected JComboBox priorityComboBox;
    protected JLabel priorityLabel;
    protected JTextField projectReferenceField;
    protected JLabel projectReferenceLabel;
    protected JXDatePicker receivedBetweenEndDatePicker;
    protected JLabel receivedBetweenLabel;
    protected JXDatePicker receivedBetweenStartDatePicker;
    protected JXDatePicker repliedBetweenEndDatePicker;
    protected JLabel repliedBetweenLabel;
    protected JXDatePicker repliedBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> repliedByComboBox;
    protected JLabel repliedByLabel;
    protected JButton searchButton;
    protected SearchUI searchPanel = this;
    protected JScrollPane searchScrollPane;
    protected JTextField senderField;
    protected JLabel senderLabel;
    protected JComboBox statusComboBox;
    protected JLabel statusLabel;
    protected JPopupMenu tablePopup;
    protected BeanFilterableComboBox<FaxToMailUser> takenByComboBox;
    protected JLabel takenByLabel;
    protected JXDatePicker transferBetweenEndDatePicker;
    protected JLabel transferBetweenLabel;
    protected JXDatePicker transferBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> transferByComboBox;
    protected JLabel transferByLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JScrollPane $JScrollPane0;
    private JSplitPane $JSplitPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SearchUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public SearchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SearchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SearchUI() {
        $initialize();
    }

    public SearchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SearchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SearchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SearchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SearchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__archivedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxArchivedDate(archivedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__archivedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinArchivedDate(archivedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__goToFolderMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.goToMenu();
    }

    public void doActionPerformed__on__modifiedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxModificationDate(modifiedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__modifiedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinModificationDate(modifiedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__printedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxPrintingDate(printedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__printedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinPrintingDate(printedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__receivedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxReceptionDate(receivedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__receivedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinReceptionDate(receivedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__repliedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxReplyDate(repliedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__repliedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinReplyDate(repliedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__transferBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxTransferDate(transferBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__transferBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinTransferDate(transferBetweenStartDatePicker.getDate());
    }

    public void doItemStateChanged__on__addGroupedElementCheckbox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "showGroupesDemandsInResults");
    }

    public void doKeyPressed__on__dataTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doKeyReleased__on__bodyField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "body");
    }

    public void doKeyReleased__on__clientField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "clientCode");
    }

    public void doKeyReleased__on__ediCodeNumberField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "ediCodeNumber");
    }

    public void doKeyReleased__on__localReferenceField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "localReference");
    }

    public void doKeyReleased__on__messageField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "message");
    }

    public void doKeyReleased__on__objectField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "demandObject");
    }

    public void doKeyReleased__on__projectReferenceField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "projectReference");
    }

    public void doKeyReleased__on__senderField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "sender");
    }

    public void doMouseClicked__on__dataTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAddGroupedElementCheckbox() {
        return addGroupedElementCheckbox;
    }

    public JXDatePicker getArchivedBetweenEndDatePicker() {
        return archivedBetweenEndDatePicker;
    }

    public JLabel getArchivedBetweenLabel() {
        return archivedBetweenLabel;
    }

    public JXDatePicker getArchivedBetweenStartDatePicker() {
        return archivedBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getArchivedByComboBox() {
        return archivedByComboBox;
    }

    public JLabel getArchivedByLabel() {
        return archivedByLabel;
    }

    public JTextField getBodyField() {
        return bodyField;
    }

    public JLabel getBodyLabel() {
        return bodyLabel;
    }

    public JTextField getClientField() {
        return clientField;
    }

    public JLabel getClientLabel() {
        return clientLabel;
    }

    public JXTable getDataTable() {
        return dataTable;
    }

    public JComboBox getDocTypeComboBox() {
        return docTypeComboBox;
    }

    public JLabel getDocTypeLabel() {
        return docTypeLabel;
    }

    public JTextField getEdiCodeNumberField() {
        return ediCodeNumberField;
    }

    public JLabel getEdiCodeNumberLabel() {
        return ediCodeNumberLabel;
    }

    public JComboBox getEtatAttenteComboBox() {
        return etatAttenteComboBox;
    }

    public JLabel getEtatAttenteLabel() {
        return etatAttenteLabel;
    }

    public JComboBox getGammeComboBox() {
        return gammeComboBox;
    }

    public JLabel getGammeLabel() {
        return gammeLabel;
    }

    public JMenuItem getGoToFolderMenu() {
        return goToFolderMenu;
    }

    public SearchUIHandler getHandler() {
        return handler;
    }

    public JTextField getLocalReferenceField() {
        return localReferenceField;
    }

    public JLabel getLocalReferenceLabel() {
        return localReferenceLabel;
    }

    public JTextField getMessageField() {
        return messageField;
    }

    public JLabel getMessageLabel() {
        return messageLabel;
    }

    public SearchUIModel getModel() {
        return model;
    }

    public JXDatePicker getModifiedBetweenEndDatePicker() {
        return modifiedBetweenEndDatePicker;
    }

    public JLabel getModifiedBetweenLabel() {
        return modifiedBetweenLabel;
    }

    public JXDatePicker getModifiedBetweenStartDatePicker() {
        return modifiedBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getModifiedByComboBox() {
        return modifiedByComboBox;
    }

    public JLabel getModifiedByLabel() {
        return modifiedByLabel;
    }

    public JTextField getObjectField() {
        return objectField;
    }

    public JLabel getObjectLabel() {
        return objectLabel;
    }

    public JXDatePicker getPrintedBetweenEndDatePicker() {
        return printedBetweenEndDatePicker;
    }

    public JLabel getPrintedBetweenLabel() {
        return printedBetweenLabel;
    }

    public JXDatePicker getPrintedBetweenStartDatePicker() {
        return printedBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getPrintedByComboBox() {
        return printedByComboBox;
    }

    public JLabel getPrintedByLabel() {
        return printedByLabel;
    }

    public JComboBox getPriorityComboBox() {
        return priorityComboBox;
    }

    public JLabel getPriorityLabel() {
        return priorityLabel;
    }

    public JTextField getProjectReferenceField() {
        return projectReferenceField;
    }

    public JLabel getProjectReferenceLabel() {
        return projectReferenceLabel;
    }

    public JXDatePicker getReceivedBetweenEndDatePicker() {
        return receivedBetweenEndDatePicker;
    }

    public JLabel getReceivedBetweenLabel() {
        return receivedBetweenLabel;
    }

    public JXDatePicker getReceivedBetweenStartDatePicker() {
        return receivedBetweenStartDatePicker;
    }

    public JXDatePicker getRepliedBetweenEndDatePicker() {
        return repliedBetweenEndDatePicker;
    }

    public JLabel getRepliedBetweenLabel() {
        return repliedBetweenLabel;
    }

    public JXDatePicker getRepliedBetweenStartDatePicker() {
        return repliedBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getRepliedByComboBox() {
        return repliedByComboBox;
    }

    public JLabel getRepliedByLabel() {
        return repliedByLabel;
    }

    public JButton getSearchButton() {
        return searchButton;
    }

    public JScrollPane getSearchScrollPane() {
        return searchScrollPane;
    }

    public JTextField getSenderField() {
        return senderField;
    }

    public JLabel getSenderLabel() {
        return senderLabel;
    }

    public JComboBox getStatusComboBox() {
        return statusComboBox;
    }

    public JLabel getStatusLabel() {
        return statusLabel;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public BeanFilterableComboBox<FaxToMailUser> getTakenByComboBox() {
        return takenByComboBox;
    }

    public JLabel getTakenByLabel() {
        return takenByLabel;
    }

    public JXDatePicker getTransferBetweenEndDatePicker() {
        return transferBetweenEndDatePicker;
    }

    public JLabel getTransferBetweenLabel() {
        return transferBetweenLabel;
    }

    public JXDatePicker getTransferBetweenStartDatePicker() {
        return transferBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getTransferByComboBox() {
        return transferByComboBox;
    }

    public JLabel getTransferByLabel() {
        return transferByLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSearchPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($JSplitPane0, BorderLayout.CENTER);
    }

    protected void addChildrenToSearchScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        searchScrollPane.getViewport().add($Table0);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(goToFolderMenu);
    }

    protected void createAddGroupedElementCheckbox() {
        $objectMap.put("addGroupedElementCheckbox", addGroupedElementCheckbox = new JCheckBox());
        
        addGroupedElementCheckbox.setName("addGroupedElementCheckbox");
        addGroupedElementCheckbox.setText(t("faxtomail.search.addGroupedElement.label"));
        addGroupedElementCheckbox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__addGroupedElementCheckbox"));
    }

    protected void createArchivedBetweenEndDatePicker() {
        $objectMap.put("archivedBetweenEndDatePicker", archivedBetweenEndDatePicker = new JXDatePicker());
        
        archivedBetweenEndDatePicker.setName("archivedBetweenEndDatePicker");
        archivedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__archivedBetweenEndDatePicker"));
        archivedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createArchivedBetweenLabel() {
        $objectMap.put("archivedBetweenLabel", archivedBetweenLabel = new JLabel());
        
        archivedBetweenLabel.setName("archivedBetweenLabel");
        archivedBetweenLabel.setText(t("faxtomail.search.archivedBetween.label"));
    }

    protected void createArchivedBetweenStartDatePicker() {
        $objectMap.put("archivedBetweenStartDatePicker", archivedBetweenStartDatePicker = new JXDatePicker());
        
        archivedBetweenStartDatePicker.setName("archivedBetweenStartDatePicker");
        archivedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__archivedBetweenStartDatePicker"));
        archivedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createArchivedByComboBox() {
        $objectMap.put("archivedByComboBox", archivedByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        archivedByComboBox.setName("archivedByComboBox");
        archivedByComboBox.setShowDecorator(false);
        archivedByComboBox.setProperty("archivedBy");
        archivedByComboBox.setShowReset(true);
    }

    protected void createArchivedByLabel() {
        $objectMap.put("archivedByLabel", archivedByLabel = new JLabel());
        
        archivedByLabel.setName("archivedByLabel");
        archivedByLabel.setText(t("faxtomail.demande.archivedBy.label"));
    }

    protected void createBodyField() {
        $objectMap.put("bodyField", bodyField = new JTextField());
        
        bodyField.setName("bodyField");
        bodyField.setColumns(15);
        bodyField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__bodyField"));
    }

    protected void createBodyLabel() {
        $objectMap.put("bodyLabel", bodyLabel = new JLabel());
        
        bodyLabel.setName("bodyLabel");
        bodyLabel.setText(t("faxtomail.demande.body.label"));
    }

    protected void createClientField() {
        $objectMap.put("clientField", clientField = new JTextField());
        
        clientField.setName("clientField");
        clientField.setColumns(15);
        clientField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientField"));
    }

    protected void createClientLabel() {
        $objectMap.put("clientLabel", clientLabel = new JLabel());
        
        clientLabel.setName("clientLabel");
        clientLabel.setText(t("faxtomail.demande.client.label"));
    }

    protected void createDataTable() {
        $objectMap.put("dataTable", dataTable = new JXTable());
        
        dataTable.setName("dataTable");
        dataTable.setEditable(true);
        dataTable.setAutoCreateRowSorter(true);
        dataTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__dataTable"));
        dataTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__dataTable"));
    }

    protected void createDocTypeComboBox() {
        $objectMap.put("docTypeComboBox", docTypeComboBox = new JComboBox());
        
        docTypeComboBox.setName("docTypeComboBox");
    }

    protected void createDocTypeLabel() {
        $objectMap.put("docTypeLabel", docTypeLabel = new JLabel());
        
        docTypeLabel.setName("docTypeLabel");
        docTypeLabel.setText(t("faxtomail.demande.docType.label"));
    }

    protected void createEdiCodeNumberField() {
        $objectMap.put("ediCodeNumberField", ediCodeNumberField = new JTextField());
        
        ediCodeNumberField.setName("ediCodeNumberField");
        ediCodeNumberField.setColumns(15);
        ediCodeNumberField.setEditable(false);
        ediCodeNumberField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__ediCodeNumberField"));
    }

    protected void createEdiCodeNumberLabel() {
        $objectMap.put("ediCodeNumberLabel", ediCodeNumberLabel = new JLabel());
        
        ediCodeNumberLabel.setName("ediCodeNumberLabel");
        ediCodeNumberLabel.setText(t("faxtomail.demande.ediCodeNumber.label"));
    }

    protected void createEtatAttenteComboBox() {
        $objectMap.put("etatAttenteComboBox", etatAttenteComboBox = new JComboBox());
        
        etatAttenteComboBox.setName("etatAttenteComboBox");
    }

    protected void createEtatAttenteLabel() {
        $objectMap.put("etatAttenteLabel", etatAttenteLabel = new JLabel());
        
        etatAttenteLabel.setName("etatAttenteLabel");
        etatAttenteLabel.setText(t("faxtomail.demande.etatAttente.label"));
    }

    protected void createGammeComboBox() {
        $objectMap.put("gammeComboBox", gammeComboBox = new JComboBox());
        
        gammeComboBox.setName("gammeComboBox");
    }

    protected void createGammeLabel() {
        $objectMap.put("gammeLabel", gammeLabel = new JLabel());
        
        gammeLabel.setName("gammeLabel");
        gammeLabel.setText(t("faxtomail.demande.gamme.label"));
    }

    protected void createGoToFolderMenu() {
        $objectMap.put("goToFolderMenu", goToFolderMenu = new JMenuItem());
        
        goToFolderMenu.setName("goToFolderMenu");
        goToFolderMenu.setText(t("faxtomail.search.action.gotoFolder"));
        goToFolderMenu.setToolTipText(t("faxtomail.search.action.gotoFolder.tip"));
        goToFolderMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__goToFolderMenu"));
    }

    protected void createLocalReferenceField() {
        $objectMap.put("localReferenceField", localReferenceField = new JTextField());
        
        localReferenceField.setName("localReferenceField");
        localReferenceField.setColumns(15);
        localReferenceField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__localReferenceField"));
    }

    protected void createLocalReferenceLabel() {
        $objectMap.put("localReferenceLabel", localReferenceLabel = new JLabel());
        
        localReferenceLabel.setName("localReferenceLabel");
        localReferenceLabel.setText(t("faxtomail.demande.localReference.label"));
    }

    protected void createMessageField() {
        $objectMap.put("messageField", messageField = new JTextField());
        
        messageField.setName("messageField");
        messageField.setColumns(15);
        messageField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__messageField"));
    }

    protected void createMessageLabel() {
        $objectMap.put("messageLabel", messageLabel = new JLabel());
        
        messageLabel.setName("messageLabel");
        messageLabel.setText(t("faxtomail.demande.comment.label"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SearchUIModel.class));
    }

    protected void createModifiedBetweenEndDatePicker() {
        $objectMap.put("modifiedBetweenEndDatePicker", modifiedBetweenEndDatePicker = new JXDatePicker());
        
        modifiedBetweenEndDatePicker.setName("modifiedBetweenEndDatePicker");
        modifiedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__modifiedBetweenEndDatePicker"));
        modifiedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createModifiedBetweenLabel() {
        $objectMap.put("modifiedBetweenLabel", modifiedBetweenLabel = new JLabel());
        
        modifiedBetweenLabel.setName("modifiedBetweenLabel");
        modifiedBetweenLabel.setText(t("faxtomail.search.modifiedBetween.label"));
    }

    protected void createModifiedBetweenStartDatePicker() {
        $objectMap.put("modifiedBetweenStartDatePicker", modifiedBetweenStartDatePicker = new JXDatePicker());
        
        modifiedBetweenStartDatePicker.setName("modifiedBetweenStartDatePicker");
        modifiedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__modifiedBetweenStartDatePicker"));
        modifiedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createModifiedByComboBox() {
        $objectMap.put("modifiedByComboBox", modifiedByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        modifiedByComboBox.setName("modifiedByComboBox");
        modifiedByComboBox.setShowDecorator(false);
        modifiedByComboBox.setProperty("modifiedBy");
        modifiedByComboBox.setShowReset(true);
    }

    protected void createModifiedByLabel() {
        $objectMap.put("modifiedByLabel", modifiedByLabel = new JLabel());
        
        modifiedByLabel.setName("modifiedByLabel");
        modifiedByLabel.setText(t("faxtomail.search.modifiedBy.label"));
    }

    protected void createObjectField() {
        $objectMap.put("objectField", objectField = new JTextField());
        
        objectField.setName("objectField");
        objectField.setColumns(15);
        objectField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__objectField"));
    }

    protected void createObjectLabel() {
        $objectMap.put("objectLabel", objectLabel = new JLabel());
        
        objectLabel.setName("objectLabel");
        objectLabel.setText(t("faxtomail.demande.object.label"));
    }

    protected void createPrintedBetweenEndDatePicker() {
        $objectMap.put("printedBetweenEndDatePicker", printedBetweenEndDatePicker = new JXDatePicker());
        
        printedBetweenEndDatePicker.setName("printedBetweenEndDatePicker");
        printedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printedBetweenEndDatePicker"));
        printedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createPrintedBetweenLabel() {
        $objectMap.put("printedBetweenLabel", printedBetweenLabel = new JLabel());
        
        printedBetweenLabel.setName("printedBetweenLabel");
        printedBetweenLabel.setText(t("faxtomail.search.printedBetween.label"));
    }

    protected void createPrintedBetweenStartDatePicker() {
        $objectMap.put("printedBetweenStartDatePicker", printedBetweenStartDatePicker = new JXDatePicker());
        
        printedBetweenStartDatePicker.setName("printedBetweenStartDatePicker");
        printedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printedBetweenStartDatePicker"));
        printedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createPrintedByComboBox() {
        $objectMap.put("printedByComboBox", printedByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        printedByComboBox.setName("printedByComboBox");
        printedByComboBox.setShowDecorator(false);
        printedByComboBox.setProperty("printingBy");
        printedByComboBox.setShowReset(true);
    }

    protected void createPrintedByLabel() {
        $objectMap.put("printedByLabel", printedByLabel = new JLabel());
        
        printedByLabel.setName("printedByLabel");
        printedByLabel.setText(t("faxtomail.demande.printedBy.label"));
    }

    protected void createPriorityComboBox() {
        $objectMap.put("priorityComboBox", priorityComboBox = new JComboBox());
        
        priorityComboBox.setName("priorityComboBox");
    }

    protected void createPriorityLabel() {
        $objectMap.put("priorityLabel", priorityLabel = new JLabel());
        
        priorityLabel.setName("priorityLabel");
        priorityLabel.setText(t("faxtomail.demande.priority.label"));
    }

    protected void createProjectReferenceField() {
        $objectMap.put("projectReferenceField", projectReferenceField = new JTextField());
        
        projectReferenceField.setName("projectReferenceField");
        projectReferenceField.setColumns(15);
        projectReferenceField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__projectReferenceField"));
    }

    protected void createProjectReferenceLabel() {
        $objectMap.put("projectReferenceLabel", projectReferenceLabel = new JLabel());
        
        projectReferenceLabel.setName("projectReferenceLabel");
        projectReferenceLabel.setText(t("faxtomail.demande.projectReference.label"));
    }

    protected void createReceivedBetweenEndDatePicker() {
        $objectMap.put("receivedBetweenEndDatePicker", receivedBetweenEndDatePicker = new JXDatePicker());
        
        receivedBetweenEndDatePicker.setName("receivedBetweenEndDatePicker");
        receivedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__receivedBetweenEndDatePicker"));
        receivedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createReceivedBetweenLabel() {
        $objectMap.put("receivedBetweenLabel", receivedBetweenLabel = new JLabel());
        
        receivedBetweenLabel.setName("receivedBetweenLabel");
        receivedBetweenLabel.setText(t("faxtomail.search.receivedBetween.label"));
    }

    protected void createReceivedBetweenStartDatePicker() {
        $objectMap.put("receivedBetweenStartDatePicker", receivedBetweenStartDatePicker = new JXDatePicker());
        
        receivedBetweenStartDatePicker.setName("receivedBetweenStartDatePicker");
        receivedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__receivedBetweenStartDatePicker"));
        receivedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createRepliedBetweenEndDatePicker() {
        $objectMap.put("repliedBetweenEndDatePicker", repliedBetweenEndDatePicker = new JXDatePicker());
        
        repliedBetweenEndDatePicker.setName("repliedBetweenEndDatePicker");
        repliedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__repliedBetweenEndDatePicker"));
        repliedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createRepliedBetweenLabel() {
        $objectMap.put("repliedBetweenLabel", repliedBetweenLabel = new JLabel());
        
        repliedBetweenLabel.setName("repliedBetweenLabel");
        repliedBetweenLabel.setText(t("faxtomail.search.repliedBetween.label"));
    }

    protected void createRepliedBetweenStartDatePicker() {
        $objectMap.put("repliedBetweenStartDatePicker", repliedBetweenStartDatePicker = new JXDatePicker());
        
        repliedBetweenStartDatePicker.setName("repliedBetweenStartDatePicker");
        repliedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__repliedBetweenStartDatePicker"));
        repliedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createRepliedByComboBox() {
        $objectMap.put("repliedByComboBox", repliedByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        repliedByComboBox.setName("repliedByComboBox");
        repliedByComboBox.setShowDecorator(false);
        repliedByComboBox.setProperty("replyBy");
        repliedByComboBox.setShowReset(true);
    }

    protected void createRepliedByLabel() {
        $objectMap.put("repliedByLabel", repliedByLabel = new JLabel());
        
        repliedByLabel.setName("repliedByLabel");
        repliedByLabel.setText(t("faxtomail.demande.repliedBy.label"));
    }

    protected void createSearchButton() {
        $objectMap.put("searchButton", searchButton = new JButton());
        
        searchButton.setName("searchButton");
        searchButton.setText(t("faxtomail.search.button.label"));
        searchButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.actions.SearchAction.class );
    }

    protected void createSearchScrollPane() {
        $objectMap.put("searchScrollPane", searchScrollPane = new JScrollPane());
        
        searchScrollPane.setName("searchScrollPane");
    }

    protected void createSenderField() {
        $objectMap.put("senderField", senderField = new JTextField());
        
        senderField.setName("senderField");
        senderField.setColumns(15);
        senderField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__senderField"));
    }

    protected void createSenderLabel() {
        $objectMap.put("senderLabel", senderLabel = new JLabel());
        
        senderLabel.setName("senderLabel");
        senderLabel.setText(t("faxtomail.demande.sender.label"));
    }

    protected void createStatusComboBox() {
        $objectMap.put("statusComboBox", statusComboBox = new JComboBox());
        
        statusComboBox.setName("statusComboBox");
    }

    protected void createStatusLabel() {
        $objectMap.put("statusLabel", statusLabel = new JLabel());
        
        statusLabel.setName("statusLabel");
        statusLabel.setText(t("faxtomail.demande.status.label"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
    }

    protected void createTakenByComboBox() {
        $objectMap.put("takenByComboBox", takenByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        takenByComboBox.setName("takenByComboBox");
        takenByComboBox.setShowDecorator(false);
        takenByComboBox.setProperty("takenBy");
        takenByComboBox.setShowReset(true);
    }

    protected void createTakenByLabel() {
        $objectMap.put("takenByLabel", takenByLabel = new JLabel());
        
        takenByLabel.setName("takenByLabel");
        takenByLabel.setText(t("faxtomail.demande.takenBy.label"));
    }

    protected void createTransferBetweenEndDatePicker() {
        $objectMap.put("transferBetweenEndDatePicker", transferBetweenEndDatePicker = new JXDatePicker());
        
        transferBetweenEndDatePicker.setName("transferBetweenEndDatePicker");
        transferBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__transferBetweenEndDatePicker"));
        transferBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createTransferBetweenLabel() {
        $objectMap.put("transferBetweenLabel", transferBetweenLabel = new JLabel());
        
        transferBetweenLabel.setName("transferBetweenLabel");
        transferBetweenLabel.setText(t("faxtomail.search.transferBetween.label"));
    }

    protected void createTransferBetweenStartDatePicker() {
        $objectMap.put("transferBetweenStartDatePicker", transferBetweenStartDatePicker = new JXDatePicker());
        
        transferBetweenStartDatePicker.setName("transferBetweenStartDatePicker");
        transferBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__transferBetweenStartDatePicker"));
        transferBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createTransferByComboBox() {
        $objectMap.put("transferByComboBox", transferByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        transferByComboBox.setName("transferByComboBox");
        transferByComboBox.setShowDecorator(false);
        transferByComboBox.setProperty("transferBy");
        transferByComboBox.setShowReset(true);
    }

    protected void createTransferByLabel() {
        $objectMap.put("transferByLabel", transferByLabel = new JLabel());
        
        transferByLabel.setName("transferByLabel");
        transferByLabel.setText(t("faxtomail.demande.transferBy.label"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSearchPanel();
        addChildrenToTablePopup();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JPanel0, JSplitPane.LEFT);
        $JSplitPane0.add($JPanel2, JSplitPane.RIGHT);
        // inline complete setup of $JPanel0
        $JPanel0.add(searchScrollPane, BorderLayout.CENTER);
        $JPanel0.add($JPanel1, BorderLayout.SOUTH);
        addChildrenToSearchScrollPane();
        // inline complete setup of $Table0
        $Table0.add(receivedBetweenLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(receivedBetweenStartDatePicker, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(receivedBetweenEndDatePicker, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(takenByLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(takenByComboBox, new GridBagConstraints(5, 0, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedBetweenLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedBetweenStartDatePicker, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedBetweenEndDatePicker, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedByLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedByComboBox, new GridBagConstraints(5, 1, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferBetweenLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferBetweenStartDatePicker, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferBetweenEndDatePicker, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferByLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferByComboBox, new GridBagConstraints(5, 2, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedBetweenLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedBetweenStartDatePicker, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedBetweenEndDatePicker, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedByLabel, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedByComboBox, new GridBagConstraints(5, 3, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedBetweenLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedBetweenStartDatePicker, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedBetweenEndDatePicker, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedByLabel, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedByComboBox, new GridBagConstraints(5, 4, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedBetweenLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedBetweenStartDatePicker, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel5, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedBetweenEndDatePicker, new GridBagConstraints(3, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedByLabel, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedByComboBox, new GridBagConstraints(5, 5, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(senderLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(senderField, new GridBagConstraints(1, 6, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(gammeLabel, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(gammeComboBox, new GridBagConstraints(5, 6, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(objectLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(objectField, new GridBagConstraints(1, 7, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(docTypeLabel, new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(docTypeComboBox, new GridBagConstraints(5, 7, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ediCodeNumberLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ediCodeNumberField, new GridBagConstraints(1, 8, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(projectReferenceLabel, new GridBagConstraints(4, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(projectReferenceField, new GridBagConstraints(5, 8, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(priorityLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(priorityComboBox, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(statusLabel, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(statusComboBox, new GridBagConstraints(3, 9, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(etatAttenteLabel, new GridBagConstraints(4, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(etatAttenteComboBox, new GridBagConstraints(5, 9, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(messageLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(messageField, new GridBagConstraints(1, 10, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(clientLabel, new GridBagConstraints(4, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(clientField, new GridBagConstraints(5, 10, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(bodyLabel, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(bodyField, new GridBagConstraints(1, 11, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(localReferenceLabel, new GridBagConstraints(4, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(localReferenceField, new GridBagConstraints(5, 11, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addGroupedElementCheckbox, new GridBagConstraints(0, 12, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add(searchButton);
        // inline complete setup of $JPanel2
        $JPanel2.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(dataTable);
        
        // apply 26 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        $JSplitPane0.setOrientation(JSplitPane.VERTICAL_SPLIT);
        takenByComboBox.setBeanType(FaxToMailUser.class);
        modifiedByComboBox.setBeanType(FaxToMailUser.class);
        transferByComboBox.setBeanType(FaxToMailUser.class);
        archivedByComboBox.setBeanType(FaxToMailUser.class);
        printedByComboBox.setBeanType(FaxToMailUser.class);
        repliedByComboBox.setBeanType(FaxToMailUser.class);
        goToFolderMenu.setIcon(SwingUtil.createActionIcon("list"));
        takenByComboBox.setBean(model);
        modifiedByComboBox.setBean(model);
        transferByComboBox.setBean(model);
        archivedByComboBox.setBean(model);
        printedByComboBox.setBean(model);
        repliedByComboBox.setBean(model);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("searchPanel", searchPanel);
        createModel();
        createTablePopup();
        createGoToFolderMenu();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createSearchScrollPane();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createReceivedBetweenLabel();
        createReceivedBetweenStartDatePicker();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("faxtomail.search.between2ndPart.label"));
        createReceivedBetweenEndDatePicker();
        createTakenByLabel();
        createTakenByComboBox();
        createModifiedBetweenLabel();
        createModifiedBetweenStartDatePicker();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("faxtomail.search.between2ndPart.label"));
        createModifiedBetweenEndDatePicker();
        createModifiedByLabel();
        createModifiedByComboBox();
        createTransferBetweenLabel();
        createTransferBetweenStartDatePicker();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("faxtomail.search.between2ndPart.label"));
        createTransferBetweenEndDatePicker();
        createTransferByLabel();
        createTransferByComboBox();
        createArchivedBetweenLabel();
        createArchivedBetweenStartDatePicker();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("faxtomail.search.between2ndPart.label"));
        createArchivedBetweenEndDatePicker();
        createArchivedByLabel();
        createArchivedByComboBox();
        createPrintedBetweenLabel();
        createPrintedBetweenStartDatePicker();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("faxtomail.search.between2ndPart.label"));
        createPrintedBetweenEndDatePicker();
        createPrintedByLabel();
        createPrintedByComboBox();
        createRepliedBetweenLabel();
        createRepliedBetweenStartDatePicker();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("faxtomail.search.between2ndPart.label"));
        createRepliedBetweenEndDatePicker();
        createRepliedByLabel();
        createRepliedByComboBox();
        createSenderLabel();
        createSenderField();
        createGammeLabel();
        createGammeComboBox();
        createObjectLabel();
        createObjectField();
        createDocTypeLabel();
        createDocTypeComboBox();
        createEdiCodeNumberLabel();
        createEdiCodeNumberField();
        createProjectReferenceLabel();
        createProjectReferenceField();
        createPriorityLabel();
        createPriorityComboBox();
        createStatusLabel();
        createStatusComboBox();
        createEtatAttenteLabel();
        createEtatAttenteComboBox();
        createMessageLabel();
        createMessageField();
        createClientLabel();
        createClientField();
        createBodyLabel();
        createBodyField();
        createLocalReferenceLabel();
        createLocalReferenceField();
        createAddGroupedElementCheckbox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createSearchButton();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createDataTable();
        // inline creation of searchPanel
        setName("searchPanel");
        setLayout(new BorderLayout());
        
        // registers 26 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 26 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GO_TO_FOLDER_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("menuEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    goToFolderMenu.setEnabled( model.isMenuEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("menuEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RECEIVED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minReceptionDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    receivedBetweenStartDatePicker.setDate( model.getMinReceptionDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minReceptionDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RECEIVED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxReceptionDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    receivedBetweenEndDatePicker.setDate( model.getMaxReceptionDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxReceptionDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TAKEN_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("takenBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    takenByComboBox.setSelectedItem( model.getTakenBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("takenBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODIFIED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minModificationDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    modifiedBetweenStartDatePicker.setDate( model.getMinModificationDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minModificationDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODIFIED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxModificationDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    modifiedBetweenEndDatePicker.setDate( model.getMaxModificationDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxModificationDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODIFIED_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modifiedBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    modifiedByComboBox.setSelectedItem( model.getModifiedBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modifiedBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minTransferDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    transferBetweenStartDatePicker.setDate( model.getMinTransferDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minTransferDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxTransferDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    transferBetweenEndDatePicker.setDate( model.getMaxTransferDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxTransferDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("transferBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    transferByComboBox.setSelectedItem( model.getTransferBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("transferBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minArchivedDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    archivedBetweenStartDatePicker.setDate( model.getMinArchivedDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minArchivedDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxArchivedDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    archivedBetweenEndDatePicker.setDate( model.getMaxArchivedDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxArchivedDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("archivedBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    archivedByComboBox.setSelectedItem( model.getArchivedBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("archivedBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minPrintingDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    printedBetweenStartDatePicker.setDate( model.getMinPrintingDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minPrintingDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxPrintingDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    printedBetweenEndDatePicker.setDate( model.getMaxPrintingDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxPrintingDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("printingBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    printedByComboBox.setSelectedItem( model.getPrintingBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("printingBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minReplyDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    repliedBetweenStartDatePicker.setDate( model.getMinReplyDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minReplyDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxReplyDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    repliedBetweenEndDatePicker.setDate( model.getMaxReplyDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxReplyDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("replyBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    repliedByComboBox.setSelectedItem( model.getReplyBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("replyBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SENDER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sender", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(senderField, model.getSender());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sender", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OBJECT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("demandObject", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(objectField, model.getDemandObject());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("demandObject", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDI_CODE_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ediCodeNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(ediCodeNumberField,  model.getEdiCodeNumber() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ediCodeNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_REFERENCE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("projectReference", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(projectReferenceField,  model.getProjectReference() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("projectReference", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MESSAGE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("message", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(messageField,  model.getMessage() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("message", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BODY_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("body", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(bodyField,  model.getBody() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("body", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LOCAL_REFERENCE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("localReference", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(localReferenceField,  model.getLocalReference() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("localReference", this);
                }
            }
        });
    }

}