package com.franciaflex.faxtomail.ui.swing.content.print;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: AttachmentToPrintChooserUIHandler.java 162 2014-06-09 17:14:06Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/content/print/AttachmentToPrintChooserUIHandler.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.Cancelable;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class AttachmentToPrintChooserUIHandler extends AbstractFaxToMailUIHandler<AttachmentToPrintChooserUIModel, AttachmentToPrintChooserUI>
                                                implements Cancelable {

    private static final Log log = LogFactory.getLog(AttachmentToPrintChooserUIHandler.class);

    @Override
    public void afterInit(AttachmentToPrintChooserUI attachmentToPrintChooserUI) {
        initUI(attachmentToPrintChooserUI);

        AttachmentToPrintChooserUIModel model = getModel();
        DemandeUIModel demand = model.getDemand();

        JPanel attachmentPanel = ui.getAttachmentPanel();
        JCheckBox checkBox = new JCheckBox(t("faxtomail.chooseMailFolder.element"), false);
        attachmentPanel.add(checkBox);

        for (Attachment attachment : demand.getAttachment()) {
            createCheckBox(attachment.getOriginalFile());

            final AttachmentFile file = attachment.getEditedFile();
            if (file != null) {
                createCheckBox(file);
            }
        }
    }

    protected void createCheckBox(final AttachmentFile attachmentFile) {
        JCheckBox checkBox = new JCheckBox(attachmentFile.getFilename(), true);
        ui.getAttachmentPanel().add(checkBox);
        getModel().addAttachmentToPrint(attachmentFile);

        checkBox.addItemListener(new ItemListener() {
            @Override
            public void itemStateChanged(ItemEvent e) {
                log.info("state changed " + e.getStateChange());
                if (e.getStateChange() == ItemEvent.SELECTED) {
                    getModel().addAttachmentToPrint(attachmentFile);
                } else {
                    getModel().removeAttachmentToPrint(attachmentFile);
                }
            }
        });
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    public SwingValidator<AttachmentToPrintChooserUIModel> getValidator() {
        return null;
    }

    @Override
    public void cancel() {
        closeDialog();
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ui.getAttachmentPanel();
    }

    public void print() {
        for (AttachmentFile attachmentFile : getModel().getAttachmentsToPrint()) {
            FaxToMailUIUtil.print(attachmentFile, true);
        }
    }
}
