package com.franciaflex.faxtomail.ui.swing.content.pdfeditor;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.franciaflex.faxtomail.ui.swing.util.JImagePanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PDFEditorUI extends JPanel implements FaxToMailUI<PDFEditorUIModel, PDFEditorUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_NEXT_PAGE_BUTTON_ENABLED = "nextPageButton.enabled";
    public static final String BINDING_PAGE_NUMBER_MODEL_TEXT = "pageNumber.modelText";
    public static final String BINDING_PAGE_TOTAL_TEXT = "pageTotal.text";
    public static final String BINDING_PREV_PAGE_BUTTON_ENABLED = "prevPageButton.enabled";
    public static final String BINDING_ZOOM_LABEL_TEXT = "zoomLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(PDFEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected JPanel container;
    protected JButton crossButton;
    protected JImagePanel documentPanel;
    protected final PDFEditorUIHandler handler = new PDFEditorUIHandler();
    protected JButton highlighterButton;
    protected JButton lineButton;
    protected PDFEditorUIModel model;
    protected JButton nextPageButton;
    protected JButton noteButton;
    protected NumberEditor pageNumber;
    protected JLabel pageTotal;
    protected PDFEditorUI pdfEditorUIPanel = this;
    protected JButton prevPageButton;
    protected JButton printButton;
    protected JButton rotateAntiClockwiseButton;
    protected JButton rotateClockwiseButton;
    protected JToolBar toolbar;
    protected JButton validateButton;
    protected JButton zoomInButton;
    protected JLabel zoomLabel;
    protected JButton zoomOutButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PDFEditorUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public PDFEditorUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PDFEditorUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorUI() {
        $initialize();
    }

    public PDFEditorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.closeDialog();
    }

    public void doActionPerformed__on__crossButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addCross();
    }

    public void doActionPerformed__on__highlighterButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addHighlighter();
    }

    public void doActionPerformed__on__lineButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addLine();
    }

    public void doActionPerformed__on__nextPageButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getModel().incPageIndex();
    }

    public void doActionPerformed__on__noteButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addNote();
    }

    public void doActionPerformed__on__prevPageButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getModel().decPageIndex();
    }

    public void doActionPerformed__on__printButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.print();
    }

    public void doActionPerformed__on__rotateAntiClockwiseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.rotateAntiClockwise();
    }

    public void doActionPerformed__on__rotateClockwiseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.rotateClockwise();
    }

    public void doActionPerformed__on__zoomInButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.zoomIn();
    }

    public void doActionPerformed__on__zoomOutButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.zoomOut();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JPanel getContainer() {
        return container;
    }

    public JButton getCrossButton() {
        return crossButton;
    }

    public JImagePanel getDocumentPanel() {
        return documentPanel;
    }

    public PDFEditorUIHandler getHandler() {
        return handler;
    }

    public JButton getHighlighterButton() {
        return highlighterButton;
    }

    public JButton getLineButton() {
        return lineButton;
    }

    public PDFEditorUIModel getModel() {
        return model;
    }

    public JButton getNextPageButton() {
        return nextPageButton;
    }

    public JButton getNoteButton() {
        return noteButton;
    }

    public NumberEditor getPageNumber() {
        return pageNumber;
    }

    public JLabel getPageTotal() {
        return pageTotal;
    }

    public JButton getPrevPageButton() {
        return prevPageButton;
    }

    public JButton getPrintButton() {
        return printButton;
    }

    public JButton getRotateAntiClockwiseButton() {
        return rotateAntiClockwiseButton;
    }

    public JButton getRotateClockwiseButton() {
        return rotateClockwiseButton;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public JButton getZoomInButton() {
        return zoomInButton;
    }

    public JLabel getZoomLabel() {
        return zoomLabel;
    }

    public JButton getZoomOutButton() {
        return zoomOutButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContainer() {
        if (!allComponentsCreated) {
            return;
        }
        container.add(documentPanel);
    }

    protected void addChildrenToPdfEditorUIPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(toolbar, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(noteButton);
        toolbar.add(crossButton);
        toolbar.add(lineButton);
        toolbar.add(highlighterButton);
        toolbar.add($JSeparator0);
        toolbar.add(prevPageButton);
        toolbar.add(pageNumber);
        toolbar.add(pageTotal);
        toolbar.add(nextPageButton);
        toolbar.add(zoomOutButton);
        toolbar.add(zoomLabel);
        toolbar.add(zoomInButton);
        toolbar.add(rotateClockwiseButton);
        toolbar.add(rotateAntiClockwiseButton);
        toolbar.add($JSeparator1);
        toolbar.add(printButton);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("faxtomail.pdfEditor.action.cancel"));
        cancelButton.setToolTipText(t("faxtomail.pdfEditor.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createContainer() {
        $objectMap.put("container", container = new JPanel());
        
        container.setName("container");
        container.setLayout(null);
    }

    protected void createCrossButton() {
        $objectMap.put("crossButton", crossButton = new JButton());
        
        crossButton.setName("crossButton");
        crossButton.setToolTipText(t("faxtomail.pdfEditor.button.addCross.tip"));
        crossButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__crossButton"));
    }

    protected void createDocumentPanel() {
        $objectMap.put("documentPanel", documentPanel = new JImagePanel());
        
        documentPanel.setName("documentPanel");
    }

    protected void createHighlighterButton() {
        $objectMap.put("highlighterButton", highlighterButton = new JButton());
        
        highlighterButton.setName("highlighterButton");
        highlighterButton.setToolTipText(t("faxtomail.pdfEditor.button.addHighlighter.tip"));
        highlighterButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__highlighterButton"));
    }

    protected void createLineButton() {
        $objectMap.put("lineButton", lineButton = new JButton());
        
        lineButton.setName("lineButton");
        lineButton.setToolTipText(t("faxtomail.pdfEditor.button.addLine.tip"));
        lineButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lineButton"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new PDFEditorUIModel());
    }

    protected void createNextPageButton() {
        $objectMap.put("nextPageButton", nextPageButton = new JButton());
        
        nextPageButton.setName("nextPageButton");
        nextPageButton.setToolTipText(t("faxtomail.pdfEditor.button.nextPage"));
        nextPageButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__nextPageButton"));
    }

    protected void createNoteButton() {
        $objectMap.put("noteButton", noteButton = new JButton());
        
        noteButton.setName("noteButton");
        noteButton.setToolTipText(t("faxtomail.pdfEditor.button.addNote.tip"));
        noteButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__noteButton"));
    }

    protected void createPageNumber() {
        $objectMap.put("pageNumber", pageNumber = new NumberEditor(this));
        
        pageNumber.setName("pageNumber");
        pageNumber.setUseSign(false);
        pageNumber.setAutoPopup(false);
        SwingUtil.setComponentWidth(pageNumber,50);
        pageNumber.setProperty("currentPageIndex");
        pageNumber.setUseFloat(false);
        pageNumber.setShowReset(false);
        pageNumber.setShowPopupButton(false);
    }

    protected void createPageTotal() {
        $objectMap.put("pageTotal", pageTotal = new JLabel());
        
        pageTotal.setName("pageTotal");
    }

    protected void createPrevPageButton() {
        $objectMap.put("prevPageButton", prevPageButton = new JButton());
        
        prevPageButton.setName("prevPageButton");
        prevPageButton.setToolTipText(t("faxtomail.pdfEditor.button.previousPage"));
        prevPageButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__prevPageButton"));
    }

    protected void createPrintButton() {
        $objectMap.put("printButton", printButton = new JButton());
        
        printButton.setName("printButton");
        printButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printButton"));
    }

    protected void createRotateAntiClockwiseButton() {
        $objectMap.put("rotateAntiClockwiseButton", rotateAntiClockwiseButton = new JButton());
        
        rotateAntiClockwiseButton.setName("rotateAntiClockwiseButton");
        rotateAntiClockwiseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rotateAntiClockwiseButton"));
    }

    protected void createRotateClockwiseButton() {
        $objectMap.put("rotateClockwiseButton", rotateClockwiseButton = new JButton());
        
        rotateClockwiseButton.setName("rotateClockwiseButton");
        rotateClockwiseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rotateClockwiseButton"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("faxtomail.pdfEditor.action.validate"));
        validateButton.setToolTipText(t("faxtomail.pdfEditor.action.validate.tip"));
        validateButton.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.actions.GenerateAnnotatedAttachmentAction.class);
    }

    protected void createZoomInButton() {
        $objectMap.put("zoomInButton", zoomInButton = new JButton());
        
        zoomInButton.setName("zoomInButton");
        zoomInButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__zoomInButton"));
    }

    protected void createZoomLabel() {
        $objectMap.put("zoomLabel", zoomLabel = new JLabel());
        
        zoomLabel.setName("zoomLabel");
    }

    protected void createZoomOutButton() {
        $objectMap.put("zoomOutButton", zoomOutButton = new JButton());
        
        zoomOutButton.setName("zoomOutButton");
        zoomOutButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__zoomOutButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToPdfEditorUIPanel();
        addChildrenToToolbar();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add(container);
        addChildrenToContainer();
        // inline complete setup of $JPanel1
        $JPanel1.add(cancelButton);
        $JPanel1.add(validateButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 20 property setters
        toolbar.setMargin(new java.awt.Insets(5, 0, 0, 5));
        noteButton.setIcon(SwingUtil.createActionIcon("note"));
        crossButton.setIcon(SwingUtil.createActionIcon("cross"));
        lineButton.setIcon(SwingUtil.createActionIcon("line"));
        highlighterButton.setIcon(SwingUtil.createActionIcon("highlighter"));
        $JSeparator0.setBorder( BorderFactory.createEmptyBorder(0, 5, 0, 5) );
        prevPageButton.setIcon(SwingUtil.createActionIcon("left"));
        pageNumber.setBean( model );
        nextPageButton.setIcon(SwingUtil.createActionIcon("right"));
        zoomOutButton.setIcon(SwingUtil.createActionIcon("zoom-out"));
        zoomInButton.setIcon(SwingUtil.createActionIcon("zoom-in"));
        rotateClockwiseButton.setIcon(SwingUtil.createActionIcon("rotate-clockwise"));
        rotateAntiClockwiseButton.setIcon(SwingUtil.createActionIcon("rotate-anticlockwise"));
        $JSeparator1.setBorder( BorderFactory.createEmptyBorder(0, 5, 0, 5) );
        printButton.setIcon(SwingUtil.createActionIcon("print"));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        validateButton.setIcon(SwingUtil.createActionIcon("validate"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("pdfEditorUIPanel", pdfEditorUIPanel);
        createModel();
        createToolbar();
        createNoteButton();
        createCrossButton();
        createLineButton();
        createHighlighterButton();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator(SwingConstants.VERTICAL));
        
        $JSeparator0.setName("$JSeparator0");
        createPrevPageButton();
        createPageNumber();
        createPageTotal();
        createNextPageButton();
        createZoomOutButton();
        createZoomLabel();
        createZoomInButton();
        createRotateClockwiseButton();
        createRotateAntiClockwiseButton();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator(SwingConstants.VERTICAL));
        
        $JSeparator1.setName("$JSeparator1");
        createPrintButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createContainer();
        createDocumentPanel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createValidateButton();
        // inline creation of pdfEditorUIPanel
        setName("pdfEditorUIPanel");
        setLayout(new BorderLayout());
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PREV_PAGE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("currentPageIndex", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    prevPageButton.setEnabled( getModel().getCurrentPageIndex() > 1 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("currentPageIndex", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PAGE_NUMBER_MODEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentPageIndex", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    pageNumber.setModelText( String.valueOf(model.getCurrentPageIndex()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentPageIndex", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PAGE_TOTAL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("pages", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getPages() != null) {
                    pageTotal.setText(t( " / " + String.valueOf(model.getPages().length) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("pages", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEXT_PAGE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("currentPageIndex", this);
                }
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("pages", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null && getModel().getPages() != null) {
                    nextPageButton.setEnabled( getModel().getCurrentPageIndex() < getModel().getPages().length );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("currentPageIndex", this);
                }
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("pages", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ZOOM_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("zoom", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    zoomLabel.setText(t( String.format("%.0f", model.getZoom() * 100) + "%"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("zoom", this);
                }
            }
        });
    }

}