package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class DemandeListUI extends JPanel implements FaxToMailUI<DemandeListUIModel, DemandeListUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ARCHIVE_MENU_ENABLED = "archiveMenu.enabled";
    public static final String BINDING_DEMAND_NB_FIELD_TEXT = "demandNbField.text";
    public static final String BINDING_PF_NB_FIELD_TEXT = "pfNbField.text";
    public static final String BINDING_QUOTATION_NB_FIELD_TEXT = "quotationNbField.text";
    public static final String BINDING_REPLY_MENU_ENABLED = "replyMenu.enabled";
    public static final String BINDING_SAV_NB_FIELD_TEXT = "savNbField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXz1McRRRuFhbYJSQkEBIFKytQKUCZhVR5sLCUSMBALQRYouhe7N3p3W2cne7M9CxDopZ/gn+C3r1Y5c2T5cGzBy+W/0LK8qDeLF/3DDM7y8zuaDgM0O+9772vf3yv+5vnKGtb6NVT7Lqa5ZiCtoi2e//k5FH1lNTEA2LXLMoFs5D3M5BBmQoa04NxW6D5SkmGF/3w4iZrcWYSsyN6vYTytjg3iN0kRAj0SjSiZtvFcmBed7ljXaAGRcWhfvXH75kv9S++ziDkcqhuBqgU+kWFTIZKKEN1gW5ApjYuGthsQBkWNRtQ77gc2zSwbe/jFnmCPkcjJTTMsQVgAs2lp6wwVLzLBZrQSQubOilRWxxgkxgCbdRYS6tb2KxRXDeIq9WxK1gLU0NzqGafQT1ajZkC4DU/WnsQojze4VzhDwuUbTFdQm69KOSexAlxc8Ii5IBxBxhMy4lxfZBdNbhHTCd0noXk3BHk0MEwO4IS+93zI5hbIt0EuhmJl2M7grRk7LUAYtwkZ1490i4Hp6IOeYGrhleRHLneUSqHBRSRsFuh0SLcOE8wjmGr1qRtkmAeh+kzy9ygat265yEwSO9cGLSwW65ZzDCkaVWgW9GgwCTd7wRRV03cpg0sKDOPYeIFuh4Jk2PScy4IGF3YVZsJMtyILo8cjYJf+K7J/5flZzEs19sM+9USrsp9FAVTg9LztcsB25QYuhwsRh0gmwpbDW0CTTWZRZ/C/sPGik3gTGGpJH7ExBOHCcXdLyMGtdOnX+a11JlzvJ6cUhn75bqXOlfexu3kZJ41KVtkUyl6C9FlzOlY4GN5QgSaYVZDOwXB/kQw7q2kq+2eKKt0f4+DaM5ERBPkWAvlONTLgQrKWg4MC3S7clnBj8DkafftLu2WgMr6z/TkL9//9t32hWBPQe6bsa4d/QaElFuME0tKiUDXPLV2BDWKe5ivV1DOJgY0K9WMZmMKK/tmKA7yqbOkyXDtIbabAJEd+fWHH6c//nkQZbZR3mBY38bSfwd0r2nBLDBDd/k7G6qiK2ej8J2QtQk0JIgL3WCw8GnBBd6zMbyD5NXcT39Olr/duOA+ALW8lOge8s9+hIapaVCTqHbld6LY9jTGbeLoLOw4cT0Icc57bc5D9X0cR/cKTAZ9Sj4gtNGUtFe1e66Syg8VH/lXBXUrJfe1OQl3EJTXYky8T22qdmy2jg0bfufqUN6KTChQZm0NTj2sxJl9BL4PQXPUPhwSlkPiauiS0BRF+Gv5RtgqO1q1BhsCoLSk1gZH1vPYkW0Vjfh+QE0wZhxTfqzA3/xf4JqgPI5jz0abnvHdnkUFnbiLYh4MK7pvibJcTgeYRCva/PvxyAQ85uPTdrW0vLer5KkQcLBg/9NabBWRuH5VhFpw91nBu0NqbWw45FF9Ud3JNNgjW7K2/eri0lLhs54plfCnJ56wgN19ND33Sy04Pf3lZPqHIWjiFFxq7Oln4U78LAQ9PT398B6Qnvd8Mu+Deg/C4bUiPdNCPNPwRpGeasc1JD3XhWSuZQmXSLbjWpNCnkZtZgkcaQmT2BFs0yJYkCN2VgY73Aq8JgD+RKe+f2JbCG9G6fVxrqecqedGlzZm/cGoLPbWWRWSJInho6Zf2UPQfIgpCYIsv/ys4K0MtY/kw2fLMyzC8qRkp95L3ez8wf/CToUksgteZSkWJWQ3G7K7773c4vgt9KzLf/J1k1lME5REp/MdmeJQDRv4nDmQ9OpbcnMWqtTU4Wy9fQl6QH7zfRHl8F/y83c8wtILI7wOCP8CEAcypTkSAAA=";
    private static final Log log = LogFactory.getLog(DemandeListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuItem archiveMenu;
    protected JMenuItem computeQuantitiesByRangeMenu;
    protected JXTable dataTable;
    protected JLabel demandNbField;
    protected JLabel demandNbLabel;
    protected DemandeListUI demandeListPanel = this;
    protected final DemandeListUIHandler handler = new DemandeListUIHandler();
    protected JSplitPane mainSplitPane;
    protected DemandeListUIModel model;
    protected JTree navigationTree;
    protected JMenuItem newDemandMenu;
    protected JLabel pfNbField;
    protected JLabel pfNbLabel;
    protected JMenuItem printMenu;
    protected JLabel quotationNbField;
    protected JLabel quotationNbLabel;
    protected JMenuItem replyMenu;
    protected JLabel savNbField;
    protected JLabel savNbLabel;
    protected JPopupMenu tablePopup;
    protected JPopupMenu treePopup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandeListUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public DemandeListUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandeListUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandeListUI() {
        $initialize();
    }

    public DemandeListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandeListUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DemandeListUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandeListUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DemandeListUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__archiveMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.archive();
    }

    public void doActionPerformed__on__computeQuantitiesByRangeMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.computeQuantitiesByRange();
    }

    public void doActionPerformed__on__newDemandMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.newDemand();
    }

    public void doActionPerformed__on__printMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.print();
    }

    public void doActionPerformed__on__replyMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.reply();
    }

    public void doKeyPressed__on__dataTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__dataTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    public void doMouseClicked__on__navigationTree(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectNodeInTree(event, treePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenuItem getArchiveMenu() {
        return archiveMenu;
    }

    public JMenuItem getComputeQuantitiesByRangeMenu() {
        return computeQuantitiesByRangeMenu;
    }

    public JXTable getDataTable() {
        return dataTable;
    }

    public JLabel getDemandNbField() {
        return demandNbField;
    }

    public JLabel getDemandNbLabel() {
        return demandNbLabel;
    }

    public DemandeListUIHandler getHandler() {
        return handler;
    }

    public JSplitPane getMainSplitPane() {
        return mainSplitPane;
    }

    public DemandeListUIModel getModel() {
        return model;
    }

    public JTree getNavigationTree() {
        return navigationTree;
    }

    public JMenuItem getNewDemandMenu() {
        return newDemandMenu;
    }

    public JLabel getPfNbField() {
        return pfNbField;
    }

    public JLabel getPfNbLabel() {
        return pfNbLabel;
    }

    public JMenuItem getPrintMenu() {
        return printMenu;
    }

    public JLabel getQuotationNbField() {
        return quotationNbField;
    }

    public JLabel getQuotationNbLabel() {
        return quotationNbLabel;
    }

    public JMenuItem getReplyMenu() {
        return replyMenu;
    }

    public JLabel getSavNbField() {
        return savNbField;
    }

    public JLabel getSavNbLabel() {
        return savNbLabel;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JPopupMenu getTreePopup() {
        return treePopup;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDemandeListPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainSplitPane, BorderLayout.CENTER);
    }

    protected void addChildrenToMainSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        mainSplitPane.add($JScrollPane0, JSplitPane.LEFT);
        mainSplitPane.add($JPanel0, JSplitPane.RIGHT);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(printMenu);
        tablePopup.add(replyMenu);
        tablePopup.add(archiveMenu);
    }

    protected void addChildrenToTreePopup() {
        if (!allComponentsCreated) {
            return;
        }
        treePopup.add(computeQuantitiesByRangeMenu);
        treePopup.add(newDemandMenu);
    }

    protected void createArchiveMenu() {
        $objectMap.put("archiveMenu", archiveMenu = new JMenuItem());
        
        archiveMenu.setName("archiveMenu");
        archiveMenu.setText(t("faxtomail.demandeList.action.archive"));
        archiveMenu.setToolTipText(t("faxtomail.demandeList.action.archive.tip"));
        archiveMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__archiveMenu"));
    }

    protected void createComputeQuantitiesByRangeMenu() {
        $objectMap.put("computeQuantitiesByRangeMenu", computeQuantitiesByRangeMenu = new JMenuItem());
        
        computeQuantitiesByRangeMenu.setName("computeQuantitiesByRangeMenu");
        computeQuantitiesByRangeMenu.setText(t("faxtomail.demandeList.action.computeQuantitiesByRange"));
        computeQuantitiesByRangeMenu.setToolTipText(t("faxtomail.demandeList.action.computeQuantitiesByRange.tip"));
        computeQuantitiesByRangeMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__computeQuantitiesByRangeMenu"));
    }

    protected void createDataTable() {
        $objectMap.put("dataTable", dataTable = new JXTable());
        
        dataTable.setName("dataTable");
        dataTable.setSortable(false);
        dataTable.setEditable(true);
        dataTable.setAutoCreateRowSorter(true);
        dataTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__dataTable"));
        dataTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__dataTable"));
    }

    protected void createDemandNbField() {
        $objectMap.put("demandNbField", demandNbField = new JLabel());
        
        demandNbField.setName("demandNbField");
    }

    protected void createDemandNbLabel() {
        $objectMap.put("demandNbLabel", demandNbLabel = new JLabel());
        
        demandNbLabel.setName("demandNbLabel");
        demandNbLabel.setText(t("faxtomail.demandeList.demandNbLabel"));
        if (demandNbLabel.getFont() != null) {
            demandNbLabel.setFont(demandNbLabel.getFont().deriveFont(demandNbLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createMainSplitPane() {
        $objectMap.put("mainSplitPane", mainSplitPane = new JSplitPane());
        
        mainSplitPane.setName("mainSplitPane");
        mainSplitPane.setResizeWeight(0.2);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DemandeListUIModel.class));
    }

    protected void createNavigationTree() {
        $objectMap.put("navigationTree", navigationTree = new JTree());
        
        navigationTree.setName("navigationTree");
        navigationTree.setRootVisible(false);
        if (navigationTree.getFont() != null) {
            navigationTree.setFont(navigationTree.getFont().deriveFont((float) 11));
        }
        navigationTree.setShowsRootHandles(true);
        navigationTree.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__navigationTree"));
    }

    protected void createNewDemandMenu() {
        $objectMap.put("newDemandMenu", newDemandMenu = new JMenuItem());
        
        newDemandMenu.setName("newDemandMenu");
        newDemandMenu.setText(t("faxtomail.demandeList.action.newDemand"));
        newDemandMenu.setToolTipText(t("faxtomail.demandeList.action.newDemand.tip"));
        newDemandMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newDemandMenu"));
    }

    protected void createPfNbField() {
        $objectMap.put("pfNbField", pfNbField = new JLabel());
        
        pfNbField.setName("pfNbField");
    }

    protected void createPfNbLabel() {
        $objectMap.put("pfNbLabel", pfNbLabel = new JLabel());
        
        pfNbLabel.setName("pfNbLabel");
        pfNbLabel.setText(t("faxtomail.demandeList.pfNbLabel"));
        if (pfNbLabel.getFont() != null) {
            pfNbLabel.setFont(pfNbLabel.getFont().deriveFont(pfNbLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createPrintMenu() {
        $objectMap.put("printMenu", printMenu = new JMenuItem());
        
        printMenu.setName("printMenu");
        printMenu.setText(t("faxtomail.demandeList.action.print"));
        printMenu.setToolTipText(t("faxtomail.demandeList.action.print.tip"));
        printMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printMenu"));
    }

    protected void createQuotationNbField() {
        $objectMap.put("quotationNbField", quotationNbField = new JLabel());
        
        quotationNbField.setName("quotationNbField");
    }

    protected void createQuotationNbLabel() {
        $objectMap.put("quotationNbLabel", quotationNbLabel = new JLabel());
        
        quotationNbLabel.setName("quotationNbLabel");
        quotationNbLabel.setText(t("faxtomail.demandeList.quotationNbLabel"));
        if (quotationNbLabel.getFont() != null) {
            quotationNbLabel.setFont(quotationNbLabel.getFont().deriveFont(quotationNbLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createReplyMenu() {
        $objectMap.put("replyMenu", replyMenu = new JMenuItem());
        
        replyMenu.setName("replyMenu");
        replyMenu.setText(t("faxtomail.demandeList.action.reply"));
        replyMenu.setToolTipText(t("faxtomail.demandeList.action.reply.tip"));
        replyMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__replyMenu"));
    }

    protected void createSavNbField() {
        $objectMap.put("savNbField", savNbField = new JLabel());
        
        savNbField.setName("savNbField");
    }

    protected void createSavNbLabel() {
        $objectMap.put("savNbLabel", savNbLabel = new JLabel());
        
        savNbLabel.setName("savNbLabel");
        savNbLabel.setText(t("faxtomail.demandeList.savNbLabel"));
        if (savNbLabel.getFont() != null) {
            savNbLabel.setFont(savNbLabel.getFont().deriveFont(savNbLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
    }

    protected void createTreePopup() {
        $objectMap.put("treePopup", treePopup = new JPopupMenu());
        
        treePopup.setName("treePopup");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDemandeListPanel();
        addChildrenToTreePopup();
        addChildrenToTablePopup();
        addChildrenToMainSplitPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(navigationTree);
        // inline complete setup of $JPanel0
        $JPanel0.add($JPanel1, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane1, BorderLayout.CENTER);
        // inline complete setup of $JPanel1
        $JPanel1.add(demandNbLabel);
        $JPanel1.add(demandNbField);
        $JPanel1.add($JLabel0);
        $JPanel1.add(quotationNbLabel);
        $JPanel1.add(quotationNbField);
        $JPanel1.add($JLabel1);
        $JPanel1.add(pfNbLabel);
        $JPanel1.add(pfNbField);
        $JPanel1.add($JLabel2);
        $JPanel1.add(savNbLabel);
        $JPanel1.add(savNbField);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(dataTable);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        computeQuantitiesByRangeMenu.setIcon(SwingUtil.createActionIcon("compute"));
        newDemandMenu.setIcon(SwingUtil.createActionIcon("new-demand"));
        printMenu.setIcon(SwingUtil.createActionIcon("print"));
        replyMenu.setIcon(SwingUtil.createActionIcon("reply"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("demandeListPanel", demandeListPanel);
        createModel();
        createTreePopup();
        createComputeQuantitiesByRangeMenu();
        createNewDemandMenu();
        createTablePopup();
        createPrintMenu();
        createReplyMenu();
        createArchiveMenu();
        createMainSplitPane();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNavigationTree();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new FlowLayout(FlowLayout.LEADING));
        createDemandNbLabel();
        createDemandNbField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t(" | "));
        createQuotationNbLabel();
        createQuotationNbField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t(" | "));
        createPfNbLabel();
        createPfNbField();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t(" | "));
        createSavNbLabel();
        createSavNbField();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createDataTable();
        // inline creation of demandeListPanel
        setName("demandeListPanel");
        setLayout(new BorderLayout());
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLY_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("replyEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    replyMenu.setEnabled( model.isReplyEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("replyEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVE_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("archiveEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    archiveMenu.setEnabled( model.isArchiveEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("archiveEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEMAND_NB_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("emailNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    demandNbField.setText(t( String.valueOf(model.getEmailNb()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("emailNb", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUOTATION_NB_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quotationNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quotationNbField.setText(t( String.valueOf(model.getQuotationNb()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quotationNb", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PF_NB_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("pfNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    pfNbField.setText(t( String.valueOf(model.getPfNb()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("pfNb", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAV_NB_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("savNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    savNbField.setText(t( String.valueOf(model.getSavNb()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("savNb", this);
                }
            }
        });
    }

}