package com.franciaflex.faxtomail.ui.swing.content.config;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Franciaflex
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.actions.ReloadFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class FaxToMailConfigUIHandler extends AbstractFaxToMailUIHandler<FaxToMailUIContext, FaxToMailConfigUI> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(FaxToMailConfigUIHandler.class);


    public static final String CALLBACK_APPLICATION = "application";

    public static final String CALLBACK_UI = "ui";

    public static final String CALLBACK_SHORTCUT = "shortcut";

    @Override
    public SwingValidator<FaxToMailUIContext> getValidator() {
        return null;
    }

    @Override
    public void afterInit(FaxToMailConfigUI faxToMailConfigUI) {

        initUI(ui);

//        FaxToMailApplicationConfig config = getConfig();

//        ConfigUIHelper helper = new ConfigUIHelper(config.getApplicationConfig(),
//                                                   config.getConfigFile());

//        helper.registerCallBack(
//                CALLBACK_UI, n_("faxtomail.config.action.reload.ui"),
//                SwingUtil.createActionIcon("reload-ui"),
//                new Runnable() {
//
//                    @Override
//                    public void run() {
//                        reloadUI();
//                    }
//                }
//        ).registerCallBack(
//                CALLBACK_APPLICATION, n_("faxtomail.config.action.reload.application"),
//                SwingUtil.createActionIcon("reload-application"),
//                new Runnable() {
//
//                    @Override
//                    public void run() {
//                        reloadApplication();
//                    }
//                }
//        ).registerCallBack(
//                CALLBACK_SHORTCUT, n_("faxtomail.config.action.reload.actions"),
//                SwingUtil.createActionIcon("reload-shortcut"),
//                new Runnable() {
//
//                    @Override
//                    public void run() {
//                        reloadShortcuts();
//                    }
//                }
//        );

        // Application category

//        helper.addCategory(n_("faxtomail.config.category.applications"),
//                           n_("faxtomail.config.category.applications.description"),
//                           CALLBACK_APPLICATION)
//                .addOption(FaxToMailServiceConfigOption.CSV_SEPARATOR)
//                .setOptionShortLabel(_("faxtomail.config.option.csv.separator.shortLabel"))
//
//                .addOption(FaxToMailApplicationConfigOption.UI_CONFIG_FILE)
//                .setOptionShortLabel(_("faxtomail.config.option.ui.config.file.shortLabel"));

        // UI category

//        helper.addCategory(n_("faxtomail.config.category.ui"),
//                           n_("faxtomail.config.category.ui.description"),
//                           CALLBACK_UI)
//                .addOption(FaxToMailApplicationConfigOption.COLOR_ALTERNATE_ROW)
//                .setOptionShortLabel(_("faxtomail.config.option.ui.color.alternateRow.shortLabel"))
//
//                .addOption(FaxToMailApplicationConfigOption.COLOR_SELECTED_ROW)
//                .setOptionShortLabel(_("faxtomail.config.option.ui.color.selectedRow.shortLabel"))
//
//                .addOption(FaxToMailApplicationConfigOption.COLOR_BLOCKING_LAYER)
//                .setOptionShortLabel(_("faxtomail.config.option.ui.color.blockingLayer.shortLabel"))
//
//                .addOption(FaxToMailApplicationConfigOption.DATE_FORMAT)
//                .setOptionShortLabel(_("faxtomail.config.option.ui.dateFormat.shortLabel"));

        // Technical category

//        helper.addCategory(n_("faxtomail.config.category.technical"),
//                           n_("faxtomail.config.category.technical.description"))
//                .addOption(FaxToMailServiceConfigOption.BASEDIR)
//                .setOptionShortLabel(_("faxtomail.config.option.basedir.shortLabel"))
//
//                .addOption(FaxToMailServiceConfigOption.TMP_DIRECTORY)
//                .setOptionShortLabel(_("faxtomail.config.option.tmp.directory.shortLabel"))
//
//                .addOption(FaxToMailApplicationConfigOption.FAXTOMAIL_I18N_DIRECTORY)
//                .setOptionShortLabel(_("faxtomail.config.option.i18n.directory.shortLabel"))
//
////                .addOption(FaxToMailApplicationConfigOption.FAXTOMAIL_HELP_DIRECTORY)
////                .setOptionShortLabel(_("faxtomail.config.option.help.directory.shortLabel"))
//
//                .addOption(FaxToMailServiceConfigOption.SITE_URL)
//                .setOptionShortLabel(_("faxtomail.config.option.site.url.shortLabel"));


//        helper.setFinalizer(new MainCallBackFinalizer(CALLBACK_APPLICATION));

//        helper.setCloseAction(new Runnable() {
//            @Override
//            public void run() {
//
//                FaxToMailActionHelper.runInternalAction(
//                        FaxToMailConfigUIHandler.this,
//                        GoToPreviousScreenAction.class);
//
//            }
//        });
//        ConfigUI configUI = helper.buildUI(
//                getUI(),
//                n_("faxtomail.config.category.applications"));
//
//        configUI.getHandler().setTopContainer(getUI());
//        getUI().add(configUI, BorderLayout.CENTER);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return getUI();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }
    }

    protected void reloadApplication() {
        ReloadFaxToMailAction action = getContext().getActionFactory().createLogicAction(this, ReloadFaxToMailAction.class);
        getContext().getActionEngine().runAction(action);
//        TuttiActionHelper.runActionAndWait(this, ReloadTuttiAction.class);
    }

    protected void reloadUI() {
        getContext().getMainUI().getHandler().reloadUI();
    }

    protected void reloadShortcuts() {
        getContext().getMainUI().getHandler().reloadUI();
    }

}
