package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: SaveDemandeFromListAction.java 54 2014-04-29 08:51:47Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/actions/SaveDemandeFromListAction.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class SaveDemandeFromListAction extends AbstractFaxToMailAction<DemandeListUIModel, DemandeListUI, DemandeListUIHandler> {

    protected String[] modifiedProperties;

    public SaveDemandeFromListAction(DemandeListUIHandler handler) {
        super(handler, false);
    }

    public void setModifiedProperties(String... properties) {
        modifiedProperties = properties;
    }

    @Override
    public void doAction() throws Exception {
        FaxToMailUIContext context = getContext();

        for (DemandeUIModel model : getModel().getCurrentEmails()) {

            String topiaId = model.getTopiaId();
            Email persistedEmail = context.getEmailService().getEmailById(topiaId);

            FaxToMailUser currentUser = context.getCurrentUser();
            Email email = model.toEntity(persistedEmail);

            email = context.getEmailService().saveEmail(email, currentUser, modifiedProperties);
            model.fromEntity(email);
        }
    }
}
