package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;

import java.util.ArrayList;
import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class LoadFolderEmailsAction extends AbstractFaxToMailAction<DemandeListUIModel, DemandeListUI, DemandeListUIHandler> {

    private final static Log log = LogFactory.getLog(LoadFolderEmailsAction.class);

    public LoadFolderEmailsAction(DemandeListUIHandler handler) {
        super(handler, false);
    }

    @Override
    public boolean prepareAction() throws Exception {

        DemandeListUIModel model = getModel();
        MailFolder folder = model.getSelectedFolder();
        JXTable dataTable = getUI().getDataTable();

        setActionDescription(t("faxtomail.action.loadFolderEmails.tip", folder.getName()));

        // change name to save the state of the column width for every folder
        // (as every folder can have a different header)
        getContext().getSwingSession().updateState();
        String columns = handler.populateColumnModel(dataTable, false);
        dataTable.setName("dataTable" + columns);
        getContext().getSwingSession().add(dataTable, true);

        return true;
    }

    @Override
    public void doAction() throws Exception {
        DemandeListUIHandler handler = getHandler();
        DemandeListUIModel model = getModel();
        MailFolder folder = model.getSelectedFolder();

        List<Email> emails = getContext().getEmailService().getEmailForFolder(folder);
        log.info(emails.size() + " emails in folder " + folder.getName());

        List<DemandeUIModel> demands = new ArrayList<DemandeUIModel>();
        for (Email email : emails) {
            DemandeUIModel demand = new DemandeUIModel();
            demand.fromEntity(email, false);
            demand.setValid(handler.isDemandeValid(demand));
            demands.add(demand);
        }

        model.setEmails(demands);
    }
}
