package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Tue Sep 08 16:00:54 CEST 2015")
public abstract class StampAbstract extends AbstractTopiaEntity implements Stamp {

    /**
     * Nom de l'attribut en BD : image
     */
    protected String image;

    /**
     * Nom de l'attribut en BD : text
     */
    protected String text;

    /**
     * Nom de l'attribut en BD : label
     */
    protected String label;

    /**
     * Nom de l'attribut en BD : description
     */
    protected String description;

    /**
     * Nom de l'attribut en BD : signing
     */
    protected boolean signing;

    /**
     * Nom de l'attribut en BD : users
     */
    protected Collection<FaxToMailUser> users;

    /**
     * Nom de l'attribut en BD : groups
     */
    protected Collection<FaxToMailUserGroup> groups;

    private static final long serialVersionUID = 7306581537954412601L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_IMAGE, String.class, image);
        visitor.visit(this, PROPERTY_TEXT, String.class, text);
        visitor.visit(this, PROPERTY_LABEL, String.class, label);
        visitor.visit(this, PROPERTY_DESCRIPTION, String.class, description);
        visitor.visit(this, PROPERTY_SIGNING, boolean.class, signing);
        visitor.visit(this, PROPERTY_USERS, Collection.class, FaxToMailUser.class, users);
        visitor.visit(this, PROPERTY_GROUPS, Collection.class, FaxToMailUserGroup.class, groups);
    }

    @Override
    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public String getImage() {
        String result = this.image;
        return result;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        String result = this.text;
        return result;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        String result = this.label;
        return result;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        String result = this.description;
        return result;
    }

    @Override
    public void setSigning(boolean signing) {
        this.signing = signing;
    }

    @Override
    public boolean isSigning() {
        boolean result = this.signing;
        return result;
    }

    @Override
    public void addUsers(FaxToMailUser users) {
        if (this.users == null) {
            this.users = new LinkedList<FaxToMailUser>();
        }
        this.users.add(users);
    }

    @Override
    public void addAllUsers(Collection<FaxToMailUser> users) {
        if (users == null) {
            return;
        }
        for (FaxToMailUser item : users) {
            addUsers(item);
        }
    }

    @Override
    public void setUsers(Collection<FaxToMailUser> users) {
        this.users = users;
    }

    @Override
    public void removeUsers(FaxToMailUser users) {
        if (this.users == null || !this.users.remove(users)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearUsers() {
        if (this.users == null) {
            return;
        }
        this.users.clear();
    }

    @Override
    public Collection<FaxToMailUser> getUsers() {
        return users;
    }

    @Override
    public FaxToMailUser getUsersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(users, topiaId);
    }

    @Override
    public Collection<String> getUsersTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUser> tmp = getUsers();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeUsers() {
        if (users == null) {
            return 0;
        }
        return users.size();
    }

    @Override
    public boolean isUsersEmpty() {
        int size = sizeUsers();
        return size == 0;
    }

    @Override
    public boolean isUsersNotEmpty() {
        boolean empty = isUsersEmpty();
        return ! empty;
    }

    @Override
    public boolean containsUsers(FaxToMailUser users) {
        boolean contains = this.users !=null && this.users.contains(users);
        return contains;
    }

    @Override
    public void addGroups(FaxToMailUserGroup groups) {
        if (this.groups == null) {
            this.groups = new LinkedList<FaxToMailUserGroup>();
        }
        this.groups.add(groups);
    }

    @Override
    public void addAllGroups(Collection<FaxToMailUserGroup> groups) {
        if (groups == null) {
            return;
        }
        for (FaxToMailUserGroup item : groups) {
            addGroups(item);
        }
    }

    @Override
    public void setGroups(Collection<FaxToMailUserGroup> groups) {
        this.groups = groups;
    }

    @Override
    public void removeGroups(FaxToMailUserGroup groups) {
        if (this.groups == null || !this.groups.remove(groups)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearGroups() {
        if (this.groups == null) {
            return;
        }
        this.groups.clear();
    }

    @Override
    public Collection<FaxToMailUserGroup> getGroups() {
        return groups;
    }

    @Override
    public FaxToMailUserGroup getGroupsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(groups, topiaId);
    }

    @Override
    public Collection<String> getGroupsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup> tmp = getGroups();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeGroups() {
        if (groups == null) {
            return 0;
        }
        return groups.size();
    }

    @Override
    public boolean isGroupsEmpty() {
        int size = sizeGroups();
        return size == 0;
    }

    @Override
    public boolean isGroupsNotEmpty() {
        boolean empty = isGroupsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsGroups(FaxToMailUserGroup groups) {
        boolean contains = this.groups !=null && this.groups.contains(groups);
        return contains;
    }

} //StampAbstract
