package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Wed May 06 09:59:05 UTC 2015")
public abstract class GeneratedFaxToMailUserTopiaDao<E extends FaxToMailUser> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) FaxToMailUser.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.FaxToMailUser;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            EmailTopiaDao dao = topiaDaoSupplier
                    .getDao(Email.class, EmailTopiaDao.class);
            List<Email> list = dao
                    .forProperties(Email.PROPERTY_TAKEN_BY, entity)
                    .findAll();
            for (Email item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getTakenBy())) {
                    item.setTakenBy(null);
                }
            
            }
        }

        {
            HistoryTopiaDao dao = topiaDaoSupplier
                    .getDao(History.class, HistoryTopiaDao.class);
            List<History> list = dao
                    .forProperties(History.PROPERTY_FAX_TO_MAIL_USER, entity)
                    .findAll();
            for (History item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getFaxToMailUser())) {
                    item.setFaxToMailUser(null);
                }
            
            }
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.topiaid " +
                    " FROM mailFolder main, mailfolder_readrightusers secondary " +
                    " WHERE main.topiaid=secondary.mailFolder " +
                    " AND secondary.readRightUsers='" + entity.getTopiaId() + "'";
            List<MailFolder> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", FaxToMailEntityEnum.MailFolder.getImplementation())
                    .list();

            for (MailFolder item : list) {
                item.removeReadRightUsers(entity);
            }
        }

        {
            String sql = "SELECT main.topiaid " +
                    " FROM mailFolder main, mailfolder_moverightusers secondary " +
                    " WHERE main.topiaid=secondary.mailFolder " +
                    " AND secondary.moveRightUsers='" + entity.getTopiaId() + "'";
            List<MailFolder> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", FaxToMailEntityEnum.MailFolder.getImplementation())
                    .list();

            for (MailFolder item : list) {
                item.removeMoveRightUsers(entity);
            }
        }

        {
            String sql = "SELECT main.topiaid " +
                    " FROM groupChef main, groupchef_managedusers secondary " +
                    " WHERE main.topiaid=secondary.groupChef " +
                    " AND secondary.managedUsers='" + entity.getTopiaId() + "'";
            List<GroupChef> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", FaxToMailEntityEnum.GroupChef.getImplementation())
                    .list();

            for (GroupChef item : list) {
                item.removeManagedUsers(entity);
            }
        }

        {
            ClientTopiaDao dao = topiaDaoSupplier
                    .getDao(Client.class, ClientTopiaDao.class);
            List<Client> list = dao
                    .forProperties(Client.PROPERTY_PERSON_IN_CHARGE, entity)
                    .findAll();
            for (Client item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getPersonInCharge())) {
                    item.setPersonInCharge(null);
                }
            
            }
        }

        {
            EmailTopiaDao dao = topiaDaoSupplier
                    .getDao(Email.class, EmailTopiaDao.class);
            List<Email> list = dao
                    .forProperties(Email.PROPERTY_LAST_ATTACHMENT_OPENER, entity)
                    .findAll();
            for (Email item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getLastAttachmentOpener())) {
                    item.setLastAttachmentOpener(null);
                }
            
            }
        }

        {
            ReplyTopiaDao dao = topiaDaoSupplier
                    .getDao(Reply.class, ReplyTopiaDao.class);
            List<Reply> list = dao
                    .forProperties(Reply.PROPERTY_SENT_BY, entity)
                    .findAll();
            for (Reply item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getSentBy())) {
                    item.setSentBy(null);
                }
            
            }
        }

        {
            MailLockTopiaDao dao = topiaDaoSupplier
                    .getDao(MailLock.class, MailLockTopiaDao.class);
            List<MailLock> list = dao
                    .forProperties(MailLock.PROPERTY_LOCK_BY, entity)
                    .findAll();
            for (MailLock item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getLockBy())) {
                    item.setLockBy(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String login) {
        return forNaturalId(login).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String login) {
        return forNaturalId(login).exists();
    }

    public E createByNaturalId(String login) {
        return create(FaxToMailUser.PROPERTY_LOGIN, login);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String login) {
        return forProperties(FaxToMailUser.PROPERTY_LOGIN, login);
    }

    public E createByNotNull(String login) {
        return create(FaxToMailUser.PROPERTY_LOGIN, login);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLastNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(FaxToMailUser.PROPERTY_LAST_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLastNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(FaxToMailUser.PROPERTY_LAST_NAME, v);
        return result;
    }

    @Deprecated
    public E findByLastName(String v) {
        return forLastNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLastName(String v) {
        return forLastNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLoginIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(FaxToMailUser.PROPERTY_LOGIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLoginEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(FaxToMailUser.PROPERTY_LOGIN, v);
        return result;
    }

    @Deprecated
    public E findByLogin(String v) {
        return forLoginEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLogin(String v) {
        return forLoginEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTrigraphIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(FaxToMailUser.PROPERTY_TRIGRAPH, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTrigraphEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(FaxToMailUser.PROPERTY_TRIGRAPH, v);
        return result;
    }

    @Deprecated
    public E findByTrigraph(String v) {
        return forTrigraphEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTrigraph(String v) {
        return forTrigraphEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFirstNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(FaxToMailUser.PROPERTY_FIRST_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFirstNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(FaxToMailUser.PROPERTY_FIRST_NAME, v);
        return result;
    }

    @Deprecated
    public E findByFirstName(String v) {
        return forFirstNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFirstName(String v) {
        return forFirstNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHiddenIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(FaxToMailUser.PROPERTY_HIDDEN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHiddenEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(FaxToMailUser.PROPERTY_HIDDEN, v);
        return result;
    }

    @Deprecated
    public E findByHidden(boolean v) {
        return forHiddenEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByHidden(boolean v) {
        return forHiddenEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUserGroupsContains(FaxToMailUserGroup v) {
        return forContains(FaxToMailUser.PROPERTY_USER_GROUPS, v);
    }

    @Deprecated
    public E findContainsUserGroups(FaxToMailUserGroup v) {
        return forUserGroupsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsUserGroups(FaxToMailUserGroup v) {
        return forUserGroupsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAffectedFoldersContains(MailFolder v) {
        return forContains(FaxToMailUser.PROPERTY_AFFECTED_FOLDERS, v);
    }

    @Deprecated
    public E findContainsAffectedFolders(MailFolder v) {
        return forAffectedFoldersContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsAffectedFolders(MailFolder v) {
        return forAffectedFoldersContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == GroupChef.class) {
            GroupChefTopiaDao dao =
                topiaDaoSupplier.getDao(GroupChef.class, GroupChefTopiaDao.class);
            tmp = dao.forManagedUsersContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Client.class) {
            ClientTopiaDao dao =
                topiaDaoSupplier.getDao(Client.class, ClientTopiaDao.class);
            tmp = dao.forPersonInChargeEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == MailLock.class) {
            MailLockTopiaDao dao =
                topiaDaoSupplier.getDao(MailLock.class, MailLockTopiaDao.class);
            tmp = dao.forLockByEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == History.class) {
            HistoryTopiaDao dao =
                topiaDaoSupplier.getDao(History.class, HistoryTopiaDao.class);
            tmp = dao.forFaxToMailUserEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Reply.class) {
            ReplyTopiaDao dao =
                topiaDaoSupplier.getDao(Reply.class, ReplyTopiaDao.class);
            tmp = dao.forSentByEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == MailFolder.class) {
            MailFolderTopiaDao dao =
                topiaDaoSupplier.getDao(MailFolder.class, MailFolderTopiaDao.class);
            tmp = dao.forCustomerResponsiblesContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == MailFolder.class) {
            MailFolderTopiaDao dao =
                topiaDaoSupplier.getDao(MailFolder.class, MailFolderTopiaDao.class);
            tmp = dao.forReadRightUsersContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == MailFolder.class) {
            MailFolderTopiaDao dao =
                topiaDaoSupplier.getDao(MailFolder.class, MailFolderTopiaDao.class);
            tmp = dao.forMoveRightUsersContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == MailFolder.class) {
            MailFolderTopiaDao dao =
                topiaDaoSupplier.getDao(MailFolder.class, MailFolderTopiaDao.class);
            tmp = dao.forWriteRightUsersContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Email.class) {
            EmailTopiaDao dao =
                topiaDaoSupplier.getDao(Email.class, EmailTopiaDao.class);
            tmp = dao.forTakenByEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Email.class) {
            EmailTopiaDao dao =
                topiaDaoSupplier.getDao(Email.class, EmailTopiaDao.class);
            tmp = dao.forLastAttachmentOpenerEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(7);

        List<? extends TopiaEntity> list;

        list = findUsages(GroupChef.class, entity);
        if (!list.isEmpty()) {
            result.put(GroupChef.class, list);
        }

        list = findUsages(Client.class, entity);
        if (!list.isEmpty()) {
            result.put(Client.class, list);
        }

        list = findUsages(MailLock.class, entity);
        if (!list.isEmpty()) {
            result.put(MailLock.class, list);
        }

        list = findUsages(History.class, entity);
        if (!list.isEmpty()) {
            result.put(History.class, list);
        }

        list = findUsages(Reply.class, entity);
        if (!list.isEmpty()) {
            result.put(Reply.class, list);
        }

        list = findUsages(MailFolder.class, entity);
        if (!list.isEmpty()) {
            result.put(MailFolder.class, list);
        }

        list = findUsages(Email.class, entity);
        if (!list.isEmpty()) {
            result.put(Email.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedFaxToMailUserTopiaDao<E extends FaxToMailUser>
