/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.OutlineHighlightPainter;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.TipUtil;
import org.fife.ui.autocomplete.Util;

class ParameterizedCompletionDescriptionToolTip {
    private JWindow tooltip;
    Highlighter.HighlightPainter p;
    List tags;
    private AutoCompletion ac;
    private JLabel descLabel;
    private ParameterizedCompletion pc;
    private Listener listener;
    private int minPos;
    private Position maxPos;
    private int lastSelectedParam;
    private Object oldTabKey;
    private Action oldTabAction;
    private Object oldShiftTabKey;
    private Action oldShiftTabAction;
    private Object oldEnterKey;
    private Action oldEnterAction;
    private Object oldEscapeKey;
    private Action oldEscapeAction;
    private Object oldClosingKey;
    private Action oldClosingAction;
    private static final String IM_KEY_TAB = "ParamCompDescTip.Tab";
    private static final String IM_KEY_SHIFT_TAB = "ParamCompDescTip.ShiftTab";
    private static final String IM_KEY_ESCAPE = "ParamCompDescTip.Escape";
    private static final String IM_KEY_ENTER = "ParamCompDescTip.Enter";
    private static final String IM_KEY_CLOSING = "ParamCompDescTip.Closing";

    public ParameterizedCompletionDescriptionToolTip(Window owner, AutoCompletion ac, ParameterizedCompletion pc) {
        this.tooltip = new JWindow(owner);
        this.ac = ac;
        this.pc = pc;
        this.descLabel = new JLabel();
        this.descLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.descLabel.setOpaque(true);
        this.descLabel.setBackground(TipUtil.getToolTipBackground());
        this.tooltip.setContentPane(this.descLabel);
        this.lastSelectedParam = -1;
        this.updateText(0);
        this.tooltip.setFocusableWindowState(false);
        this.listener = new Listener();
        this.p = new OutlineHighlightPainter(Color.GRAY);
        this.tags = new ArrayList(1);
    }

    private List getParameterHighlights() {
        ArrayList<Highlighter.Highlight> paramHighlights = new ArrayList<Highlighter.Highlight>(1);
        JTextComponent tc = this.ac.getTextComponent();
        Highlighter.Highlight[] highlights = tc.getHighlighter().getHighlights();
        for (int i = 0; i < highlights.length; ++i) {
            if (highlights[i].getPainter() != this.p) continue;
            paramHighlights.add(highlights[i]);
        }
        return paramHighlights;
    }

    private void installKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("ToolTip: Installing keybindings");
        }
        JTextComponent tc = this.ac.getTextComponent();
        InputMap im = tc.getInputMap();
        ActionMap am = tc.getActionMap();
        KeyStroke ks = KeyStroke.getKeyStroke(9, 0);
        this.oldTabKey = im.get(ks);
        im.put(ks, IM_KEY_TAB);
        this.oldTabAction = am.get(IM_KEY_TAB);
        am.put(IM_KEY_TAB, new NextParamAction());
        ks = KeyStroke.getKeyStroke(9, 1);
        this.oldShiftTabKey = im.get(ks);
        im.put(ks, IM_KEY_SHIFT_TAB);
        this.oldShiftTabAction = am.get(IM_KEY_SHIFT_TAB);
        am.put(IM_KEY_SHIFT_TAB, new PrevParamAction());
        ks = KeyStroke.getKeyStroke(10, 0);
        this.oldEnterKey = im.get(ks);
        im.put(ks, IM_KEY_ENTER);
        this.oldEnterAction = am.get(IM_KEY_ENTER);
        am.put(IM_KEY_ENTER, new GotoEndAction());
        ks = KeyStroke.getKeyStroke(27, 0);
        this.oldEscapeKey = im.get(ks);
        im.put(ks, IM_KEY_ESCAPE);
        this.oldEscapeAction = am.get(IM_KEY_ESCAPE);
        am.put(IM_KEY_ESCAPE, new HideAction());
        char end = this.pc.getProvider().getParameterListEnd();
        ks = KeyStroke.getKeyStroke(end);
        this.oldClosingKey = im.get(ks);
        im.put(ks, IM_KEY_CLOSING);
        this.oldClosingAction = am.get(IM_KEY_CLOSING);
        am.put(IM_KEY_CLOSING, new ClosingAction());
    }

    private void moveToNextParam() {
        JTextComponent tc = this.ac.getTextComponent();
        int dot = tc.getCaretPosition();
        int tagCount = this.tags.size();
        if (tagCount == 0) {
            tc.setCaretPosition(this.maxPos.getOffset());
            this.setVisible(false, false);
        }
        Highlighter.Highlight currentNext = null;
        int pos = -1;
        List highlights = this.getParameterHighlights();
        for (int i = 0; i < highlights.size(); ++i) {
            Highlighter.Highlight hl = (Highlighter.Highlight)highlights.get(i);
            if (currentNext != null && currentNext.getStartOffset() >= dot && (hl.getStartOffset() <= dot || hl.getStartOffset() > currentNext.getStartOffset())) continue;
            currentNext = hl;
            pos = i;
        }
        if (currentNext != null && dot <= currentNext.getStartOffset()) {
            tc.setSelectionStart(currentNext.getStartOffset() + 1);
            tc.setSelectionEnd(currentNext.getEndOffset());
            this.updateText(pos);
        } else {
            tc.setCaretPosition(this.maxPos.getOffset());
            this.setVisible(false, false);
        }
    }

    private void moveToPreviousParam() {
        JTextComponent tc = this.ac.getTextComponent();
        int tagCount = this.tags.size();
        if (tagCount == 0) {
            tc.setCaretPosition(this.maxPos.getOffset());
            this.setVisible(false, false);
        }
        int dot = tc.getCaretPosition();
        int selStart = tc.getSelectionStart() - 1;
        Highlighter.Highlight currentPrev = null;
        int pos = 0;
        Highlighter h = tc.getHighlighter();
        Highlighter.Highlight[] highlights = h.getHighlights();
        for (int i = 0; i < highlights.length; ++i) {
            Highlighter.Highlight hl = highlights[i];
            if (hl.getPainter() != this.p || currentPrev != null && currentPrev.getStartOffset() < dot && (hl.getStartOffset() >= selStart || hl.getStartOffset() <= currentPrev.getStartOffset())) continue;
            currentPrev = hl;
            pos = i;
        }
        if (currentPrev != null && dot > currentPrev.getStartOffset()) {
            tc.setSelectionStart(currentPrev.getStartOffset() + 1);
            tc.setSelectionEnd(currentPrev.getEndOffset());
            this.updateText(pos);
        } else {
            tc.setCaretPosition(this.maxPos.getOffset());
            this.setVisible(false, false);
        }
    }

    private void removeParameterHighlights() {
        JTextComponent tc = this.ac.getTextComponent();
        Highlighter h = tc.getHighlighter();
        for (int i = 0; i < this.tags.size(); ++i) {
            h.removeHighlight(this.tags.get(i));
        }
        this.tags.clear();
    }

    public void setLocationRelativeTo(Rectangle r) {
        int x;
        Rectangle screenBounds = Util.getScreenBoundsForPoint(r.x, r.y);
        int y = r.y - 5 - this.tooltip.getHeight();
        if (y < 0) {
            y = r.y + r.height + 5;
        }
        if ((x = r.x) < screenBounds.x) {
            x = screenBounds.x;
        } else if (x + this.tooltip.getWidth() > screenBounds.x + screenBounds.width) {
            x = screenBounds.x + screenBounds.width - this.tooltip.getWidth();
        }
        this.tooltip.setLocation(x, y);
    }

    public void setVisible(boolean visible, boolean addParamListStart) {
        if (visible != this.tooltip.isVisible()) {
            JTextComponent tc = this.ac.getTextComponent();
            if (visible) {
                this.listener.install(tc, addParamListStart);
            } else {
                this.listener.uninstall();
            }
            this.tooltip.setVisible(visible);
        }
    }

    private void uninstallKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("ToolTip: Uninstalling keybindings");
        }
        JTextComponent tc = this.ac.getTextComponent();
        InputMap im = tc.getInputMap();
        ActionMap am = tc.getActionMap();
        KeyStroke ks = KeyStroke.getKeyStroke(9, 0);
        im.put(ks, this.oldTabKey);
        am.put(IM_KEY_TAB, this.oldTabAction);
        ks = KeyStroke.getKeyStroke(9, 1);
        im.put(ks, this.oldShiftTabKey);
        am.put(IM_KEY_SHIFT_TAB, this.oldShiftTabAction);
        ks = KeyStroke.getKeyStroke(10, 0);
        im.put(ks, this.oldEnterKey);
        am.put(IM_KEY_ENTER, this.oldEnterAction);
        ks = KeyStroke.getKeyStroke(27, 0);
        im.put(ks, this.oldEscapeKey);
        am.put(IM_KEY_ESCAPE, this.oldEscapeAction);
        char end = this.pc.getProvider().getParameterListEnd();
        ks = KeyStroke.getKeyStroke(end);
        im.put(ks, this.oldClosingKey);
        am.put(IM_KEY_CLOSING, this.oldClosingAction);
    }

    private void updateText() {
        JTextComponent tc = this.ac.getTextComponent();
        int dot = tc.getCaretPosition();
        if (dot > 0) {
            --dot;
        }
        int index = -1;
        List paramHighlights = this.getParameterHighlights();
        for (int i = 0; i < paramHighlights.size(); ++i) {
            Highlighter.Highlight h = (Highlighter.Highlight)paramHighlights.get(i);
            if (dot < h.getStartOffset() || dot >= h.getEndOffset()) continue;
            index = i;
            break;
        }
        this.updateText(index);
    }

    private void updateText(int selectedParam) {
        ParameterizedCompletion.Parameter param;
        String desc;
        if (selectedParam == this.lastSelectedParam) {
            return;
        }
        this.lastSelectedParam = selectedParam;
        StringBuffer sb = new StringBuffer("<html>");
        int paramCount = this.pc.getParamCount();
        for (int i = 0; i < paramCount; ++i) {
            if (i == selectedParam) {
                sb.append("<b>");
            }
            sb.append(this.pc.getParam(i).toString());
            if (i == selectedParam) {
                sb.append("</b>");
            }
            if (i >= paramCount - 1) continue;
            sb.append(this.pc.getProvider().getParameterListSeparator());
        }
        if (selectedParam >= 0 && selectedParam < paramCount && (desc = (param = this.pc.getParam(selectedParam)).getDescription()) != null) {
            sb.append("<br>");
            sb.append(desc);
        }
        this.descLabel.setText(sb.toString());
        this.tooltip.pack();
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.tooltip);
    }

    private class PrevParamAction
    extends AbstractAction {
        private PrevParamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ParameterizedCompletionDescriptionToolTip.this.moveToPreviousParam();
        }
    }

    private class NextParamAction
    extends AbstractAction {
        private NextParamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ParameterizedCompletionDescriptionToolTip.this.moveToNextParam();
        }
    }

    private class Listener
    implements FocusListener,
    CaretListener {
        private Listener() {
        }

        public void caretUpdate(CaretEvent e) {
            int dot;
            if (ParameterizedCompletionDescriptionToolTip.this.maxPos == null) {
                ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
            }
            if ((dot = e.getDot()) < ParameterizedCompletionDescriptionToolTip.this.minPos || dot >= ParameterizedCompletionDescriptionToolTip.this.maxPos.getOffset()) {
                ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
            }
            ParameterizedCompletionDescriptionToolTip.this.updateText();
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
        }

        private String getParamText(ParameterizedCompletion.Parameter param) {
            String text = param.getName();
            if (text == null && (text = param.getType()) == null) {
                text = "arg";
            }
            return text;
        }

        public void install(JTextComponent tc, boolean addParamStartList) {
            tc.addCaretListener(this);
            tc.addFocusListener(this);
            ParameterizedCompletionDescriptionToolTip.this.installKeyBindings();
            StringBuffer sb = new StringBuffer();
            if (addParamStartList) {
                sb.append(ParameterizedCompletionDescriptionToolTip.this.pc.getProvider().getParameterListStart());
            }
            int dot = tc.getCaretPosition() + sb.length();
            int paramCount = ParameterizedCompletionDescriptionToolTip.this.pc.getParamCount();
            ArrayList<Point> paramLocs = null;
            if (paramCount > 0) {
                paramLocs = new ArrayList<Point>(paramCount);
            }
            Highlighter h = tc.getHighlighter();
            try {
                int i;
                ParameterizedCompletionDescriptionToolTip.this.minPos = dot;
                ParameterizedCompletionDescriptionToolTip.this.maxPos = tc.getDocument().createPosition(dot - sb.length());
                int firstParamLen = 0;
                int start = dot;
                for (i = 0; i < paramCount; ++i) {
                    ParameterizedCompletion.Parameter param = ParameterizedCompletionDescriptionToolTip.this.pc.getParam(i);
                    String paramText = this.getParamText(param);
                    if (i == 0) {
                        firstParamLen = paramText.length();
                    }
                    sb.append(paramText);
                    int end = start + paramText.length();
                    paramLocs.add(new Point(start, end));
                    String sep = ParameterizedCompletionDescriptionToolTip.this.pc.getProvider().getParameterListSeparator();
                    if (i >= paramCount - 1 || sep == null) continue;
                    sb.append(sep);
                    start = end + sep.length();
                }
                sb.append(ParameterizedCompletionDescriptionToolTip.this.pc.getProvider().getParameterListEnd());
                tc.replaceSelection(sb.toString());
                for (i = 0; i < paramCount; ++i) {
                    Point pt = (Point)paramLocs.get(i);
                    ParameterizedCompletionDescriptionToolTip.this.tags.add(h.addHighlight(pt.x - 1, pt.y, ParameterizedCompletionDescriptionToolTip.this.p));
                }
                tc.setCaretPosition(dot);
                if (ParameterizedCompletionDescriptionToolTip.this.pc.getParamCount() > 0) {
                    tc.moveCaretPosition(dot + firstParamLen);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }

        public void uninstall() {
            JTextComponent tc = ParameterizedCompletionDescriptionToolTip.this.ac.getTextComponent();
            tc.removeCaretListener(this);
            tc.removeFocusListener(this);
            ParameterizedCompletionDescriptionToolTip.this.uninstallKeyBindings();
            ParameterizedCompletionDescriptionToolTip.this.maxPos = null;
            ParameterizedCompletionDescriptionToolTip.this.minPos = -1;
            ParameterizedCompletionDescriptionToolTip.this.removeParameterHighlights();
        }
    }

    private class HideAction
    extends AbstractAction {
        private HideAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
        }
    }

    private class ClosingAction
    extends AbstractAction {
        private ClosingAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent tc = ParameterizedCompletionDescriptionToolTip.this.ac.getTextComponent();
            int dot = tc.getCaretPosition();
            char end = ParameterizedCompletionDescriptionToolTip.this.pc.getProvider().getParameterListEnd();
            if (dot >= ParameterizedCompletionDescriptionToolTip.this.maxPos.getOffset() - 1) {
                if (dot == ParameterizedCompletionDescriptionToolTip.this.maxPos.getOffset()) {
                    tc.replaceSelection(Character.toString(end));
                } else {
                    int endCount;
                    char start;
                    int startCount;
                    String text = this.getArgumentText(dot);
                    if (text != null && (startCount = this.getCount(text, start = ParameterizedCompletionDescriptionToolTip.this.pc.getProvider().getParameterListStart())) > (endCount = this.getCount(text, end))) {
                        tc.replaceSelection(Character.toString(end));
                        return;
                    }
                    tc.setCaretPosition(ParameterizedCompletionDescriptionToolTip.this.maxPos.getOffset());
                }
                ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
            } else {
                tc.replaceSelection(Character.toString(end));
            }
        }

        public String getArgumentText(int offs) {
            List paramHighlights = ParameterizedCompletionDescriptionToolTip.this.getParameterHighlights();
            if (paramHighlights == null || paramHighlights.size() == 0) {
                return null;
            }
            for (int i = 0; i < paramHighlights.size(); ++i) {
                Highlighter.Highlight h = (Highlighter.Highlight)paramHighlights.get(i);
                if (offs < h.getStartOffset() || offs > h.getEndOffset()) continue;
                int start = h.getStartOffset() + 1;
                int len = h.getEndOffset() - start;
                JTextComponent tc = ParameterizedCompletionDescriptionToolTip.this.ac.getTextComponent();
                Document doc = tc.getDocument();
                try {
                    return doc.getText(start, len);
                }
                catch (BadLocationException ble) {
                    UIManager.getLookAndFeel().provideErrorFeedback(tc);
                    ble.printStackTrace();
                    return null;
                }
            }
            return null;
        }

        public int getCount(String text, char ch) {
            int count = 0;
            int old = 0;
            int pos = 0;
            while ((pos = text.indexOf(ch, old)) > -1) {
                ++count;
                old = pos + 1;
            }
            return count;
        }
    }

    private class GotoEndAction
    extends AbstractAction {
        private GotoEndAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent tc = ParameterizedCompletionDescriptionToolTip.this.ac.getTextComponent();
            tc.setCaretPosition(ParameterizedCompletionDescriptionToolTip.this.maxPos.getOffset());
            ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
        }
    }
}

