/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.Group;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GroupInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="endPosition")
    private String endPosition = null;
    @JsonProperty(value="groups")
    private List<Group> groups = null;
    @JsonProperty(value="nextUri")
    private String nextUri = null;
    @JsonProperty(value="previousUri")
    private String previousUri = null;
    @JsonProperty(value="resultSetSize")
    private String resultSetSize = null;
    @JsonProperty(value="startPosition")
    private String startPosition = null;
    @JsonProperty(value="totalSetSize")
    private String totalSetSize = null;

    public GroupInformation endPosition(String endPosition) {
        this.endPosition = endPosition;
        return this;
    }

    @Schema(description="The last position in the result set. ")
    public String getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(String endPosition) {
        this.endPosition = endPosition;
    }

    public GroupInformation groups(List<Group> groups) {
        this.groups = groups;
        return this;
    }

    public GroupInformation addGroupsItem(Group groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<Group>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Schema(description="A collection group objects containing information about the groups returned.")
    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public GroupInformation nextUri(String nextUri) {
        this.nextUri = nextUri;
        return this;
    }

    @Schema(description="The URI to the next chunk of records based on the search request. If the endPosition is the entire results of the search, this is null. ")
    public String getNextUri() {
        return this.nextUri;
    }

    public void setNextUri(String nextUri) {
        this.nextUri = nextUri;
    }

    public GroupInformation previousUri(String previousUri) {
        this.previousUri = previousUri;
        return this;
    }

    @Schema(description="The postal code for the billing address.")
    public String getPreviousUri() {
        return this.previousUri;
    }

    public void setPreviousUri(String previousUri) {
        this.previousUri = previousUri;
    }

    public GroupInformation resultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
        return this;
    }

    @Schema(description="The number of results returned in this response. ")
    public String getResultSetSize() {
        return this.resultSetSize;
    }

    public void setResultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
    }

    public GroupInformation startPosition(String startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    @Schema(description="Starting position of the current result set.")
    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    public GroupInformation totalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
        return this;
    }

    @Schema(description="The total number of items available in the result set. This will always be greater than or equal to the value of the property returning the results in the in the response.")
    public String getTotalSetSize() {
        return this.totalSetSize;
    }

    public void setTotalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupInformation groupInformation = (GroupInformation)o;
        return Objects.equals(this.endPosition, groupInformation.endPosition) && Objects.equals(this.groups, groupInformation.groups) && Objects.equals(this.nextUri, groupInformation.nextUri) && Objects.equals(this.previousUri, groupInformation.previousUri) && Objects.equals(this.resultSetSize, groupInformation.resultSetSize) && Objects.equals(this.startPosition, groupInformation.startPosition) && Objects.equals(this.totalSetSize, groupInformation.totalSetSize);
    }

    public int hashCode() {
        return Objects.hash(this.endPosition, this.groups, this.nextUri, this.previousUri, this.resultSetSize, this.startPosition, this.totalSetSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupInformation {\n");
        sb.append("    endPosition: ").append(this.toIndentedString(this.endPosition)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    nextUri: ").append(this.toIndentedString(this.nextUri)).append("\n");
        sb.append("    previousUri: ").append(this.toIndentedString(this.previousUri)).append("\n");
        sb.append("    resultSetSize: ").append(this.toIndentedString(this.resultSetSize)).append("\n");
        sb.append("    startPosition: ").append(this.toIndentedString(this.startPosition)).append("\n");
        sb.append("    totalSetSize: ").append(this.toIndentedString(this.totalSetSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

