/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AddressInformation;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="This object contains information about a credit card that is associated with an account.")
public class CreditCardInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="address")
    private AddressInformation address = null;
    @JsonProperty(value="cardLastDigits")
    private String cardLastDigits = null;
    @JsonProperty(value="cardNumber")
    private String cardNumber = null;
    @JsonProperty(value="cardType")
    private String cardType = null;
    @JsonProperty(value="cvNumber")
    private String cvNumber = null;
    @JsonProperty(value="expirationMonth")
    private String expirationMonth = null;
    @JsonProperty(value="expirationYear")
    private String expirationYear = null;
    @JsonProperty(value="nameOnCard")
    private String nameOnCard = null;
    @JsonProperty(value="tokenizedCard")
    private String tokenizedCard = null;

    public CreditCardInformation address(AddressInformation address) {
        this.address = address;
        return this;
    }

    @Schema(description="A complex element containing the credit card billing address information.")
    public AddressInformation getAddress() {
        return this.address;
    }

    public void setAddress(AddressInformation address) {
        this.address = address;
    }

    public CreditCardInformation cardLastDigits(String cardLastDigits) {
        this.cardLastDigits = cardLastDigits;
        return this;
    }

    @Schema(description="")
    public String getCardLastDigits() {
        return this.cardLastDigits;
    }

    public void setCardLastDigits(String cardLastDigits) {
        this.cardLastDigits = cardLastDigits;
    }

    public CreditCardInformation cardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        return this;
    }

    @Schema(description="The number on the credit card.")
    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public CreditCardInformation cardType(String cardType) {
        this.cardType = cardType;
        return this;
    }

    @Schema(description="The credit card type. Valid values are: visa, mastercard, or amex.")
    public String getCardType() {
        return this.cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public CreditCardInformation cvNumber(String cvNumber) {
        this.cvNumber = cvNumber;
        return this;
    }

    @Schema(description="")
    public String getCvNumber() {
        return this.cvNumber;
    }

    public void setCvNumber(String cvNumber) {
        this.cvNumber = cvNumber;
    }

    public CreditCardInformation expirationMonth(String expirationMonth) {
        this.expirationMonth = expirationMonth;
        return this;
    }

    @Schema(description="The month that the credit card expires (1-12).")
    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public void setExpirationMonth(String expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    public CreditCardInformation expirationYear(String expirationYear) {
        this.expirationYear = expirationYear;
        return this;
    }

    @Schema(description="The year 4 digit year in which the credit card expires.")
    public String getExpirationYear() {
        return this.expirationYear;
    }

    public void setExpirationYear(String expirationYear) {
        this.expirationYear = expirationYear;
    }

    public CreditCardInformation nameOnCard(String nameOnCard) {
        this.nameOnCard = nameOnCard;
        return this;
    }

    @Schema(description="The exact name printed on the credit card.")
    public String getNameOnCard() {
        return this.nameOnCard;
    }

    public void setNameOnCard(String nameOnCard) {
        this.nameOnCard = nameOnCard;
    }

    public CreditCardInformation tokenizedCard(String tokenizedCard) {
        this.tokenizedCard = tokenizedCard;
        return this;
    }

    @Schema(description="")
    public String getTokenizedCard() {
        return this.tokenizedCard;
    }

    public void setTokenizedCard(String tokenizedCard) {
        this.tokenizedCard = tokenizedCard;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditCardInformation creditCardInformation = (CreditCardInformation)o;
        return Objects.equals(this.address, creditCardInformation.address) && Objects.equals(this.cardLastDigits, creditCardInformation.cardLastDigits) && Objects.equals(this.cardNumber, creditCardInformation.cardNumber) && Objects.equals(this.cardType, creditCardInformation.cardType) && Objects.equals(this.cvNumber, creditCardInformation.cvNumber) && Objects.equals(this.expirationMonth, creditCardInformation.expirationMonth) && Objects.equals(this.expirationYear, creditCardInformation.expirationYear) && Objects.equals(this.nameOnCard, creditCardInformation.nameOnCard) && Objects.equals(this.tokenizedCard, creditCardInformation.tokenizedCard);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.cardLastDigits, this.cardNumber, this.cardType, this.cvNumber, this.expirationMonth, this.expirationYear, this.nameOnCard, this.tokenizedCard);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditCardInformation {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    cardLastDigits: ").append(this.toIndentedString(this.cardLastDigits)).append("\n");
        sb.append("    cardNumber: ").append(this.toIndentedString(this.cardNumber)).append("\n");
        sb.append("    cardType: ").append(this.toIndentedString(this.cardType)).append("\n");
        sb.append("    cvNumber: ").append(this.toIndentedString(this.cvNumber)).append("\n");
        sb.append("    expirationMonth: ").append(this.toIndentedString(this.expirationMonth)).append("\n");
        sb.append("    expirationYear: ").append(this.toIndentedString(this.expirationYear)).append("\n");
        sb.append("    nameOnCard: ").append(this.toIndentedString(this.nameOnCard)).append("\n");
        sb.append("    tokenizedCard: ").append(this.toIndentedString(this.tokenizedCard)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

