/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.Country;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Contains information about an account address.")
public class AccountAddress
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="address1")
    private String address1 = null;
    @JsonProperty(value="address2")
    private String address2 = null;
    @JsonProperty(value="city")
    private String city = null;
    @JsonProperty(value="country")
    private String country = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="fax")
    private String fax = null;
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="postalCode")
    private String postalCode = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="supportedCountries")
    private List<Country> supportedCountries = null;

    public AccountAddress address1(String address1) {
        this.address1 = address1;
        return this;
    }

    @Schema(description="First Line of the address. Maximum length: 100 characters.")
    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public AccountAddress address2(String address2) {
        this.address2 = address2;
        return this;
    }

    @Schema(description="Second Line of the address. Maximum length: 100 characters.")
    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public AccountAddress city(String city) {
        this.city = city;
        return this;
    }

    @Schema(description="The city value of the address.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public AccountAddress country(String country) {
        this.country = country;
        return this;
    }

    @Schema(description="Specifies the country associated with the address.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public AccountAddress email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public AccountAddress fax(String fax) {
        this.fax = fax;
        return this;
    }

    @Schema(description="")
    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public AccountAddress firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Schema(description="The user's first name.  Maximum Length: 50 characters.")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public AccountAddress lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Schema(description="")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public AccountAddress phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Schema(description="")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public AccountAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Schema(description="")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public AccountAddress state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="The state or province associated with the address.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public AccountAddress supportedCountries(List<Country> supportedCountries) {
        this.supportedCountries = supportedCountries;
        return this;
    }

    public AccountAddress addSupportedCountriesItem(Country supportedCountriesItem) {
        if (this.supportedCountries == null) {
            this.supportedCountries = new ArrayList<Country>();
        }
        this.supportedCountries.add(supportedCountriesItem);
        return this;
    }

    @Schema(description="Contains an array of countries supported by the billing plan.")
    public List<Country> getSupportedCountries() {
        return this.supportedCountries;
    }

    public void setSupportedCountries(List<Country> supportedCountries) {
        this.supportedCountries = supportedCountries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountAddress accountAddress = (AccountAddress)o;
        return Objects.equals(this.address1, accountAddress.address1) && Objects.equals(this.address2, accountAddress.address2) && Objects.equals(this.city, accountAddress.city) && Objects.equals(this.country, accountAddress.country) && Objects.equals(this.email, accountAddress.email) && Objects.equals(this.fax, accountAddress.fax) && Objects.equals(this.firstName, accountAddress.firstName) && Objects.equals(this.lastName, accountAddress.lastName) && Objects.equals(this.phone, accountAddress.phone) && Objects.equals(this.postalCode, accountAddress.postalCode) && Objects.equals(this.state, accountAddress.state) && Objects.equals(this.supportedCountries, accountAddress.supportedCountries);
    }

    public int hashCode() {
        return Objects.hash(this.address1, this.address2, this.city, this.country, this.email, this.fax, this.firstName, this.lastName, this.phone, this.postalCode, this.state, this.supportedCountries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountAddress {\n");
        sb.append("    address1: ").append(this.toIndentedString(this.address1)).append("\n");
        sb.append("    address2: ").append(this.toIndentedString(this.address2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    fax: ").append(this.toIndentedString(this.fax)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    supportedCountries: ").append(this.toIndentedString(this.supportedCountries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

