/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.ApiResponse;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.ContactGetResponse;
import com.docusign.esign.model.ContactModRequest;
import com.docusign.esign.model.ContactUpdateResponse;
import com.docusign.esign.model.CustomSettingsInformation;
import com.docusign.esign.model.NewUsersDefinition;
import com.docusign.esign.model.NewUsersSummary;
import com.docusign.esign.model.UserInfoList;
import com.docusign.esign.model.UserInformation;
import com.docusign.esign.model.UserInformationList;
import com.docusign.esign.model.UserProfile;
import com.docusign.esign.model.UserSettingsInformation;
import com.docusign.esign.model.UserSignature;
import com.docusign.esign.model.UserSignatureDefinition;
import com.docusign.esign.model.UserSignaturesInformation;
import com.docusign.esign.model.UsersResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class UsersApi {
    private ApiClient apiClient;

    public UsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserInformationList callList(String accountId) throws ApiException {
        return this.callList(accountId, null);
    }

    public UserInformationList callList(String accountId, CallListOptions options) throws ApiException {
        ApiResponse<UserInformationList> localVarResponse = this.callListWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<UserInformationList> callListWithHttpInfo(String accountId, CallListOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling callList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("additional_info", options.additionalInfo));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("alternate_admins_only", options.alternateAdminsOnly));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("domain_users_only", options.domainUsersOnly));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", options.email));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email_substring", options.emailSubstring));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("group_id", options.groupId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_license", options.includeLicense));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_usersettings_for_csv", options.includeUsersettingsForCsv));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("login_status", options.loginStatus));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("not_group_id", options.notGroupId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_name_substring", options.userNameSubstring));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserInformationList> localVarReturnType = new GenericType<UserInformationList>(){};
        UserInformationList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserInformationList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public NewUsersSummary create(String accountId, NewUsersDefinition newUsersDefinition) throws ApiException {
        ApiResponse<NewUsersSummary> localVarResponse = this.createWithHttpInfo(accountId, newUsersDefinition);
        return localVarResponse.getData();
    }

    public ApiResponse<NewUsersSummary> createWithHttpInfo(String accountId, NewUsersDefinition newUsersDefinition) throws ApiException {
        NewUsersDefinition localVarPostBody = newUsersDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling create");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<NewUsersSummary> localVarReturnType = new GenericType<NewUsersSummary>(){};
        NewUsersSummary localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<NewUsersSummary>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserSignaturesInformation createSignatures(String accountId, String userId, UserSignaturesInformation userSignaturesInformation) throws ApiException {
        ApiResponse<UserSignaturesInformation> localVarResponse = this.createSignaturesWithHttpInfo(accountId, userId, userSignaturesInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<UserSignaturesInformation> createSignaturesWithHttpInfo(String accountId, String userId, UserSignaturesInformation userSignaturesInformation) throws ApiException {
        UserSignaturesInformation localVarPostBody = userSignaturesInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createSignatures");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling createSignatures");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/signatures".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignaturesInformation> localVarReturnType = new GenericType<UserSignaturesInformation>(){};
        UserSignaturesInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserSignaturesInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UsersResponse delete(String accountId, UserInfoList userInfoList) throws ApiException {
        return this.delete(accountId, userInfoList, null);
    }

    public UsersResponse delete(String accountId, UserInfoList userInfoList, DeleteOptions options) throws ApiException {
        ApiResponse<UsersResponse> localVarResponse = this.deleteWithHttpInfo(accountId, userInfoList, options);
        return localVarResponse.getData();
    }

    public ApiResponse<UsersResponse> deleteWithHttpInfo(String accountId, UserInfoList userInfoList, DeleteOptions options) throws ApiException {
        UserInfoList localVarPostBody = userInfoList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling delete");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("delete", options.delete));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UsersResponse> localVarReturnType = new GenericType<UsersResponse>(){};
        UsersResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UsersResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ContactUpdateResponse deleteContactWithId(String accountId, String contactId) throws ApiException {
        ApiResponse<ContactUpdateResponse> localVarResponse = this.deleteContactWithIdWithHttpInfo(accountId, contactId);
        return localVarResponse.getData();
    }

    public ApiResponse<ContactUpdateResponse> deleteContactWithIdWithHttpInfo(String accountId, String contactId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteContactWithId");
        }
        if (contactId == null) {
            throw new ApiException(400, "Missing the required parameter 'contactId' when calling deleteContactWithId");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/contacts/{contactId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{contactId\\}", this.apiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ContactUpdateResponse> localVarReturnType = new GenericType<ContactUpdateResponse>(){};
        ContactUpdateResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ContactUpdateResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ContactUpdateResponse deleteContacts(String accountId, ContactModRequest contactModRequest) throws ApiException {
        ApiResponse<ContactUpdateResponse> localVarResponse = this.deleteContactsWithHttpInfo(accountId, contactModRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ContactUpdateResponse> deleteContactsWithHttpInfo(String accountId, ContactModRequest contactModRequest) throws ApiException {
        ContactModRequest localVarPostBody = contactModRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteContacts");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/contacts".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ContactUpdateResponse> localVarReturnType = new GenericType<ContactUpdateResponse>(){};
        ContactUpdateResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ContactUpdateResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public CustomSettingsInformation deleteCustomSettings(String accountId, String userId, CustomSettingsInformation customSettingsInformation) throws ApiException {
        ApiResponse<CustomSettingsInformation> localVarResponse = this.deleteCustomSettingsWithHttpInfo(accountId, userId, customSettingsInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomSettingsInformation> deleteCustomSettingsWithHttpInfo(String accountId, String userId, CustomSettingsInformation customSettingsInformation) throws ApiException {
        CustomSettingsInformation localVarPostBody = customSettingsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteCustomSettings");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteCustomSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/custom_settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomSettingsInformation> localVarReturnType = new GenericType<CustomSettingsInformation>(){};
        CustomSettingsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CustomSettingsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void deleteProfileImage(String accountId, String userId) throws ApiException {
        this.deleteProfileImageWithHttpInfo(accountId, userId);
    }

    public ApiResponse<Object> deleteProfileImageWithHttpInfo(String accountId, String userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteProfileImage");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteProfileImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/profile/image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void deleteSignature(String accountId, String userId, String signatureId) throws ApiException {
        this.deleteSignatureWithHttpInfo(accountId, userId, signatureId);
    }

    public ApiResponse<Object> deleteSignatureWithHttpInfo(String accountId, String userId, String signatureId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteSignature");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteSignature");
        }
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling deleteSignature");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{signatureId\\}", this.apiClient.escapeString(signatureId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public UserSignature deleteSignatureImage(String accountId, String userId, String signatureId, String imageType) throws ApiException {
        ApiResponse<UserSignature> localVarResponse = this.deleteSignatureImageWithHttpInfo(accountId, userId, signatureId, imageType);
        return localVarResponse.getData();
    }

    public ApiResponse<UserSignature> deleteSignatureImageWithHttpInfo(String accountId, String userId, String signatureId, String imageType) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteSignatureImage");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteSignatureImage");
        }
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling deleteSignatureImage");
        }
        if (imageType == null) {
            throw new ApiException(400, "Missing the required parameter 'imageType' when calling deleteSignatureImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{signatureId\\}", this.apiClient.escapeString(signatureId.toString())).replaceAll("\\{imageType\\}", this.apiClient.escapeString(imageType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignature> localVarReturnType = new GenericType<UserSignature>(){};
        UserSignature localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserSignature>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ContactGetResponse getContactById(String accountId, String contactId) throws ApiException {
        return this.getContactById(accountId, contactId, null);
    }

    public ContactGetResponse getContactById(String accountId, String contactId, GetContactByIdOptions options) throws ApiException {
        ApiResponse<ContactGetResponse> localVarResponse = this.getContactByIdWithHttpInfo(accountId, contactId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ContactGetResponse> getContactByIdWithHttpInfo(String accountId, String contactId, GetContactByIdOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getContactById");
        }
        if (contactId == null) {
            throw new ApiException(400, "Missing the required parameter 'contactId' when calling getContactById");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/contacts/{contactId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{contactId\\}", this.apiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cloud_provider", options.cloudProvider));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ContactGetResponse> localVarReturnType = new GenericType<ContactGetResponse>(){};
        ContactGetResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ContactGetResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserInformation getInformation(String accountId, String userId) throws ApiException {
        return this.getInformation(accountId, userId, null);
    }

    public UserInformation getInformation(String accountId, String userId, GetInformationOptions options) throws ApiException {
        ApiResponse<UserInformation> localVarResponse = this.getInformationWithHttpInfo(accountId, userId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<UserInformation> getInformationWithHttpInfo(String accountId, String userId, GetInformationOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getInformation");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getInformation");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("additional_info", options.additionalInfo));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", options.email));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_license", options.includeLicense));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserInformation> localVarReturnType = new GenericType<UserInformation>(){};
        UserInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserProfile getProfile(String accountId, String userId) throws ApiException {
        ApiResponse<UserProfile> localVarResponse = this.getProfileWithHttpInfo(accountId, userId);
        return localVarResponse.getData();
    }

    public ApiResponse<UserProfile> getProfileWithHttpInfo(String accountId, String userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getProfile");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getProfile");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/profile".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserProfile> localVarReturnType = new GenericType<UserProfile>(){};
        UserProfile localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserProfile>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public byte[] getProfileImage(String accountId, String userId) throws ApiException {
        return this.getProfileImage(accountId, userId, null);
    }

    public byte[] getProfileImage(String accountId, String userId, GetProfileImageOptions options) throws ApiException {
        ApiResponse<byte[]> localVarResponse = this.getProfileImageWithHttpInfo(accountId, userId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<byte[]> getProfileImageWithHttpInfo(String accountId, String userId, GetProfileImageOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getProfileImage");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getProfileImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/profile/image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("encoding", options.encoding));
        }
        String[] localVarAccepts = new String[]{"image/gif"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        byte[] localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<byte[]>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserSettingsInformation getSettings(String accountId, String userId) throws ApiException {
        ApiResponse<UserSettingsInformation> localVarResponse = this.getSettingsWithHttpInfo(accountId, userId);
        return localVarResponse.getData();
    }

    public ApiResponse<UserSettingsInformation> getSettingsWithHttpInfo(String accountId, String userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getSettings");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSettingsInformation> localVarReturnType = new GenericType<UserSettingsInformation>(){};
        UserSettingsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserSettingsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserSignature getSignature(String accountId, String userId, String signatureId) throws ApiException {
        ApiResponse<UserSignature> localVarResponse = this.getSignatureWithHttpInfo(accountId, userId, signatureId);
        return localVarResponse.getData();
    }

    public ApiResponse<UserSignature> getSignatureWithHttpInfo(String accountId, String userId, String signatureId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getSignature");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getSignature");
        }
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling getSignature");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{signatureId\\}", this.apiClient.escapeString(signatureId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignature> localVarReturnType = new GenericType<UserSignature>(){};
        UserSignature localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserSignature>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public byte[] getSignatureImage(String accountId, String userId, String signatureId, String imageType) throws ApiException {
        return this.getSignatureImage(accountId, userId, signatureId, imageType, null);
    }

    public byte[] getSignatureImage(String accountId, String userId, String signatureId, String imageType, GetSignatureImageOptions options) throws ApiException {
        ApiResponse<byte[]> localVarResponse = this.getSignatureImageWithHttpInfo(accountId, userId, signatureId, imageType, options);
        return localVarResponse.getData();
    }

    public ApiResponse<byte[]> getSignatureImageWithHttpInfo(String accountId, String userId, String signatureId, String imageType, GetSignatureImageOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getSignatureImage");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getSignatureImage");
        }
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling getSignatureImage");
        }
        if (imageType == null) {
            throw new ApiException(400, "Missing the required parameter 'imageType' when calling getSignatureImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{signatureId\\}", this.apiClient.escapeString(signatureId.toString())).replaceAll("\\{imageType\\}", this.apiClient.escapeString(imageType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_chrome", options.includeChrome));
        }
        String[] localVarAccepts = new String[]{"image/gif"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        byte[] localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<byte[]>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public CustomSettingsInformation listCustomSettings(String accountId, String userId) throws ApiException {
        ApiResponse<CustomSettingsInformation> localVarResponse = this.listCustomSettingsWithHttpInfo(accountId, userId);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomSettingsInformation> listCustomSettingsWithHttpInfo(String accountId, String userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listCustomSettings");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listCustomSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/custom_settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomSettingsInformation> localVarReturnType = new GenericType<CustomSettingsInformation>(){};
        CustomSettingsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CustomSettingsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserSignaturesInformation listSignatures(String accountId, String userId) throws ApiException {
        return this.listSignatures(accountId, userId, null);
    }

    public UserSignaturesInformation listSignatures(String accountId, String userId, ListSignaturesOptions options) throws ApiException {
        ApiResponse<UserSignaturesInformation> localVarResponse = this.listSignaturesWithHttpInfo(accountId, userId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<UserSignaturesInformation> listSignaturesWithHttpInfo(String accountId, String userId, ListSignaturesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listSignatures");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSignatures");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/signatures".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("stamp_type", options.stampType));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignaturesInformation> localVarReturnType = new GenericType<UserSignaturesInformation>(){};
        UserSignaturesInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserSignaturesInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ContactUpdateResponse postContacts(String accountId, ContactModRequest contactModRequest) throws ApiException {
        ApiResponse<ContactUpdateResponse> localVarResponse = this.postContactsWithHttpInfo(accountId, contactModRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ContactUpdateResponse> postContactsWithHttpInfo(String accountId, ContactModRequest contactModRequest) throws ApiException {
        ContactModRequest localVarPostBody = contactModRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling postContacts");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/contacts".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ContactUpdateResponse> localVarReturnType = new GenericType<ContactUpdateResponse>(){};
        ContactUpdateResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ContactUpdateResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ContactUpdateResponse putContacts(String accountId, ContactModRequest contactModRequest) throws ApiException {
        ApiResponse<ContactUpdateResponse> localVarResponse = this.putContactsWithHttpInfo(accountId, contactModRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ContactUpdateResponse> putContactsWithHttpInfo(String accountId, ContactModRequest contactModRequest) throws ApiException {
        ContactModRequest localVarPostBody = contactModRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling putContacts");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/contacts".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ContactUpdateResponse> localVarReturnType = new GenericType<ContactUpdateResponse>(){};
        ContactUpdateResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ContactUpdateResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public CustomSettingsInformation updateCustomSettings(String accountId, String userId, CustomSettingsInformation customSettingsInformation) throws ApiException {
        ApiResponse<CustomSettingsInformation> localVarResponse = this.updateCustomSettingsWithHttpInfo(accountId, userId, customSettingsInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomSettingsInformation> updateCustomSettingsWithHttpInfo(String accountId, String userId, CustomSettingsInformation customSettingsInformation) throws ApiException {
        CustomSettingsInformation localVarPostBody = customSettingsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateCustomSettings");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateCustomSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/custom_settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomSettingsInformation> localVarReturnType = new GenericType<CustomSettingsInformation>(){};
        CustomSettingsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CustomSettingsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void updateProfile(String accountId, String userId, UserProfile userProfile) throws ApiException {
        this.updateProfileWithHttpInfo(accountId, userId, userProfile);
    }

    public ApiResponse<Object> updateProfileWithHttpInfo(String accountId, String userId, UserProfile userProfile) throws ApiException {
        UserProfile localVarPostBody = userProfile;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateProfile");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateProfile");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/profile".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void updateProfileImage(String accountId, String userId) throws ApiException {
        this.updateProfileImageWithHttpInfo(accountId, userId);
    }

    public ApiResponse<Object> updateProfileImageWithHttpInfo(String accountId, String userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateProfileImage");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateProfileImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/profile/image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"image/gif"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void updateSettings(String accountId, String userId, UserSettingsInformation userSettingsInformation) throws ApiException {
        this.updateSettings(accountId, userId, userSettingsInformation, null);
    }

    public void updateSettings(String accountId, String userId, UserSettingsInformation userSettingsInformation, UpdateSettingsOptions options) throws ApiException {
        this.updateSettingsWithHttpInfo(accountId, userId, userSettingsInformation, options);
    }

    public ApiResponse<Object> updateSettingsWithHttpInfo(String accountId, String userId, UserSettingsInformation userSettingsInformation, UpdateSettingsOptions options) throws ApiException {
        UserSettingsInformation localVarPostBody = userSettingsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateSettings");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("allow_all_languages", options.allowAllLanguages));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public UserSignature updateSignature(String accountId, String userId, String signatureId, UserSignatureDefinition userSignatureDefinition) throws ApiException {
        return this.updateSignature(accountId, userId, signatureId, userSignatureDefinition, null);
    }

    public UserSignature updateSignature(String accountId, String userId, String signatureId, UserSignatureDefinition userSignatureDefinition, UpdateSignatureOptions options) throws ApiException {
        ApiResponse<UserSignature> localVarResponse = this.updateSignatureWithHttpInfo(accountId, userId, signatureId, userSignatureDefinition, options);
        return localVarResponse.getData();
    }

    public ApiResponse<UserSignature> updateSignatureWithHttpInfo(String accountId, String userId, String signatureId, UserSignatureDefinition userSignatureDefinition, UpdateSignatureOptions options) throws ApiException {
        UserSignatureDefinition localVarPostBody = userSignatureDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateSignature");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateSignature");
        }
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling updateSignature");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{signatureId\\}", this.apiClient.escapeString(signatureId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("close_existing_signature", options.closeExistingSignature));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignature> localVarReturnType = new GenericType<UserSignature>(){};
        UserSignature localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserSignature>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserSignature updateSignatureImage(String accountId, String userId, String signatureId, String imageType, byte[] imageBytes) throws ApiException {
        return this.updateSignatureImage(accountId, userId, signatureId, imageType, imageBytes, null);
    }

    public UserSignature updateSignatureImage(String accountId, String userId, String signatureId, String imageType, byte[] imageBytes, UpdateSignatureImageOptions options) throws ApiException {
        ApiResponse<UserSignature> localVarResponse = this.updateSignatureImageWithHttpInfo(accountId, userId, signatureId, imageType, imageBytes, options);
        return localVarResponse.getData();
    }

    public ApiResponse<UserSignature> updateSignatureImageWithHttpInfo(String accountId, String userId, String signatureId, String imageType, byte[] imageBytes, UpdateSignatureImageOptions options) throws ApiException {
        byte[] localVarPostBody = imageBytes;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateSignatureImage");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateSignatureImage");
        }
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling updateSignatureImage");
        }
        if (imageType == null) {
            throw new ApiException(400, "Missing the required parameter 'imageType' when calling updateSignatureImage");
        }
        if (imageBytes == null) {
            throw new ApiException(400, "Missing the required parameter 'imageBytes' when calling updateSignatureImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{signatureId\\}", this.apiClient.escapeString(signatureId.toString())).replaceAll("\\{imageType\\}", this.apiClient.escapeString(imageType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("transparent_png", options.transparentPng));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"image/gif"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignature> localVarReturnType = new GenericType<UserSignature>(){};
        UserSignature localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserSignature>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserSignaturesInformation updateSignatures(String accountId, String userId, UserSignaturesInformation userSignaturesInformation) throws ApiException {
        ApiResponse<UserSignaturesInformation> localVarResponse = this.updateSignaturesWithHttpInfo(accountId, userId, userSignaturesInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<UserSignaturesInformation> updateSignaturesWithHttpInfo(String accountId, String userId, UserSignaturesInformation userSignaturesInformation) throws ApiException {
        UserSignaturesInformation localVarPostBody = userSignaturesInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateSignatures");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateSignatures");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}/signatures".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignaturesInformation> localVarReturnType = new GenericType<UserSignaturesInformation>(){};
        UserSignaturesInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserSignaturesInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserInformation updateUser(String accountId, String userId, UserInformation userInformation) throws ApiException {
        return this.updateUser(accountId, userId, userInformation, null);
    }

    public UserInformation updateUser(String accountId, String userId, UserInformation userInformation, UpdateUserOptions options) throws ApiException {
        ApiResponse<UserInformation> localVarResponse = this.updateUserWithHttpInfo(accountId, userId, userInformation, options);
        return localVarResponse.getData();
    }

    public ApiResponse<UserInformation> updateUserWithHttpInfo(String accountId, String userId, UserInformation userInformation, UpdateUserOptions options) throws ApiException {
        UserInformation localVarPostBody = userInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateUser");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users/{userId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("allow_all_languages", options.allowAllLanguages));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserInformation> localVarReturnType = new GenericType<UserInformation>(){};
        UserInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserInformationList updateUsers(String accountId, UserInformationList userInformationList) throws ApiException {
        return this.updateUsers(accountId, userInformationList, null);
    }

    public UserInformationList updateUsers(String accountId, UserInformationList userInformationList, UpdateUsersOptions options) throws ApiException {
        ApiResponse<UserInformationList> localVarResponse = this.updateUsersWithHttpInfo(accountId, userInformationList, options);
        return localVarResponse.getData();
    }

    public ApiResponse<UserInformationList> updateUsersWithHttpInfo(String accountId, UserInformationList userInformationList, UpdateUsersOptions options) throws ApiException {
        UserInformationList localVarPostBody = userInformationList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateUsers");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("allow_all_languages", options.allowAllLanguages));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserInformationList> localVarReturnType = new GenericType<UserInformationList>(){};
        UserInformationList localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserInformationList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class UpdateUsersOptions {
        private String allowAllLanguages = null;

        public void setAllowAllLanguages(String allowAllLanguages) {
            this.allowAllLanguages = allowAllLanguages;
        }

        public String getAllowAllLanguages() {
            return this.allowAllLanguages;
        }
    }

    public class UpdateUserOptions {
        private String allowAllLanguages = null;

        public void setAllowAllLanguages(String allowAllLanguages) {
            this.allowAllLanguages = allowAllLanguages;
        }

        public String getAllowAllLanguages() {
            return this.allowAllLanguages;
        }
    }

    public class UpdateSignatureImageOptions {
        private String transparentPng = null;

        public void setTransparentPng(String transparentPng) {
            this.transparentPng = transparentPng;
        }

        public String getTransparentPng() {
            return this.transparentPng;
        }
    }

    public class UpdateSignatureOptions {
        private String closeExistingSignature = null;

        public void setCloseExistingSignature(String closeExistingSignature) {
            this.closeExistingSignature = closeExistingSignature;
        }

        public String getCloseExistingSignature() {
            return this.closeExistingSignature;
        }
    }

    public class UpdateSettingsOptions {
        private String allowAllLanguages = null;

        public void setAllowAllLanguages(String allowAllLanguages) {
            this.allowAllLanguages = allowAllLanguages;
        }

        public String getAllowAllLanguages() {
            return this.allowAllLanguages;
        }
    }

    public class ListSignaturesOptions {
        private String stampType = null;

        public void setStampType(String stampType) {
            this.stampType = stampType;
        }

        public String getStampType() {
            return this.stampType;
        }
    }

    public class GetSignatureImageOptions {
        private String includeChrome = null;

        public void setIncludeChrome(String includeChrome) {
            this.includeChrome = includeChrome;
        }

        public String getIncludeChrome() {
            return this.includeChrome;
        }
    }

    public class GetProfileImageOptions {
        private String encoding = null;

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }

    public class GetInformationOptions {
        private String additionalInfo = null;
        private String email = null;
        private String includeLicense = null;

        public void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public String getAdditionalInfo() {
            return this.additionalInfo;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public void setIncludeLicense(String includeLicense) {
            this.includeLicense = includeLicense;
        }

        public String getIncludeLicense() {
            return this.includeLicense;
        }
    }

    public class GetContactByIdOptions {
        private String cloudProvider = null;

        public void setCloudProvider(String cloudProvider) {
            this.cloudProvider = cloudProvider;
        }

        public String getCloudProvider() {
            return this.cloudProvider;
        }
    }

    public class DeleteOptions {
        private String delete = null;

        public void setDelete(String delete) {
            this.delete = delete;
        }

        public String getDelete() {
            return this.delete;
        }
    }

    public class CallListOptions {
        private String additionalInfo = null;
        private String alternateAdminsOnly = null;
        private String count = null;
        private String domainUsersOnly = null;
        private String email = null;
        private String emailSubstring = null;
        private String groupId = null;
        private String includeLicense = null;
        private String includeUsersettingsForCsv = null;
        private String loginStatus = null;
        private String notGroupId = null;
        private String startPosition = null;
        private String status = null;
        private String userNameSubstring = null;

        public void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public String getAdditionalInfo() {
            return this.additionalInfo;
        }

        public void setAlternateAdminsOnly(String alternateAdminsOnly) {
            this.alternateAdminsOnly = alternateAdminsOnly;
        }

        public String getAlternateAdminsOnly() {
            return this.alternateAdminsOnly;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setDomainUsersOnly(String domainUsersOnly) {
            this.domainUsersOnly = domainUsersOnly;
        }

        public String getDomainUsersOnly() {
            return this.domainUsersOnly;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmailSubstring(String emailSubstring) {
            this.emailSubstring = emailSubstring;
        }

        public String getEmailSubstring() {
            return this.emailSubstring;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setIncludeLicense(String includeLicense) {
            this.includeLicense = includeLicense;
        }

        public String getIncludeLicense() {
            return this.includeLicense;
        }

        public void setIncludeUsersettingsForCsv(String includeUsersettingsForCsv) {
            this.includeUsersettingsForCsv = includeUsersettingsForCsv;
        }

        public String getIncludeUsersettingsForCsv() {
            return this.includeUsersettingsForCsv;
        }

        public void setLoginStatus(String loginStatus) {
            this.loginStatus = loginStatus;
        }

        public String getLoginStatus() {
            return this.loginStatus;
        }

        public void setNotGroupId(String notGroupId) {
            this.notGroupId = notGroupId;
        }

        public String getNotGroupId() {
            return this.notGroupId;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setUserNameSubstring(String userNameSubstring) {
            this.userNameSubstring = userNameSubstring;
        }

        public String getUserNameSubstring() {
            return this.userNameSubstring;
        }
    }
}

