/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.PropertyMetadata;
import com.docusign.esign.model.RecipientIdentityInputOption;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Specifies ID Verification applied on an envelope by workflow ID. See the [list](/docs/esign-rest-api/reference/accounts/identityverifications/list/) method in the [IdentityVerifications](/docs/esign-rest-api/reference/accounts/identityverifications/) resource for more information on how to retrieve workflow IDs available for an account. This can be used in addition to other [recipient authentication](https://support.docusign.com/en/guides/ndse-user-guide-recipient-authentication) methods.")
public class RecipientIdentityVerification {
    @JsonProperty(value="inputOptions")
    private List<RecipientIdentityInputOption> inputOptions = null;
    @JsonProperty(value="workflowId")
    private String workflowId = null;
    @JsonProperty(value="workflowIdMetadata")
    private PropertyMetadata workflowIdMetadata = null;
    @JsonProperty(value="workflowLabel")
    private String workflowLabel = null;

    public RecipientIdentityVerification inputOptions(List<RecipientIdentityInputOption> inputOptions) {
        this.inputOptions = inputOptions;
        return this;
    }

    public RecipientIdentityVerification addInputOptionsItem(RecipientIdentityInputOption inputOptionsItem) {
        if (this.inputOptions == null) {
            this.inputOptions = new ArrayList<RecipientIdentityInputOption>();
        }
        this.inputOptions.add(inputOptionsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<RecipientIdentityInputOption> getInputOptions() {
        return this.inputOptions;
    }

    public void setInputOptions(List<RecipientIdentityInputOption> inputOptions) {
        this.inputOptions = inputOptions;
    }

    public RecipientIdentityVerification workflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public RecipientIdentityVerification workflowIdMetadata(PropertyMetadata workflowIdMetadata) {
        this.workflowIdMetadata = workflowIdMetadata;
        return this;
    }

    @ApiModelProperty(value="")
    public PropertyMetadata getWorkflowIdMetadata() {
        return this.workflowIdMetadata;
    }

    public void setWorkflowIdMetadata(PropertyMetadata workflowIdMetadata) {
        this.workflowIdMetadata = workflowIdMetadata;
    }

    public RecipientIdentityVerification workflowLabel(String workflowLabel) {
        this.workflowLabel = workflowLabel;
        return this;
    }

    @ApiModelProperty(value="")
    public String getWorkflowLabel() {
        return this.workflowLabel;
    }

    public void setWorkflowLabel(String workflowLabel) {
        this.workflowLabel = workflowLabel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipientIdentityVerification recipientIdentityVerification = (RecipientIdentityVerification)o;
        return Objects.equals(this.inputOptions, recipientIdentityVerification.inputOptions) && Objects.equals(this.workflowId, recipientIdentityVerification.workflowId) && Objects.equals(this.workflowIdMetadata, recipientIdentityVerification.workflowIdMetadata) && Objects.equals(this.workflowLabel, recipientIdentityVerification.workflowLabel);
    }

    public int hashCode() {
        return Objects.hash(this.inputOptions, this.workflowId, this.workflowIdMetadata, this.workflowLabel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecipientIdentityVerification {\n");
        sb.append("    inputOptions: ").append(this.toIndentedString(this.inputOptions)).append("\n");
        sb.append("    workflowId: ").append(this.toIndentedString(this.workflowId)).append("\n");
        sb.append("    workflowIdMetadata: ").append(this.toIndentedString(this.workflowIdMetadata)).append("\n");
        sb.append("    workflowLabel: ").append(this.toIndentedString(this.workflowLabel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

