/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.BrandEmailContent;
import com.docusign.esign.model.BrandLink;
import com.docusign.esign.model.BrandLogos;
import com.docusign.esign.model.BrandResourceUrls;
import com.docusign.esign.model.ErrorDetails;
import com.docusign.esign.model.NameValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Information about a brand that is associated with an account. A brand applies custom styles and text to an envelope.")
public class Brand {
    @JsonProperty(value="brandCompany")
    private String brandCompany = null;
    @JsonProperty(value="brandId")
    private String brandId = null;
    @JsonProperty(value="brandLanguages")
    private List<String> brandLanguages = null;
    @JsonProperty(value="brandName")
    private String brandName = null;
    @JsonProperty(value="colors")
    private List<NameValue> colors = null;
    @JsonProperty(value="defaultBrandLanguage")
    private String defaultBrandLanguage = null;
    @JsonProperty(value="emailContent")
    private List<BrandEmailContent> emailContent = null;
    @JsonProperty(value="errorDetails")
    private ErrorDetails errorDetails = null;
    @JsonProperty(value="isOverridingCompanyName")
    private Boolean isOverridingCompanyName = null;
    @JsonProperty(value="isSendingDefault")
    private Boolean isSendingDefault = null;
    @JsonProperty(value="isSigningDefault")
    private Boolean isSigningDefault = null;
    @JsonProperty(value="landingPages")
    private List<NameValue> landingPages = null;
    @JsonProperty(value="links")
    private List<BrandLink> links = null;
    @JsonProperty(value="logos")
    private BrandLogos logos = null;
    @JsonProperty(value="resources")
    private BrandResourceUrls resources = null;

    public Brand brandCompany(String brandCompany) {
        this.brandCompany = brandCompany;
        return this;
    }

    @ApiModelProperty(value="The name of the company associated with this brand.")
    public String getBrandCompany() {
        return this.brandCompany;
    }

    public void setBrandCompany(String brandCompany) {
        this.brandCompany = brandCompany;
    }

    public Brand brandId(String brandId) {
        this.brandId = brandId;
        return this;
    }

    @ApiModelProperty(value="The ID used to identify a specific brand in API calls.")
    public String getBrandId() {
        return this.brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public Brand brandLanguages(List<String> brandLanguages) {
        this.brandLanguages = brandLanguages;
        return this;
    }

    public Brand addBrandLanguagesItem(String brandLanguagesItem) {
        if (this.brandLanguages == null) {
            this.brandLanguages = new ArrayList<String>();
        }
        this.brandLanguages.add(brandLanguagesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getBrandLanguages() {
        return this.brandLanguages;
    }

    public void setBrandLanguages(List<String> brandLanguages) {
        this.brandLanguages = brandLanguages;
    }

    public Brand brandName(String brandName) {
        this.brandName = brandName;
        return this;
    }

    @ApiModelProperty(value="The name of the brand.")
    public String getBrandName() {
        return this.brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Brand colors(List<NameValue> colors) {
        this.colors = colors;
        return this;
    }

    public Brand addColorsItem(NameValue colorsItem) {
        if (this.colors == null) {
            this.colors = new ArrayList<NameValue>();
        }
        this.colors.add(colorsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<NameValue> getColors() {
        return this.colors;
    }

    public void setColors(List<NameValue> colors) {
        this.colors = colors;
    }

    public Brand defaultBrandLanguage(String defaultBrandLanguage) {
        this.defaultBrandLanguage = defaultBrandLanguage;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDefaultBrandLanguage() {
        return this.defaultBrandLanguage;
    }

    public void setDefaultBrandLanguage(String defaultBrandLanguage) {
        this.defaultBrandLanguage = defaultBrandLanguage;
    }

    public Brand emailContent(List<BrandEmailContent> emailContent) {
        this.emailContent = emailContent;
        return this;
    }

    public Brand addEmailContentItem(BrandEmailContent emailContentItem) {
        if (this.emailContent == null) {
            this.emailContent = new ArrayList<BrandEmailContent>();
        }
        this.emailContent.add(emailContentItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<BrandEmailContent> getEmailContent() {
        return this.emailContent;
    }

    public void setEmailContent(List<BrandEmailContent> emailContent) {
        this.emailContent = emailContent;
    }

    public Brand errorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @ApiModelProperty(value="This object describes errors that occur. It is only valid for responses and ignored in requests.")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public Brand isOverridingCompanyName(Boolean isOverridingCompanyName) {
        this.isOverridingCompanyName = isOverridingCompanyName;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isIsOverridingCompanyName() {
        return this.isOverridingCompanyName;
    }

    public void setIsOverridingCompanyName(Boolean isOverridingCompanyName) {
        this.isOverridingCompanyName = isOverridingCompanyName;
    }

    public Brand isSendingDefault(Boolean isSendingDefault) {
        this.isSendingDefault = isSendingDefault;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isIsSendingDefault() {
        return this.isSendingDefault;
    }

    public void setIsSendingDefault(Boolean isSendingDefault) {
        this.isSendingDefault = isSendingDefault;
    }

    public Brand isSigningDefault(Boolean isSigningDefault) {
        this.isSigningDefault = isSigningDefault;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isIsSigningDefault() {
        return this.isSigningDefault;
    }

    public void setIsSigningDefault(Boolean isSigningDefault) {
        this.isSigningDefault = isSigningDefault;
    }

    public Brand landingPages(List<NameValue> landingPages) {
        this.landingPages = landingPages;
        return this;
    }

    public Brand addLandingPagesItem(NameValue landingPagesItem) {
        if (this.landingPages == null) {
            this.landingPages = new ArrayList<NameValue>();
        }
        this.landingPages.add(landingPagesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<NameValue> getLandingPages() {
        return this.landingPages;
    }

    public void setLandingPages(List<NameValue> landingPages) {
        this.landingPages = landingPages;
    }

    public Brand links(List<BrandLink> links) {
        this.links = links;
        return this;
    }

    public Brand addLinksItem(BrandLink linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<BrandLink>();
        }
        this.links.add(linksItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<BrandLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<BrandLink> links) {
        this.links = links;
    }

    public Brand logos(BrandLogos logos) {
        this.logos = logos;
        return this;
    }

    @ApiModelProperty(value="The URIs for retrieving the logos that are associated with the brand.")
    public BrandLogos getLogos() {
        return this.logos;
    }

    public void setLogos(BrandLogos logos) {
        this.logos = logos;
    }

    public Brand resources(BrandResourceUrls resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(value="An object containing the URLs for the four DocuSign master resource files that the brand uses for sending, signing, email messages, and captive (embedded) signing. You can modify the default email messages and formats in these file to customize the user experience.  **Note:** This object is returned only when the `resourceContentType` is `sending`, `signing`, `email`, or `signing_captive`.")
    public BrandResourceUrls getResources() {
        return this.resources;
    }

    public void setResources(BrandResourceUrls resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Brand brand = (Brand)o;
        return Objects.equals(this.brandCompany, brand.brandCompany) && Objects.equals(this.brandId, brand.brandId) && Objects.equals(this.brandLanguages, brand.brandLanguages) && Objects.equals(this.brandName, brand.brandName) && Objects.equals(this.colors, brand.colors) && Objects.equals(this.defaultBrandLanguage, brand.defaultBrandLanguage) && Objects.equals(this.emailContent, brand.emailContent) && Objects.equals(this.errorDetails, brand.errorDetails) && Objects.equals(this.isOverridingCompanyName, brand.isOverridingCompanyName) && Objects.equals(this.isSendingDefault, brand.isSendingDefault) && Objects.equals(this.isSigningDefault, brand.isSigningDefault) && Objects.equals(this.landingPages, brand.landingPages) && Objects.equals(this.links, brand.links) && Objects.equals(this.logos, brand.logos) && Objects.equals(this.resources, brand.resources);
    }

    public int hashCode() {
        return Objects.hash(this.brandCompany, this.brandId, this.brandLanguages, this.brandName, this.colors, this.defaultBrandLanguage, this.emailContent, this.errorDetails, this.isOverridingCompanyName, this.isSendingDefault, this.isSigningDefault, this.landingPages, this.links, this.logos, this.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Brand {\n");
        sb.append("    brandCompany: ").append(this.toIndentedString(this.brandCompany)).append("\n");
        sb.append("    brandId: ").append(this.toIndentedString(this.brandId)).append("\n");
        sb.append("    brandLanguages: ").append(this.toIndentedString(this.brandLanguages)).append("\n");
        sb.append("    brandName: ").append(this.toIndentedString(this.brandName)).append("\n");
        sb.append("    colors: ").append(this.toIndentedString(this.colors)).append("\n");
        sb.append("    defaultBrandLanguage: ").append(this.toIndentedString(this.defaultBrandLanguage)).append("\n");
        sb.append("    emailContent: ").append(this.toIndentedString(this.emailContent)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    isOverridingCompanyName: ").append(this.toIndentedString(this.isOverridingCompanyName)).append("\n");
        sb.append("    isSendingDefault: ").append(this.toIndentedString(this.isSendingDefault)).append("\n");
        sb.append("    isSigningDefault: ").append(this.toIndentedString(this.isSigningDefault)).append("\n");
        sb.append("    landingPages: ").append(this.toIndentedString(this.landingPages)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    logos: ").append(this.toIndentedString(this.logos)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

