/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.ApiResponse;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.FolderItemResponse;
import com.docusign.esign.model.FolderItemsResponse;
import com.docusign.esign.model.FoldersRequest;
import com.docusign.esign.model.FoldersResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class FoldersApi {
    private ApiClient apiClient;

    public FoldersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FoldersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FoldersResponse callList(String accountId) throws ApiException {
        return this.callList(accountId, null);
    }

    public FoldersResponse callList(String accountId, CallListOptions options) throws ApiException {
        ApiResponse<FoldersResponse> localVarResponse = this.callListWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<FoldersResponse> callListWithHttpInfo(String accountId, CallListOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling callList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/folders".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_items", options.includeItems));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sub_folder_depth", options.subFolderDepth));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("template", options.template));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_filter", options.userFilter));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FoldersResponse> localVarReturnType = new GenericType<FoldersResponse>(){};
        FoldersResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FoldersResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public FolderItemsResponse listItems(String accountId, String folderId) throws ApiException {
        return this.listItems(accountId, folderId, null);
    }

    public FolderItemsResponse listItems(String accountId, String folderId, ListItemsOptions options) throws ApiException {
        ApiResponse<FolderItemsResponse> localVarResponse = this.listItemsWithHttpInfo(accountId, folderId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<FolderItemsResponse> listItemsWithHttpInfo(String accountId, String folderId, ListItemsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listItems");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling listItems");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/folders/{folderId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_items", options.includeItems));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("owner_email", options.ownerEmail));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("owner_name", options.ownerName));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search_text", options.searchText));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FolderItemsResponse> localVarReturnType = new GenericType<FolderItemsResponse>(){};
        FolderItemsResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FolderItemsResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public FoldersResponse moveEnvelopes(String accountId, String folderId, FoldersRequest foldersRequest) throws ApiException {
        ApiResponse<FoldersResponse> localVarResponse = this.moveEnvelopesWithHttpInfo(accountId, folderId, foldersRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<FoldersResponse> moveEnvelopesWithHttpInfo(String accountId, String folderId, FoldersRequest foldersRequest) throws ApiException {
        FoldersRequest localVarPostBody = foldersRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling moveEnvelopes");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling moveEnvelopes");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/folders/{folderId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FoldersResponse> localVarReturnType = new GenericType<FoldersResponse>(){};
        FoldersResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FoldersResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public FolderItemResponse search(String accountId, String searchFolderId) throws ApiException {
        return this.search(accountId, searchFolderId, null);
    }

    public FolderItemResponse search(String accountId, String searchFolderId, SearchOptions options) throws ApiException {
        ApiResponse<FolderItemResponse> localVarResponse = this.searchWithHttpInfo(accountId, searchFolderId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<FolderItemResponse> searchWithHttpInfo(String accountId, String searchFolderId, SearchOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling search");
        }
        if (searchFolderId == null) {
            throw new ApiException(400, "Missing the required parameter 'searchFolderId' when calling search");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/search_folders/{searchFolderId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{searchFolderId\\}", this.apiClient.escapeString(searchFolderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("all", options.all));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_recipients", options.includeRecipients));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order", options.order));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order_by", options.orderBy));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FolderItemResponse> localVarReturnType = new GenericType<FolderItemResponse>(){};
        FolderItemResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FolderItemResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class SearchOptions {
        private String all = null;
        private String count = null;
        private String fromDate = null;
        private String includeRecipients = null;
        private String order = null;
        private String orderBy = null;
        private String startPosition = null;
        private String toDate = null;

        public void setAll(String all) {
            this.all = all;
        }

        public String getAll() {
            return this.all;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setIncludeRecipients(String includeRecipients) {
            this.includeRecipients = includeRecipients;
        }

        public String getIncludeRecipients() {
            return this.includeRecipients;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class ListItemsOptions {
        private String fromDate = null;
        private String includeItems = null;
        private String ownerEmail = null;
        private String ownerName = null;
        private String searchText = null;
        private String startPosition = null;
        private String status = null;
        private String toDate = null;

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setIncludeItems(String includeItems) {
            this.includeItems = includeItems;
        }

        public String getIncludeItems() {
            return this.includeItems;
        }

        public void setOwnerEmail(String ownerEmail) {
            this.ownerEmail = ownerEmail;
        }

        public String getOwnerEmail() {
            return this.ownerEmail;
        }

        public void setOwnerName(String ownerName) {
            this.ownerName = ownerName;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class CallListOptions {
        private String count = null;
        private String include = null;
        private String includeItems = null;
        private String startPosition = null;
        private String subFolderDepth = null;
        private String template = null;
        private String userFilter = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }

        public void setIncludeItems(String includeItems) {
            this.includeItems = includeItems;
        }

        public String getIncludeItems() {
            return this.includeItems;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setSubFolderDepth(String subFolderDepth) {
            this.subFolderDepth = subFolderDepth;
        }

        public String getSubFolderDepth() {
            return this.subFolderDepth;
        }

        public void setTemplate(String template) {
            this.template = template;
        }

        public String getTemplate() {
            return this.template;
        }

        public void setUserFilter(String userFilter) {
            this.userFilter = userFilter;
        }

        public String getUserFilter() {
            return this.userFilter;
        }
    }
}

