/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.ApiResponse;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.ConnectConfigResults;
import com.docusign.esign.model.ConnectCustomConfiguration;
import com.docusign.esign.model.ConnectDeleteFailureResult;
import com.docusign.esign.model.ConnectFailureFilter;
import com.docusign.esign.model.ConnectFailureResults;
import com.docusign.esign.model.ConnectLog;
import com.docusign.esign.model.ConnectLogs;
import com.docusign.esign.model.ConnectOAuthConfig;
import com.docusign.esign.model.IntegratedConnectUserInfoList;
import com.docusign.esign.model.IntegratedUserInfoList;
import com.docusign.esign.model.MobileNotifierConfigurationInformation;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class ConnectApi {
    private ApiClient apiClient;

    public ConnectApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ConnectApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ConnectCustomConfiguration createConfiguration(String accountId, ConnectCustomConfiguration connectCustomConfiguration) throws ApiException {
        ApiResponse<ConnectCustomConfiguration> localVarResponse = this.createConfigurationWithHttpInfo(accountId, connectCustomConfiguration);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectCustomConfiguration> createConfigurationWithHttpInfo(String accountId, ConnectCustomConfiguration connectCustomConfiguration) throws ApiException {
        ConnectCustomConfiguration localVarPostBody = connectCustomConfiguration;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createConfiguration");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectCustomConfiguration> localVarReturnType = new GenericType<ConnectCustomConfiguration>(){};
        ConnectCustomConfiguration localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectCustomConfiguration>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConnectOAuthConfig createConnectOAuthConfig(String accountId, ConnectOAuthConfig connectOAuthConfig) throws ApiException {
        ApiResponse<ConnectOAuthConfig> localVarResponse = this.createConnectOAuthConfigWithHttpInfo(accountId, connectOAuthConfig);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectOAuthConfig> createConnectOAuthConfigWithHttpInfo(String accountId, ConnectOAuthConfig connectOAuthConfig) throws ApiException {
        ConnectOAuthConfig localVarPostBody = connectOAuthConfig;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createConnectOAuthConfig");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/oauth".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectOAuthConfig> localVarReturnType = new GenericType<ConnectOAuthConfig>(){};
        ConnectOAuthConfig localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectOAuthConfig>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void deleteConfiguration(String accountId, String connectId) throws ApiException {
        this.deleteConfigurationWithHttpInfo(accountId, connectId);
    }

    public ApiResponse<Object> deleteConfigurationWithHttpInfo(String accountId, String connectId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteConfiguration");
        }
        if (connectId == null) {
            throw new ApiException(400, "Missing the required parameter 'connectId' when calling deleteConfiguration");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/{connectId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{connectId\\}", this.apiClient.escapeString(connectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void deleteConnectOAuthConfig(String accountId) throws ApiException {
        this.deleteConnectOAuthConfigWithHttpInfo(accountId);
    }

    public ApiResponse<Object> deleteConnectOAuthConfigWithHttpInfo(String accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteConnectOAuthConfig");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/oauth".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public ConnectDeleteFailureResult deleteEventFailureLog(String accountId, String failureId) throws ApiException {
        ApiResponse<ConnectDeleteFailureResult> localVarResponse = this.deleteEventFailureLogWithHttpInfo(accountId, failureId);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectDeleteFailureResult> deleteEventFailureLogWithHttpInfo(String accountId, String failureId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEventFailureLog");
        }
        if (failureId == null) {
            throw new ApiException(400, "Missing the required parameter 'failureId' when calling deleteEventFailureLog");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/failures/{failureId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{failureId\\}", this.apiClient.escapeString(failureId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectDeleteFailureResult> localVarReturnType = new GenericType<ConnectDeleteFailureResult>(){};
        ConnectDeleteFailureResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectDeleteFailureResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void deleteEventLog(String accountId, String logId) throws ApiException {
        this.deleteEventLogWithHttpInfo(accountId, logId);
    }

    public ApiResponse<Object> deleteEventLogWithHttpInfo(String accountId, String logId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEventLog");
        }
        if (logId == null) {
            throw new ApiException(400, "Missing the required parameter 'logId' when calling deleteEventLog");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/logs/{logId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{logId\\}", this.apiClient.escapeString(logId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void deleteEventLogs(String accountId) throws ApiException {
        this.deleteEventLogsWithHttpInfo(accountId);
    }

    public ApiResponse<Object> deleteEventLogsWithHttpInfo(String accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEventLogs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/logs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public MobileNotifierConfigurationInformation deleteMobileNotifiers(String accountId, MobileNotifierConfigurationInformation mobileNotifierConfigurationInformation) throws ApiException {
        ApiResponse<MobileNotifierConfigurationInformation> localVarResponse = this.deleteMobileNotifiersWithHttpInfo(accountId, mobileNotifierConfigurationInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<MobileNotifierConfigurationInformation> deleteMobileNotifiersWithHttpInfo(String accountId, MobileNotifierConfigurationInformation mobileNotifierConfigurationInformation) throws ApiException {
        MobileNotifierConfigurationInformation localVarPostBody = mobileNotifierConfigurationInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteMobileNotifiers");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/mobile_notifiers".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<MobileNotifierConfigurationInformation> localVarReturnType = new GenericType<MobileNotifierConfigurationInformation>(){};
        MobileNotifierConfigurationInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<MobileNotifierConfigurationInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConnectConfigResults getConfiguration(String accountId, String connectId) throws ApiException {
        ApiResponse<ConnectConfigResults> localVarResponse = this.getConfigurationWithHttpInfo(accountId, connectId);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectConfigResults> getConfigurationWithHttpInfo(String accountId, String connectId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConfiguration");
        }
        if (connectId == null) {
            throw new ApiException(400, "Missing the required parameter 'connectId' when calling getConfiguration");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/{connectId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{connectId\\}", this.apiClient.escapeString(connectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectConfigResults> localVarReturnType = new GenericType<ConnectConfigResults>(){};
        ConnectConfigResults localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectConfigResults>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public IntegratedConnectUserInfoList getConnectAllUsers(String accountId, String connectId) throws ApiException {
        return this.getConnectAllUsers(accountId, connectId, null);
    }

    public IntegratedConnectUserInfoList getConnectAllUsers(String accountId, String connectId, GetConnectAllUsersOptions options) throws ApiException {
        ApiResponse<IntegratedConnectUserInfoList> localVarResponse = this.getConnectAllUsersWithHttpInfo(accountId, connectId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<IntegratedConnectUserInfoList> getConnectAllUsersWithHttpInfo(String accountId, String connectId, GetConnectAllUsersOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConnectAllUsers");
        }
        if (connectId == null) {
            throw new ApiException(400, "Missing the required parameter 'connectId' when calling getConnectAllUsers");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/{connectId}/all/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{connectId\\}", this.apiClient.escapeString(connectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("domain_users_only", options.domainUsersOnly));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email_substring", options.emailSubstring));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_name_substring", options.userNameSubstring));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<IntegratedConnectUserInfoList> localVarReturnType = new GenericType<IntegratedConnectUserInfoList>(){};
        IntegratedConnectUserInfoList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<IntegratedConnectUserInfoList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConnectOAuthConfig getConnectOAuthConfig(String accountId) throws ApiException {
        ApiResponse<ConnectOAuthConfig> localVarResponse = this.getConnectOAuthConfigWithHttpInfo(accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectOAuthConfig> getConnectOAuthConfigWithHttpInfo(String accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConnectOAuthConfig");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/oauth".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectOAuthConfig> localVarReturnType = new GenericType<ConnectOAuthConfig>(){};
        ConnectOAuthConfig localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectOAuthConfig>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConnectLog getEventLog(String accountId, String logId) throws ApiException {
        return this.getEventLog(accountId, logId, null);
    }

    public ConnectLog getEventLog(String accountId, String logId, GetEventLogOptions options) throws ApiException {
        ApiResponse<ConnectLog> localVarResponse = this.getEventLogWithHttpInfo(accountId, logId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectLog> getEventLogWithHttpInfo(String accountId, String logId, GetEventLogOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEventLog");
        }
        if (logId == null) {
            throw new ApiException(400, "Missing the required parameter 'logId' when calling getEventLog");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/logs/{logId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{logId\\}", this.apiClient.escapeString(logId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("additional_info", options.additionalInfo));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectLog> localVarReturnType = new GenericType<ConnectLog>(){};
        ConnectLog localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectLog>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConnectConfigResults listConfigurations(String accountId) throws ApiException {
        ApiResponse<ConnectConfigResults> localVarResponse = this.listConfigurationsWithHttpInfo(accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectConfigResults> listConfigurationsWithHttpInfo(String accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listConfigurations");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectConfigResults> localVarReturnType = new GenericType<ConnectConfigResults>(){};
        ConnectConfigResults localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectConfigResults>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConnectLogs listEventFailureLogs(String accountId) throws ApiException {
        return this.listEventFailureLogs(accountId, null);
    }

    public ConnectLogs listEventFailureLogs(String accountId, ListEventFailureLogsOptions options) throws ApiException {
        ApiResponse<ConnectLogs> localVarResponse = this.listEventFailureLogsWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectLogs> listEventFailureLogsWithHttpInfo(String accountId, ListEventFailureLogsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listEventFailureLogs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/failures".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectLogs> localVarReturnType = new GenericType<ConnectLogs>(){};
        ConnectLogs localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectLogs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConnectLogs listEventLogs(String accountId) throws ApiException {
        return this.listEventLogs(accountId, null);
    }

    public ConnectLogs listEventLogs(String accountId, ListEventLogsOptions options) throws ApiException {
        ApiResponse<ConnectLogs> localVarResponse = this.listEventLogsWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectLogs> listEventLogsWithHttpInfo(String accountId, ListEventLogsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listEventLogs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/logs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectLogs> localVarReturnType = new GenericType<ConnectLogs>(){};
        ConnectLogs localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectLogs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public MobileNotifierConfigurationInformation listMobileNotifiers(String accountId) throws ApiException {
        ApiResponse<MobileNotifierConfigurationInformation> localVarResponse = this.listMobileNotifiersWithHttpInfo(accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<MobileNotifierConfigurationInformation> listMobileNotifiersWithHttpInfo(String accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listMobileNotifiers");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/mobile_notifiers".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<MobileNotifierConfigurationInformation> localVarReturnType = new GenericType<MobileNotifierConfigurationInformation>(){};
        MobileNotifierConfigurationInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<MobileNotifierConfigurationInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public IntegratedUserInfoList listUsers(String accountId, String connectId) throws ApiException {
        return this.listUsers(accountId, connectId, null);
    }

    public IntegratedUserInfoList listUsers(String accountId, String connectId, ListUsersOptions options) throws ApiException {
        ApiResponse<IntegratedUserInfoList> localVarResponse = this.listUsersWithHttpInfo(accountId, connectId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<IntegratedUserInfoList> listUsersWithHttpInfo(String accountId, String connectId, ListUsersOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listUsers");
        }
        if (connectId == null) {
            throw new ApiException(400, "Missing the required parameter 'connectId' when calling listUsers");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/{connectId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{connectId\\}", this.apiClient.escapeString(connectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email_substring", options.emailSubstring));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("list_included_users", options.listIncludedUsers));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_name_substring", options.userNameSubstring));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<IntegratedUserInfoList> localVarReturnType = new GenericType<IntegratedUserInfoList>(){};
        IntegratedUserInfoList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<IntegratedUserInfoList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConnectFailureResults retryEventForEnvelope(String accountId, String envelopeId) throws ApiException {
        ApiResponse<ConnectFailureResults> localVarResponse = this.retryEventForEnvelopeWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectFailureResults> retryEventForEnvelopeWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling retryEventForEnvelope");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling retryEventForEnvelope");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/envelopes/{envelopeId}/retry_queue".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectFailureResults> localVarReturnType = new GenericType<ConnectFailureResults>(){};
        ConnectFailureResults localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectFailureResults>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConnectFailureResults retryEventForEnvelopes(String accountId, ConnectFailureFilter connectFailureFilter) throws ApiException {
        ApiResponse<ConnectFailureResults> localVarResponse = this.retryEventForEnvelopesWithHttpInfo(accountId, connectFailureFilter);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectFailureResults> retryEventForEnvelopesWithHttpInfo(String accountId, ConnectFailureFilter connectFailureFilter) throws ApiException {
        ConnectFailureFilter localVarPostBody = connectFailureFilter;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling retryEventForEnvelopes");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/envelopes/retry_queue".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectFailureResults> localVarReturnType = new GenericType<ConnectFailureResults>(){};
        ConnectFailureResults localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectFailureResults>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConnectCustomConfiguration updateConfiguration(String accountId, ConnectCustomConfiguration connectCustomConfiguration) throws ApiException {
        ApiResponse<ConnectCustomConfiguration> localVarResponse = this.updateConfigurationWithHttpInfo(accountId, connectCustomConfiguration);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectCustomConfiguration> updateConfigurationWithHttpInfo(String accountId, ConnectCustomConfiguration connectCustomConfiguration) throws ApiException {
        ConnectCustomConfiguration localVarPostBody = connectCustomConfiguration;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateConfiguration");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectCustomConfiguration> localVarReturnType = new GenericType<ConnectCustomConfiguration>(){};
        ConnectCustomConfiguration localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectCustomConfiguration>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConnectOAuthConfig updateConnectOAuthConfig(String accountId, ConnectOAuthConfig connectOAuthConfig) throws ApiException {
        ApiResponse<ConnectOAuthConfig> localVarResponse = this.updateConnectOAuthConfigWithHttpInfo(accountId, connectOAuthConfig);
        return localVarResponse.getData();
    }

    public ApiResponse<ConnectOAuthConfig> updateConnectOAuthConfigWithHttpInfo(String accountId, ConnectOAuthConfig connectOAuthConfig) throws ApiException {
        ConnectOAuthConfig localVarPostBody = connectOAuthConfig;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateConnectOAuthConfig");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/oauth".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConnectOAuthConfig> localVarReturnType = new GenericType<ConnectOAuthConfig>(){};
        ConnectOAuthConfig localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConnectOAuthConfig>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public MobileNotifierConfigurationInformation updateMobileNotifiers(String accountId, MobileNotifierConfigurationInformation mobileNotifierConfigurationInformation) throws ApiException {
        ApiResponse<MobileNotifierConfigurationInformation> localVarResponse = this.updateMobileNotifiersWithHttpInfo(accountId, mobileNotifierConfigurationInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<MobileNotifierConfigurationInformation> updateMobileNotifiersWithHttpInfo(String accountId, MobileNotifierConfigurationInformation mobileNotifierConfigurationInformation) throws ApiException {
        MobileNotifierConfigurationInformation localVarPostBody = mobileNotifierConfigurationInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateMobileNotifiers");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/mobile_notifiers".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<MobileNotifierConfigurationInformation> localVarReturnType = new GenericType<MobileNotifierConfigurationInformation>(){};
        MobileNotifierConfigurationInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<MobileNotifierConfigurationInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class ListUsersOptions {
        private String count = null;
        private String emailSubstring = null;
        private String listIncludedUsers = null;
        private String startPosition = null;
        private String status = null;
        private String userNameSubstring = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setEmailSubstring(String emailSubstring) {
            this.emailSubstring = emailSubstring;
        }

        public String getEmailSubstring() {
            return this.emailSubstring;
        }

        public void setListIncludedUsers(String listIncludedUsers) {
            this.listIncludedUsers = listIncludedUsers;
        }

        public String getListIncludedUsers() {
            return this.listIncludedUsers;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setUserNameSubstring(String userNameSubstring) {
            this.userNameSubstring = userNameSubstring;
        }

        public String getUserNameSubstring() {
            return this.userNameSubstring;
        }
    }

    public class ListEventLogsOptions {
        private String fromDate = null;
        private String toDate = null;

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class ListEventFailureLogsOptions {
        private String fromDate = null;
        private String toDate = null;

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class GetEventLogOptions {
        private String additionalInfo = null;

        public void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public String getAdditionalInfo() {
            return this.additionalInfo;
        }
    }

    public class GetConnectAllUsersOptions {
        private String count = null;
        private String domainUsersOnly = null;
        private String emailSubstring = null;
        private String startPosition = null;
        private String status = null;
        private String userNameSubstring = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setDomainUsersOnly(String domainUsersOnly) {
            this.domainUsersOnly = domainUsersOnly;
        }

        public String getDomainUsersOnly() {
            return this.domainUsersOnly;
        }

        public void setEmailSubstring(String emailSubstring) {
            this.emailSubstring = emailSubstring;
        }

        public String getEmailSubstring() {
            return this.emailSubstring;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setUserNameSubstring(String userNameSubstring) {
            this.userNameSubstring = userNameSubstring;
        }

        public String getUserNameSubstring() {
            return this.userNameSubstring;
        }
    }
}

