/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.util.config;

import com.dangdang.ddframe.job.exception.JobConfigurationException;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ShardingItemParameters {
    private static final String PARAMETER_DELIMITER = ",";
    private static final String KEY_VALUE_DELIMITER = "=";
    private final Map<Integer, String> map;

    public ShardingItemParameters(String shardingItemParameters) {
        this.map = this.toMap(shardingItemParameters);
    }

    private Map<Integer, String> toMap(String originalShardingItemParameters) {
        if (Strings.isNullOrEmpty((String)originalShardingItemParameters)) {
            return Collections.emptyMap();
        }
        String[] shardingItemParameters = originalShardingItemParameters.split(PARAMETER_DELIMITER);
        HashMap<Integer, String> result = new HashMap<Integer, String>(shardingItemParameters.length);
        for (String each : shardingItemParameters) {
            ShardingItem shardingItem = this.parse(each, originalShardingItemParameters);
            result.put(shardingItem.item, shardingItem.parameter);
        }
        return result;
    }

    private ShardingItem parse(String shardingItemParameter, String originalShardingItemParameters) {
        String[] pair = shardingItemParameter.trim().split(KEY_VALUE_DELIMITER);
        if (2 != pair.length) {
            throw new JobConfigurationException("Sharding item parameters '%s' format error, should be int=xx,int=xx", originalShardingItemParameters);
        }
        try {
            return new ShardingItem(Integer.parseInt(pair[0].trim()), pair[1].trim());
        }
        catch (NumberFormatException ex) {
            throw new JobConfigurationException("Sharding item parameters key '%s' is not an integer.", pair[0]);
        }
    }

    public Map<Integer, String> getMap() {
        return this.map;
    }

    private static final class ShardingItem {
        private final int item;
        private final String parameter;

        @ConstructorProperties(value={"item", "parameter"})
        public ShardingItem(int item, String parameter) {
            this.item = item;
            this.parameter = parameter;
        }
    }
}

