/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.googleanalytics.discovery;

import com.brsanthu.googleanalytics.GoogleAnalyticsConfig;
import com.brsanthu.googleanalytics.discovery.RequestParameterDiscoverer;
import com.brsanthu.googleanalytics.internal.GaUtils;
import com.brsanthu.googleanalytics.request.DefaultRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestParameterDiscoverer
implements RequestParameterDiscoverer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRequestParameterDiscoverer.class);
    public static final DefaultRequestParameterDiscoverer INSTANCE = new DefaultRequestParameterDiscoverer();

    @Override
    public DefaultRequest discoverParameters(GoogleAnalyticsConfig config, DefaultRequest request) {
        try {
            if (GaUtils.isEmpty(config.getUserAgent())) {
                config.setUserAgent(this.getUserAgentString());
            }
            if (GaUtils.isEmpty(request.userLanguage())) {
                String region = System.getProperty("user.region");
                if (GaUtils.isEmpty(region)) {
                    region = System.getProperty("user.country");
                }
                request.userLanguage(System.getProperty("user.language") + "-" + region);
            }
            if (GaUtils.isEmpty(request.documentEncoding())) {
                request.documentEncoding(System.getProperty("file.encoding"));
            }
        }
        catch (Exception e) {
            logger.warn("Exception while deriving the System properties for request " + request, (Throwable)e);
        }
        return request;
    }

    protected String getUserAgentString() {
        StringBuilder sb = new StringBuilder("java");
        GaUtils.appendSystemProperty(sb, "java.runtime.version");
        GaUtils.appendSystemProperty(sb, "java.specification.vendor");
        GaUtils.appendSystemProperty(sb, "java.vm.name");
        GaUtils.appendSystemProperty(sb, "os.name");
        GaUtils.appendSystemProperty(sb, "os.version");
        GaUtils.appendSystemProperty(sb, "os.arch");
        return sb.toString();
    }
}

