/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.MultiValueFacetDataCache;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.filter.AdaptiveFacetFilter;
import com.browseengine.bobo.facets.filter.EmptyFilter;
import com.browseengine.bobo.facets.filter.MultiValueFacetFilter;
import com.browseengine.bobo.facets.filter.MultiValueORFacetFilter;
import com.browseengine.bobo.facets.filter.RandomAccessAndFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.filter.RandomAccessNotFilter;
import com.browseengine.bobo.facets.impl.DefaultFacetCountCollector;
import com.browseengine.bobo.facets.range.MultiDataCacheBuilder;
import com.browseengine.bobo.facets.range.SimpleDataCacheBuilder;
import com.browseengine.bobo.query.scoring.BoboDocScorer;
import com.browseengine.bobo.query.scoring.FacetScoreable;
import com.browseengine.bobo.query.scoring.FacetTermScoringFunctionFactory;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.util.BigNestedIntArray;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;

public class MultiValueFacetHandler
extends FacetHandler<MultiValueFacetDataCache>
implements FacetScoreable {
    private static Logger logger = Logger.getLogger(MultiValueFacetHandler.class);
    protected final TermListFactory _termListFactory;
    protected final String _indexFieldName;
    protected int _maxItems = 1024;
    protected Term _sizePayloadTerm;
    protected Set<String> _depends;

    public MultiValueFacetHandler(String name, String indexFieldName, TermListFactory termListFactory, Term sizePayloadTerm, Set<String> depends) {
        super(name, depends);
        this._depends = depends;
        this._indexFieldName = indexFieldName != null ? indexFieldName : name;
        this._termListFactory = termListFactory;
        this._sizePayloadTerm = sizePayloadTerm;
    }

    @Override
    public int getNumItems(BoboIndexReader reader, int id) {
        MultiValueFacetDataCache data = (MultiValueFacetDataCache)this.getFacetData(reader);
        if (data == null) {
            return 0;
        }
        return data.getNumItems(id);
    }

    public MultiValueFacetHandler(String name, String indexFieldName, TermListFactory termListFactory, Term sizePayloadTerm) {
        this(name, indexFieldName, termListFactory, sizePayloadTerm, null);
    }

    public MultiValueFacetHandler(String name, TermListFactory termListFactory, Term sizePayloadTerm) {
        this(name, name, termListFactory, sizePayloadTerm, null);
    }

    public MultiValueFacetHandler(String name, String indexFieldName, TermListFactory termListFactory) {
        this(name, indexFieldName, termListFactory, null, null);
    }

    public MultiValueFacetHandler(String name, TermListFactory termListFactory) {
        this(name, name, termListFactory);
    }

    public MultiValueFacetHandler(String name, String indexFieldName) {
        this(name, indexFieldName, null);
    }

    public MultiValueFacetHandler(String name) {
        this(name, name, null);
    }

    public MultiValueFacetHandler(String name, Set<String> depends) {
        this(name, name, null, null, depends);
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        return new MultiValueFacetDataCache.MultiFacetDocComparatorSource(new MultiDataCacheBuilder(this.getName(), this._indexFieldName));
    }

    public void setMaxItems(int maxItems) {
        this._maxItems = Math.min(maxItems, 1024);
    }

    @Override
    public String[] getFieldValues(BoboIndexReader reader, int id) {
        MultiValueFacetDataCache dataCache = (MultiValueFacetDataCache)this.getFacetData(reader);
        if (dataCache != null) {
            return dataCache._nestedArray.getTranslatedData(id, dataCache.valArray);
        }
        return new String[0];
    }

    @Override
    public Object[] getRawFieldValues(BoboIndexReader reader, int id) {
        MultiValueFacetDataCache dataCache = (MultiValueFacetDataCache)this.getFacetData(reader);
        if (dataCache != null) {
            return dataCache._nestedArray.getRawData(id, dataCache.valArray);
        }
        return new String[0];
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(final BrowseSelection sel, final FacetSpec ospec) {
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboIndexReader reader, int docBase) {
                MultiValueFacetDataCache dataCache = (MultiValueFacetDataCache)MultiValueFacetHandler.this.getFacetData(reader);
                return new MultiValueFacetCountCollector(MultiValueFacetHandler.this._name, dataCache, docBase, sel, ospec);
            }
        };
    }

    @Override
    public MultiValueFacetDataCache load(BoboIndexReader reader) throws IOException {
        return this.load(reader, new BoboIndexReader.WorkArea());
    }

    @Override
    public MultiValueFacetDataCache load(BoboIndexReader reader, BoboIndexReader.WorkArea workArea) throws IOException {
        MultiValueFacetDataCache dataCache = new MultiValueFacetDataCache();
        dataCache.setMaxItems(this._maxItems);
        if (this._sizePayloadTerm == null) {
            dataCache.load(this._indexFieldName, (IndexReader)reader, this._termListFactory, workArea);
        } else {
            dataCache.load(this._indexFieldName, (IndexReader)reader, this._termListFactory, this._sizePayloadTerm);
        }
        return dataCache;
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties prop) throws IOException {
        MultiValueFacetFilter f = new MultiValueFacetFilter(new MultiDataCacheBuilder(this.getName(), this._indexFieldName), value);
        AdaptiveFacetFilter af = new AdaptiveFacetFilter(new SimpleDataCacheBuilder(this.getName(), this._indexFieldName), f, new String[]{value}, false);
        return af;
    }

    @Override
    public RandomAccessFilter buildRandomAccessAndFilter(String[] vals, Properties prop) throws IOException {
        ArrayList<RandomAccessFilter> filterList = new ArrayList<RandomAccessFilter>(vals.length);
        for (String val : vals) {
            RandomAccessFilter f = this.buildRandomAccessFilter(val, prop);
            if (f == null) {
                return EmptyFilter.getInstance();
            }
            filterList.add(f);
        }
        if (filterList.size() == 1) {
            return (RandomAccessFilter)((Object)filterList.get(0));
        }
        return new RandomAccessAndFilter(filterList);
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties prop, boolean isNot) throws IOException {
        RandomAccessFilter filter = null;
        if (vals.length > 1) {
            MultiValueORFacetFilter f = new MultiValueORFacetFilter(this, vals, false);
            if (!isNot) {
                AdaptiveFacetFilter af = new AdaptiveFacetFilter(new SimpleDataCacheBuilder(this.getName(), this._indexFieldName), f, vals, false);
                return af;
            }
            filter = f;
        } else {
            filter = vals.length == 1 ? this.buildRandomAccessFilter(vals[0], prop) : EmptyFilter.getInstance();
        }
        if (isNot) {
            filter = new RandomAccessNotFilter(filter);
        }
        return filter;
    }

    @Override
    public BoboDocScorer getDocScorer(BoboIndexReader reader, FacetTermScoringFunctionFactory scoringFunctionFactory, Map<String, Float> boostMap) {
        MultiValueFacetDataCache dataCache = (MultiValueFacetDataCache)this.getFacetData(reader);
        float[] boostList = BoboDocScorer.buildBoostList(dataCache.valArray, boostMap);
        return new MultiValueDocScorer(dataCache, scoringFunctionFactory, boostList);
    }

    public static final class MultiValueFacetCountCollector
    extends DefaultFacetCountCollector {
        public final BigNestedIntArray _array;

        MultiValueFacetCountCollector(String name, MultiValueFacetDataCache dataCache, int docBase, BrowseSelection sel, FacetSpec ospec) {
            super(name, dataCache, docBase, sel, ospec);
            this._array = dataCache._nestedArray;
        }

        @Override
        public final void collect(int docid) {
            this._array.countNoReturn(docid, this._count);
        }

        @Override
        public final void collectAll() {
            this._count = this._dataCache.freqs;
        }
    }

    public static final class MultiValueDocScorer
    extends BoboDocScorer {
        private final MultiValueFacetDataCache _dataCache;
        private final BigNestedIntArray _array;

        public MultiValueDocScorer(MultiValueFacetDataCache dataCache, FacetTermScoringFunctionFactory scoreFunctionFactory, float[] boostList) {
            super(scoreFunctionFactory.getFacetTermScoringFunction(dataCache.valArray.size(), dataCache._nestedArray.size()), boostList);
            this._dataCache = dataCache;
            this._array = this._dataCache._nestedArray;
        }

        @Override
        public Explanation explain(int doc) {
            String[] vals = this._array.getTranslatedData(doc, this._dataCache.valArray);
            FloatArrayList scoreList = new FloatArrayList(this._dataCache.valArray.size());
            ArrayList<Explanation> explList = new ArrayList<Explanation>(scoreList.size());
            for (String val : vals) {
                int idx = this._dataCache.valArray.indexOf(val);
                if (idx < 0) continue;
                scoreList.add(this._function.score(this._dataCache.freqs[idx], this._boostList[idx]));
                explList.add(this._function.explain(this._dataCache.freqs[idx], this._boostList[idx]));
            }
            Explanation topLevel = this._function.explain(scoreList.toFloatArray());
            for (Explanation sub : explList) {
                topLevel.addDetail(sub);
            }
            return topLevel;
        }

        @Override
        public final float score(int docid) {
            return this._array.getScores(docid, this._dataCache.freqs, this._boostList, this._function);
        }
    }
}

