/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.sort;

import com.browseengine.bobo.sort.DocComparator;
import org.apache.log4j.Logger;
import org.apache.lucene.search.ScoreDoc;

public class DocIDPriorityQueue {
    private static Logger logger = Logger.getLogger((String)DocIDPriorityQueue.class.getName());
    public int size;
    protected final ScoreDoc[] heap;
    public final int base;
    private final DocComparator comparator;

    public DocIDPriorityQueue(DocComparator comparator, int maxSize, int base) {
        this.comparator = comparator;
        this.size = 0;
        this.base = base;
        int heapSize = 0 == maxSize ? 2 : maxSize + 1;
        this.heap = new ScoreDoc[heapSize];
    }

    public final ScoreDoc add(ScoreDoc element) {
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap();
        return this.heap[1];
    }

    public Comparable<?> sortValue(ScoreDoc doc) {
        return this.comparator.value(doc);
    }

    private final int compare(ScoreDoc doc1, ScoreDoc doc2) {
        int cmp = this.comparator.compare(doc1, doc2);
        if (cmp != 0) {
            return -cmp;
        }
        return doc2.doc - doc1.doc;
    }

    public ScoreDoc replace(ScoreDoc element) {
        this.heap[1] = element;
        this.downHeap();
        return this.heap[1];
    }

    public final ScoreDoc top() {
        return this.heap[1];
    }

    public final ScoreDoc pop() {
        if (this.size > 0) {
            ScoreDoc result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            this.downHeap();
            return result;
        }
        return null;
    }

    public final ScoreDoc updateTop() {
        this.downHeap();
        return this.heap[1];
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        for (int i = 0; i <= this.size; ++i) {
            this.heap[i] = null;
        }
        this.size = 0;
    }

    private final void upHeap() {
        int i = this.size;
        ScoreDoc node = this.heap[i];
        for (int j = i >>> 1; j > 0 && this.compare(node, this.heap[j]) < 0; j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
    }

    private final void downHeap() {
        int i = 1;
        ScoreDoc node = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.compare(this.heap[k], this.heap[j]) < 0) {
            j = k;
        }
        while (j <= this.size && this.compare(this.heap[j], node) < 0) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || this.compare(this.heap[k], this.heap[j]) >= 0) continue;
            j = k;
        }
        this.heap[i] = node;
    }
}

