/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class MetadataQuery {
    static final String FROM = "from";
    static final String LIMIT = "limit";
    static final String QUERY = "query";
    static final String ANCESTOR_FOLDER_ID = "ancestor_folder_id";
    static final String MARKER = "marker";
    static final String ORDER_BY = "order_by";
    static final String FIELDS = "fields";
    static final String QUERY_PARAMS = "query_params";
    private final String from;
    private final int limit;
    private String query;
    private JsonObject queryParameters = new JsonObject();
    private String ancestorFolderId = "0";
    private List<OrderBy> orderBy = new ArrayList<OrderBy>();
    private String marker;
    private List<String> fields = new ArrayList<String>();

    public MetadataQuery(String from, int limit) {
        this.from = from;
        this.limit = limit;
    }

    public MetadataQuery(String from) {
        this(from, 100);
    }

    public MetadataQuery setQuery(String query) {
        this.query = query;
        return this;
    }

    public MetadataQuery setAncestorFolderId(String ancestorFolderId) {
        this.ancestorFolderId = ancestorFolderId;
        return this;
    }

    public MetadataQuery setMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public MetadataQuery setOrderBy(OrderBy ... fields) {
        this.orderBy = new ArrayList<OrderBy>();
        this.orderBy.addAll(Arrays.asList(fields));
        return this;
    }

    MetadataQuery setOrderBy(JsonArray orderBy) {
        if (orderBy != null) {
            this.orderBy = orderBy.values().stream().map(OrderBy::fromJson).collect(Collectors.toList());
        }
        return this;
    }

    public MetadataQuery setFields(String ... fields) {
        this.fields = new ArrayList<String>();
        this.fields.addAll(Arrays.asList(fields));
        return this;
    }

    public MetadataQuery addParameter(String name, String value) {
        this.queryParameters.add(name, value);
        return this;
    }

    public MetadataQuery addParameter(String name, int value) {
        this.queryParameters.add(name, value);
        return this;
    }

    public MetadataQuery addParameter(String name, boolean value) {
        this.queryParameters.add(name, value);
        return this;
    }

    public MetadataQuery addParameter(String name, float value) {
        this.queryParameters.add(name, value);
        return this;
    }

    public MetadataQuery addParameter(String name, long value) {
        this.queryParameters.add(name, value);
        return this;
    }

    public MetadataQuery addParameter(String name, double value) {
        this.queryParameters.add(name, value);
        return this;
    }

    public MetadataQuery addParameter(String name, JsonValue value) {
        this.queryParameters.add(name, Json.parse((String)value.toString()));
        return this;
    }

    MetadataQuery setQueryParams(JsonObject queryParameters) {
        this.queryParameters = new JsonObject(queryParameters);
        return this;
    }

    JsonObject toJsonObject() {
        JsonObject jsonObject = new JsonObject().add(FROM, this.from).add(LIMIT, this.limit);
        if (this.query != null) {
            jsonObject.add(QUERY, this.query);
        }
        if (this.ancestorFolderId != null) {
            jsonObject.add(ANCESTOR_FOLDER_ID, this.ancestorFolderId);
        }
        if (this.marker != null) {
            jsonObject.add(MARKER, this.marker);
        }
        if (!this.orderBy.isEmpty()) {
            JsonArray orderByJson = new JsonArray();
            this.orderBy.stream().map(OrderBy::toJsonObject).forEach(arg_0 -> ((JsonArray)orderByJson).add(arg_0));
            jsonObject.add(ORDER_BY, (JsonValue)orderByJson);
        }
        if (!this.fields.isEmpty()) {
            JsonArray fieldsJson = new JsonArray();
            this.fields.forEach(arg_0 -> ((JsonArray)fieldsJson).add(arg_0));
            jsonObject.add(FIELDS, (JsonValue)fieldsJson);
        }
        if (this.queryParameters.iterator().hasNext()) {
            jsonObject.add(QUERY_PARAMS, (JsonValue)new JsonObject(this.queryParameters));
        }
        return jsonObject;
    }

    int getLimit() {
        return this.limit;
    }

    String getMarker() {
        return this.marker;
    }

    public static final class OrderBy {
        static final String FIELD_KEY = "field_key";
        static final String DIRECTION = "direction";
        static final String DIRECTION_ASCENDING = "asc";
        static final String DIRECTION_DESCENDING = "desc";
        private final String fieldName;
        private final String direction;

        private OrderBy(String fieldName, String direction) {
            this.fieldName = fieldName;
            this.direction = direction;
        }

        JsonObject toJsonObject() {
            return new JsonObject().add(FIELD_KEY, this.fieldName).add(DIRECTION, this.direction);
        }

        public static OrderBy ascending(String fieldName) {
            return new OrderBy(fieldName, DIRECTION_ASCENDING);
        }

        public static OrderBy descending(String fieldName) {
            return new OrderBy(fieldName, DIRECTION_DESCENDING);
        }

        static OrderBy fromJson(JsonValue jsonValue) {
            if (jsonValue.isObject()) {
                JsonObject object = jsonValue.asObject();
                String fieldName = object.get(FIELD_KEY).asString();
                String direction = object.get(DIRECTION).asString().toLowerCase(Locale.ROOT);
                if (!DIRECTION_ASCENDING.equals(direction) && !DIRECTION_DESCENDING.equals(direction)) {
                    throw new RuntimeException(String.format("Unsupported sort direction [%s] for field [%s]", direction, fieldName));
                }
                return object.getString(DIRECTION, "").equals(DIRECTION_ASCENDING) ? OrderBy.ascending(fieldName) : OrderBy.descending(fieldName);
            }
            throw new RuntimeException("Unsupported json " + jsonValue);
        }
    }
}

