/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.StandardCharsets;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.ParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

public class BoxJSONResponse
extends BoxAPIResponse {
    private static final int BUFFER_SIZE = 8192;
    private JsonObject jsonObject;

    public BoxJSONResponse() {
    }

    BoxJSONResponse(BoxAPIResponse response) {
        this(response.getResponseCode(), response.getRequestMethod(), response.getRequestUrl(), response.getHeaders(), new JsonObject());
    }

    public BoxJSONResponse(int responseCode, String requestMethod, String requestUrl, Map<String, List<String>> headers, JsonObject body) {
        super(responseCode, requestMethod, requestUrl, headers, body.toString(), "application/json");
        this.jsonObject = body;
    }

    public JsonObject getJsonObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        return Json.parse((String)this.getJSON()).asObject();
    }

    public String getJSON() {
        if (this.jsonObject != null) {
            return this.jsonObject.toString();
        }
        if (this.getBody() == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(this.getBody(), StandardCharsets.UTF_8);
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[8192];
        try {
            int read = reader.read(buffer, 0, 8192);
            while (read != -1) {
                builder.append(buffer, 0, read);
                read = reader.read(buffer, 0, 8192);
            }
            this.close();
            reader.close();
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
        String jsonAsString = builder.toString();
        try {
            this.jsonObject = Json.parse((String)jsonAsString).asObject();
        }
        catch (ParseException e) {
            throw new RuntimeException("Error parsing JSON:\n" + jsonAsString, e);
        }
        return jsonAsString;
    }

    @Override
    protected String bodyToString() {
        String bodyString = super.bodyToString();
        if (bodyString == null) {
            return this.getJSON();
        }
        return bodyString;
    }
}

