/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.AbstractBoxMultipartRequest;
import com.box.sdk.BoxAPIConnection;
import java.net.URL;
import okhttp3.MediaType;

class BoxImageMultipartRequest
extends AbstractBoxMultipartRequest {
    private final String partName;

    BoxImageMultipartRequest(BoxAPIConnection api, URL url, String partName) {
        super(api, url);
        this.partName = partName;
    }

    @Override
    protected String getPartName() {
        return this.partName;
    }

    @Override
    protected MediaType getPartContentType(String filename) {
        return MediaType.parse((String)this.determineImageTypeFromFileName(filename));
    }

    private String determineImageTypeFromFileName(String filename) {
        String[] filenameAndExtension = filename.split("\\.");
        if (filenameAndExtension.length > 1) {
            return "image/" + filenameAndExtension[filenameAndExtension.length - 1];
        }
        throw new IllegalArgumentException("Could not determine file extenstion for Avatar Upload. Filename: " + filename);
    }
}

