/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.group;

import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.groupbase.GroupBaseTypeField;
import com.box.sdkgen.schemas.groupmini.GroupMini;
import com.box.sdkgen.schemas.groupmini.GroupMiniGroupTypeField;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class Group
extends GroupMini {
    @JsonProperty(value="created_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime createdAt;
    @JsonProperty(value="modified_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime modifiedAt;

    public Group(@JsonProperty(value="id") String id) {
        super(id);
    }

    protected Group(Builder builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group casted = (Group)o;
        return Objects.equals(this.id, casted.id) && Objects.equals(this.type, casted.type) && Objects.equals(this.name, casted.name) && Objects.equals(this.groupType, casted.groupType) && Objects.equals(this.createdAt, casted.createdAt) && Objects.equals(this.modifiedAt, casted.modifiedAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.type, this.name, this.groupType, this.createdAt, this.modifiedAt);
    }

    @Override
    public String toString() {
        return "Group{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", groupType='" + this.groupType + '\'' + ", createdAt='" + this.createdAt + '\'' + ", modifiedAt='" + this.modifiedAt + '\'' + "}";
    }

    public static class Builder
    extends GroupMini.Builder {
        protected OffsetDateTime createdAt;
        protected OffsetDateTime modifiedAt;

        public Builder(String id) {
            super(id);
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public Builder type(GroupBaseTypeField type) {
            this.type = new EnumWrapper<GroupBaseTypeField>(type);
            return this;
        }

        @Override
        public Builder type(EnumWrapper<GroupBaseTypeField> type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder groupType(GroupMiniGroupTypeField groupType) {
            this.groupType = new EnumWrapper<GroupMiniGroupTypeField>(groupType);
            return this;
        }

        @Override
        public Builder groupType(EnumWrapper<GroupMiniGroupTypeField> groupType) {
            this.groupType = groupType;
            return this;
        }

        @Override
        public Group build() {
            return new Group(this);
        }
    }
}

