/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.transfer;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.transfer.TransferOwnedFolderHeaders;
import com.box.sdkgen.managers.transfer.TransferOwnedFolderQueryParams;
import com.box.sdkgen.managers.transfer.TransferOwnedFolderRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.folderfull.FolderFull;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class TransferManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public TransferManager() {
        this.networkSession = new NetworkSession();
    }

    protected TransferManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public FolderFull transferOwnedFolder(String userId, TransferOwnedFolderRequestBody requestBody) {
        return this.transferOwnedFolder(userId, requestBody, new TransferOwnedFolderQueryParams(), new TransferOwnedFolderHeaders());
    }

    public FolderFull transferOwnedFolder(String userId, TransferOwnedFolderRequestBody requestBody, TransferOwnedFolderQueryParams queryParams) {
        return this.transferOwnedFolder(userId, requestBody, queryParams, new TransferOwnedFolderHeaders());
    }

    public FolderFull transferOwnedFolder(String userId, TransferOwnedFolderRequestBody requestBody, TransferOwnedFolderHeaders headers) {
        return this.transferOwnedFolder(userId, requestBody, new TransferOwnedFolderQueryParams(), headers);
    }

    public FolderFull transferOwnedFolder(String userId, TransferOwnedFolderRequestBody requestBody, TransferOwnedFolderQueryParams queryParams, TransferOwnedFolderHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("notify", UtilsManager.convertToString(queryParams.getNotify()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/", UtilsManager.convertToString(userId), "/folders/0"), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FolderFull.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public TransferManager build() {
            return new TransferManager(this);
        }
    }
}

