/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.shieldinformationbarriers;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.shieldinformationbarriers.CreateShieldInformationBarrierHeaders;
import com.box.sdkgen.managers.shieldinformationbarriers.CreateShieldInformationBarrierRequestBody;
import com.box.sdkgen.managers.shieldinformationbarriers.GetShieldInformationBarrierByIdHeaders;
import com.box.sdkgen.managers.shieldinformationbarriers.GetShieldInformationBarriersHeaders;
import com.box.sdkgen.managers.shieldinformationbarriers.GetShieldInformationBarriersQueryParams;
import com.box.sdkgen.managers.shieldinformationbarriers.UpdateShieldInformationBarrierStatusHeaders;
import com.box.sdkgen.managers.shieldinformationbarriers.UpdateShieldInformationBarrierStatusRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.shieldinformationbarrier.ShieldInformationBarrier;
import com.box.sdkgen.schemas.shieldinformationbarriers.ShieldInformationBarriers;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class ShieldInformationBarriersManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public ShieldInformationBarriersManager() {
        this.networkSession = new NetworkSession();
    }

    protected ShieldInformationBarriersManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public ShieldInformationBarrier getShieldInformationBarrierById(String shieldInformationBarrierId) {
        return this.getShieldInformationBarrierById(shieldInformationBarrierId, new GetShieldInformationBarrierByIdHeaders());
    }

    public ShieldInformationBarrier getShieldInformationBarrierById(String shieldInformationBarrierId, GetShieldInformationBarrierByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/shield_information_barriers/", UtilsManager.convertToString(shieldInformationBarrierId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), ShieldInformationBarrier.class);
    }

    public ShieldInformationBarrier updateShieldInformationBarrierStatus(UpdateShieldInformationBarrierStatusRequestBody requestBody) {
        return this.updateShieldInformationBarrierStatus(requestBody, new UpdateShieldInformationBarrierStatusHeaders());
    }

    public ShieldInformationBarrier updateShieldInformationBarrierStatus(UpdateShieldInformationBarrierStatusRequestBody requestBody, UpdateShieldInformationBarrierStatusHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/shield_information_barriers/change_status"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), ShieldInformationBarrier.class);
    }

    public ShieldInformationBarriers getShieldInformationBarriers() {
        return this.getShieldInformationBarriers(new GetShieldInformationBarriersQueryParams(), new GetShieldInformationBarriersHeaders());
    }

    public ShieldInformationBarriers getShieldInformationBarriers(GetShieldInformationBarriersQueryParams queryParams) {
        return this.getShieldInformationBarriers(queryParams, new GetShieldInformationBarriersHeaders());
    }

    public ShieldInformationBarriers getShieldInformationBarriers(GetShieldInformationBarriersHeaders headers) {
        return this.getShieldInformationBarriers(new GetShieldInformationBarriersQueryParams(), headers);
    }

    public ShieldInformationBarriers getShieldInformationBarriers(GetShieldInformationBarriersQueryParams queryParams, GetShieldInformationBarriersHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/shield_information_barriers"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), ShieldInformationBarriers.class);
    }

    public ShieldInformationBarrier createShieldInformationBarrier(CreateShieldInformationBarrierRequestBody requestBody) {
        return this.createShieldInformationBarrier(requestBody, new CreateShieldInformationBarrierHeaders());
    }

    public ShieldInformationBarrier createShieldInformationBarrier(CreateShieldInformationBarrierRequestBody requestBody, CreateShieldInformationBarrierHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/shield_information_barriers"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), ShieldInformationBarrier.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public ShieldInformationBarriersManager build() {
            return new ShieldInformationBarriersManager(this);
        }
    }
}

