/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.sharedlinksfiles;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.sharedlinksfiles.AddShareLinkToFileHeaders;
import com.box.sdkgen.managers.sharedlinksfiles.AddShareLinkToFileQueryParams;
import com.box.sdkgen.managers.sharedlinksfiles.AddShareLinkToFileRequestBody;
import com.box.sdkgen.managers.sharedlinksfiles.FindFileForSharedLinkHeaders;
import com.box.sdkgen.managers.sharedlinksfiles.FindFileForSharedLinkQueryParams;
import com.box.sdkgen.managers.sharedlinksfiles.GetSharedLinkForFileHeaders;
import com.box.sdkgen.managers.sharedlinksfiles.GetSharedLinkForFileQueryParams;
import com.box.sdkgen.managers.sharedlinksfiles.RemoveSharedLinkFromFileHeaders;
import com.box.sdkgen.managers.sharedlinksfiles.RemoveSharedLinkFromFileQueryParams;
import com.box.sdkgen.managers.sharedlinksfiles.RemoveSharedLinkFromFileRequestBody;
import com.box.sdkgen.managers.sharedlinksfiles.UpdateSharedLinkOnFileHeaders;
import com.box.sdkgen.managers.sharedlinksfiles.UpdateSharedLinkOnFileQueryParams;
import com.box.sdkgen.managers.sharedlinksfiles.UpdateSharedLinkOnFileRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.filefull.FileFull;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class SharedLinksFilesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public SharedLinksFilesManager() {
        this.networkSession = new NetworkSession();
    }

    protected SharedLinksFilesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public FileFull findFileForSharedLink(FindFileForSharedLinkHeaders headers) {
        return this.findFileForSharedLink(new FindFileForSharedLinkQueryParams(), headers);
    }

    public FileFull findFileForSharedLink(FindFileForSharedLinkQueryParams queryParams, FindFileForSharedLinkHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("if-none-match", UtilsManager.convertToString(headers.getIfNoneMatch())), UtilsManager.entryOf("boxapi", UtilsManager.convertToString(headers.getBoxapi()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/shared_items"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FileFull.class);
    }

    public FileFull getSharedLinkForFile(String fileId, GetSharedLinkForFileQueryParams queryParams) {
        return this.getSharedLinkForFile(fileId, queryParams, new GetSharedLinkForFileHeaders());
    }

    public FileFull getSharedLinkForFile(String fileId, GetSharedLinkForFileQueryParams queryParams, GetSharedLinkForFileHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "#get_shared_link"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FileFull.class);
    }

    public FileFull addShareLinkToFile(String fileId, AddShareLinkToFileQueryParams queryParams) {
        return this.addShareLinkToFile(fileId, new AddShareLinkToFileRequestBody(), queryParams, new AddShareLinkToFileHeaders());
    }

    public FileFull addShareLinkToFile(String fileId, AddShareLinkToFileRequestBody requestBody, AddShareLinkToFileQueryParams queryParams) {
        return this.addShareLinkToFile(fileId, requestBody, queryParams, new AddShareLinkToFileHeaders());
    }

    public FileFull addShareLinkToFile(String fileId, AddShareLinkToFileQueryParams queryParams, AddShareLinkToFileHeaders headers) {
        return this.addShareLinkToFile(fileId, new AddShareLinkToFileRequestBody(), queryParams, headers);
    }

    public FileFull addShareLinkToFile(String fileId, AddShareLinkToFileRequestBody requestBody, AddShareLinkToFileQueryParams queryParams, AddShareLinkToFileHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "#add_shared_link"), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FileFull.class);
    }

    public FileFull updateSharedLinkOnFile(String fileId, UpdateSharedLinkOnFileQueryParams queryParams) {
        return this.updateSharedLinkOnFile(fileId, new UpdateSharedLinkOnFileRequestBody(), queryParams, new UpdateSharedLinkOnFileHeaders());
    }

    public FileFull updateSharedLinkOnFile(String fileId, UpdateSharedLinkOnFileRequestBody requestBody, UpdateSharedLinkOnFileQueryParams queryParams) {
        return this.updateSharedLinkOnFile(fileId, requestBody, queryParams, new UpdateSharedLinkOnFileHeaders());
    }

    public FileFull updateSharedLinkOnFile(String fileId, UpdateSharedLinkOnFileQueryParams queryParams, UpdateSharedLinkOnFileHeaders headers) {
        return this.updateSharedLinkOnFile(fileId, new UpdateSharedLinkOnFileRequestBody(), queryParams, headers);
    }

    public FileFull updateSharedLinkOnFile(String fileId, UpdateSharedLinkOnFileRequestBody requestBody, UpdateSharedLinkOnFileQueryParams queryParams, UpdateSharedLinkOnFileHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "#update_shared_link"), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FileFull.class);
    }

    public FileFull removeSharedLinkFromFile(String fileId, RemoveSharedLinkFromFileQueryParams queryParams) {
        return this.removeSharedLinkFromFile(fileId, new RemoveSharedLinkFromFileRequestBody(), queryParams, new RemoveSharedLinkFromFileHeaders());
    }

    public FileFull removeSharedLinkFromFile(String fileId, RemoveSharedLinkFromFileRequestBody requestBody, RemoveSharedLinkFromFileQueryParams queryParams) {
        return this.removeSharedLinkFromFile(fileId, requestBody, queryParams, new RemoveSharedLinkFromFileHeaders());
    }

    public FileFull removeSharedLinkFromFile(String fileId, RemoveSharedLinkFromFileQueryParams queryParams, RemoveSharedLinkFromFileHeaders headers) {
        return this.removeSharedLinkFromFile(fileId, new RemoveSharedLinkFromFileRequestBody(), queryParams, headers);
    }

    public FileFull removeSharedLinkFromFile(String fileId, RemoveSharedLinkFromFileRequestBody requestBody, RemoveSharedLinkFromFileQueryParams queryParams, RemoveSharedLinkFromFileHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "#remove_shared_link"), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FileFull.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public SharedLinksFilesManager build() {
            return new SharedLinksFilesManager(this);
        }
    }
}

