/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.folderwatermarks;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.folderwatermarks.DeleteFolderWatermarkHeaders;
import com.box.sdkgen.managers.folderwatermarks.GetFolderWatermarkHeaders;
import com.box.sdkgen.managers.folderwatermarks.UpdateFolderWatermarkHeaders;
import com.box.sdkgen.managers.folderwatermarks.UpdateFolderWatermarkRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.watermark.Watermark;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class FolderWatermarksManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public FolderWatermarksManager() {
        this.networkSession = new NetworkSession();
    }

    protected FolderWatermarksManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Watermark getFolderWatermark(String folderId) {
        return this.getFolderWatermark(folderId, new GetFolderWatermarkHeaders());
    }

    public Watermark getFolderWatermark(String folderId, GetFolderWatermarkHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "/watermark"), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Watermark.class);
    }

    public Watermark updateFolderWatermark(String folderId, UpdateFolderWatermarkRequestBody requestBody) {
        return this.updateFolderWatermark(folderId, requestBody, new UpdateFolderWatermarkHeaders());
    }

    public Watermark updateFolderWatermark(String folderId, UpdateFolderWatermarkRequestBody requestBody, UpdateFolderWatermarkHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "/watermark"), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Watermark.class);
    }

    public void deleteFolderWatermark(String folderId) {
        this.deleteFolderWatermark(folderId, new DeleteFolderWatermarkHeaders());
    }

    public void deleteFolderWatermark(String folderId, DeleteFolderWatermarkHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "/watermark"), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public FolderWatermarksManager build() {
            return new FolderWatermarksManager(this);
        }
    }
}

