/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.user;

import com.box.sdkgen.internal.Nullable;
import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.user.UserNotificationEmailField;
import com.box.sdkgen.schemas.user.UserStatusField;
import com.box.sdkgen.schemas.userbase.UserBaseTypeField;
import com.box.sdkgen.schemas.usermini.UserMini;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class User
extends UserMini {
    @JsonProperty(value="created_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime createdAt;
    @JsonProperty(value="modified_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime modifiedAt;
    protected String language;
    protected String timezone;
    @JsonProperty(value="space_amount")
    protected Long spaceAmount;
    @JsonProperty(value="space_used")
    protected Long spaceUsed;
    @JsonProperty(value="max_upload_size")
    protected Long maxUploadSize;
    @JsonDeserialize(using=UserStatusField.UserStatusFieldDeserializer.class)
    @JsonSerialize(using=UserStatusField.UserStatusFieldSerializer.class)
    protected EnumWrapper<UserStatusField> status;
    @JsonProperty(value="job_title")
    protected String jobTitle;
    protected String phone;
    protected String address;
    @JsonProperty(value="avatar_url")
    protected String avatarUrl;
    @JsonProperty(value="notification_email")
    @Nullable
    protected UserNotificationEmailField notificationEmail;

    public User(@JsonProperty(value="id") String id) {
        super(id);
    }

    protected User(Builder builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.language = builder.language;
        this.timezone = builder.timezone;
        this.spaceAmount = builder.spaceAmount;
        this.spaceUsed = builder.spaceUsed;
        this.maxUploadSize = builder.maxUploadSize;
        this.status = builder.status;
        this.jobTitle = builder.jobTitle;
        this.phone = builder.phone;
        this.address = builder.address;
        this.avatarUrl = builder.avatarUrl;
        this.notificationEmail = builder.notificationEmail;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public Long getSpaceAmount() {
        return this.spaceAmount;
    }

    public Long getSpaceUsed() {
        return this.spaceUsed;
    }

    public Long getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public EnumWrapper<UserStatusField> getStatus() {
        return this.status;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public UserNotificationEmailField getNotificationEmail() {
        return this.notificationEmail;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User casted = (User)o;
        return Objects.equals(this.id, casted.id) && Objects.equals(this.type, casted.type) && Objects.equals(this.name, casted.name) && Objects.equals(this.login, casted.login) && Objects.equals(this.createdAt, casted.createdAt) && Objects.equals(this.modifiedAt, casted.modifiedAt) && Objects.equals(this.language, casted.language) && Objects.equals(this.timezone, casted.timezone) && Objects.equals(this.spaceAmount, casted.spaceAmount) && Objects.equals(this.spaceUsed, casted.spaceUsed) && Objects.equals(this.maxUploadSize, casted.maxUploadSize) && Objects.equals(this.status, casted.status) && Objects.equals(this.jobTitle, casted.jobTitle) && Objects.equals(this.phone, casted.phone) && Objects.equals(this.address, casted.address) && Objects.equals(this.avatarUrl, casted.avatarUrl) && Objects.equals(this.notificationEmail, casted.notificationEmail);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.type, this.name, this.login, this.createdAt, this.modifiedAt, this.language, this.timezone, this.spaceAmount, this.spaceUsed, this.maxUploadSize, this.status, this.jobTitle, this.phone, this.address, this.avatarUrl, this.notificationEmail);
    }

    @Override
    public String toString() {
        return "User{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", login='" + this.login + '\'' + ", createdAt='" + this.createdAt + '\'' + ", modifiedAt='" + this.modifiedAt + '\'' + ", language='" + this.language + '\'' + ", timezone='" + this.timezone + '\'' + ", spaceAmount='" + this.spaceAmount + '\'' + ", spaceUsed='" + this.spaceUsed + '\'' + ", maxUploadSize='" + this.maxUploadSize + '\'' + ", status='" + this.status + '\'' + ", jobTitle='" + this.jobTitle + '\'' + ", phone='" + this.phone + '\'' + ", address='" + this.address + '\'' + ", avatarUrl='" + this.avatarUrl + '\'' + ", notificationEmail='" + this.notificationEmail + '\'' + "}";
    }

    public static class Builder
    extends UserMini.Builder {
        protected OffsetDateTime createdAt;
        protected OffsetDateTime modifiedAt;
        protected String language;
        protected String timezone;
        protected Long spaceAmount;
        protected Long spaceUsed;
        protected Long maxUploadSize;
        protected EnumWrapper<UserStatusField> status;
        protected String jobTitle;
        protected String phone;
        protected String address;
        protected String avatarUrl;
        protected UserNotificationEmailField notificationEmail;

        public Builder(String id) {
            super(id);
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder spaceAmount(Long spaceAmount) {
            this.spaceAmount = spaceAmount;
            return this;
        }

        public Builder spaceUsed(Long spaceUsed) {
            this.spaceUsed = spaceUsed;
            return this;
        }

        public Builder maxUploadSize(Long maxUploadSize) {
            this.maxUploadSize = maxUploadSize;
            return this;
        }

        public Builder status(UserStatusField status) {
            this.status = new EnumWrapper<UserStatusField>(status);
            return this;
        }

        public Builder status(EnumWrapper<UserStatusField> status) {
            this.status = status;
            return this;
        }

        public Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder avatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        public Builder notificationEmail(UserNotificationEmailField notificationEmail) {
            this.notificationEmail = notificationEmail;
            this.markNullableFieldAsSet("notification_email");
            return this;
        }

        @Override
        public Builder type(UserBaseTypeField type) {
            this.type = new EnumWrapper<UserBaseTypeField>(type);
            return this;
        }

        @Override
        public Builder type(EnumWrapper<UserBaseTypeField> type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder login(String login) {
            this.login = login;
            return this;
        }

        @Override
        public User build() {
            return new User(this);
        }
    }
}

