/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.appitem;

import com.box.sdkgen.internal.NullableFieldTracker;
import com.box.sdkgen.internal.SerializableObject;
import com.box.sdkgen.schemas.appitem.AppItemTypeField;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class AppItem
extends SerializableObject {
    protected final String id;
    @JsonDeserialize(using=AppItemTypeField.AppItemTypeFieldDeserializer.class)
    @JsonSerialize(using=AppItemTypeField.AppItemTypeFieldSerializer.class)
    protected EnumWrapper<AppItemTypeField> type;
    @JsonProperty(value="application_type")
    protected final String applicationType;

    public AppItem(@JsonProperty(value="id") String id, @JsonProperty(value="application_type") String applicationType) {
        this.id = id;
        this.applicationType = applicationType;
        this.type = new EnumWrapper<AppItemTypeField>(AppItemTypeField.APP_ITEM);
    }

    protected AppItem(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.applicationType = builder.applicationType;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getId() {
        return this.id;
    }

    public EnumWrapper<AppItemTypeField> getType() {
        return this.type;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppItem casted = (AppItem)o;
        return Objects.equals(this.id, casted.id) && Objects.equals(this.type, casted.type) && Objects.equals(this.applicationType, casted.applicationType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.applicationType);
    }

    public String toString() {
        return "AppItem{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", applicationType='" + this.applicationType + '\'' + "}";
    }

    public static class Builder
    extends NullableFieldTracker {
        protected final String id;
        protected EnumWrapper<AppItemTypeField> type;
        protected final String applicationType;

        public Builder(String id, String applicationType) {
            this.id = id;
            this.applicationType = applicationType;
            this.type = new EnumWrapper<AppItemTypeField>(AppItemTypeField.APP_ITEM);
        }

        public Builder type(AppItemTypeField type) {
            this.type = new EnumWrapper<AppItemTypeField>(type);
            return this;
        }

        public Builder type(EnumWrapper<AppItemTypeField> type) {
            this.type = type;
            return this;
        }

        public AppItem build() {
            return new AppItem(this);
        }
    }
}

