/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.aiextract;

import com.box.sdkgen.internal.NullableFieldTracker;
import com.box.sdkgen.internal.SerializableObject;
import com.box.sdkgen.schemas.aiagentextract.AiAgentExtract;
import com.box.sdkgen.schemas.aiagentreference.AiAgentReference;
import com.box.sdkgen.schemas.aiextractagent.AiExtractAgent;
import com.box.sdkgen.schemas.aiitembase.AiItemBase;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class AiExtract
extends SerializableObject {
    protected final String prompt;
    protected final List<AiItemBase> items;
    @JsonProperty(value="ai_agent")
    protected AiExtractAgent aiAgent;

    public AiExtract(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="items") List<AiItemBase> items) {
        this.prompt = prompt;
        this.items = items;
    }

    protected AiExtract(Builder builder) {
        this.prompt = builder.prompt;
        this.items = builder.items;
        this.aiAgent = builder.aiAgent;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getPrompt() {
        return this.prompt;
    }

    public List<AiItemBase> getItems() {
        return this.items;
    }

    public AiExtractAgent getAiAgent() {
        return this.aiAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AiExtract casted = (AiExtract)o;
        return Objects.equals(this.prompt, casted.prompt) && Objects.equals(this.items, casted.items) && Objects.equals(this.aiAgent, casted.aiAgent);
    }

    public int hashCode() {
        return Objects.hash(this.prompt, this.items, this.aiAgent);
    }

    public String toString() {
        return "AiExtract{prompt='" + this.prompt + '\'' + ", items='" + this.items + '\'' + ", aiAgent='" + this.aiAgent + '\'' + "}";
    }

    public static class Builder
    extends NullableFieldTracker {
        protected final String prompt;
        protected final List<AiItemBase> items;
        protected AiExtractAgent aiAgent;

        public Builder(String prompt, List<AiItemBase> items) {
            this.prompt = prompt;
            this.items = items;
        }

        public Builder aiAgent(AiAgentReference aiAgent) {
            this.aiAgent = new AiExtractAgent(aiAgent);
            return this;
        }

        public Builder aiAgent(AiAgentExtract aiAgent) {
            this.aiAgent = new AiExtractAgent(aiAgent);
            return this;
        }

        public Builder aiAgent(AiExtractAgent aiAgent) {
            this.aiAgent = aiAgent;
            return this;
        }

        public AiExtract build() {
            return new AiExtract(this);
        }
    }
}

