/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.storagepolicies;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.storagepolicies.GetStoragePoliciesHeaders;
import com.box.sdkgen.managers.storagepolicies.GetStoragePoliciesQueryParams;
import com.box.sdkgen.managers.storagepolicies.GetStoragePolicyByIdHeaders;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.storagepolicies.StoragePolicies;
import com.box.sdkgen.schemas.storagepolicy.StoragePolicy;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class StoragePoliciesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public StoragePoliciesManager() {
        this.networkSession = new NetworkSession();
    }

    protected StoragePoliciesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public StoragePolicies getStoragePolicies() {
        return this.getStoragePolicies(new GetStoragePoliciesQueryParams(), new GetStoragePoliciesHeaders());
    }

    public StoragePolicies getStoragePolicies(GetStoragePoliciesQueryParams queryParams) {
        return this.getStoragePolicies(queryParams, new GetStoragePoliciesHeaders());
    }

    public StoragePolicies getStoragePolicies(GetStoragePoliciesHeaders headers) {
        return this.getStoragePolicies(new GetStoragePoliciesQueryParams(), headers);
    }

    public StoragePolicies getStoragePolicies(GetStoragePoliciesQueryParams queryParams, GetStoragePoliciesHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/storage_policies"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), StoragePolicies.class);
    }

    public StoragePolicy getStoragePolicyById(String storagePolicyId) {
        return this.getStoragePolicyById(storagePolicyId, new GetStoragePolicyByIdHeaders());
    }

    public StoragePolicy getStoragePolicyById(String storagePolicyId, GetStoragePolicyByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/storage_policies/", UtilsManager.convertToString(storagePolicyId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), StoragePolicy.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public StoragePoliciesManager build() {
            return new StoragePoliciesManager(this);
        }
    }
}

