/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.signrequests;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.signrequests.CancelSignRequestHeaders;
import com.box.sdkgen.managers.signrequests.CreateSignRequestHeaders;
import com.box.sdkgen.managers.signrequests.GetSignRequestByIdHeaders;
import com.box.sdkgen.managers.signrequests.GetSignRequestsHeaders;
import com.box.sdkgen.managers.signrequests.GetSignRequestsQueryParams;
import com.box.sdkgen.managers.signrequests.ResendSignRequestHeaders;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.signrequest.SignRequest;
import com.box.sdkgen.schemas.signrequestcreaterequest.SignRequestCreateRequest;
import com.box.sdkgen.schemas.signrequests.SignRequests;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class SignRequestsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public SignRequestsManager() {
        this.networkSession = new NetworkSession();
    }

    protected SignRequestsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public SignRequest cancelSignRequest(String signRequestId) {
        return this.cancelSignRequest(signRequestId, new CancelSignRequestHeaders());
    }

    public SignRequest cancelSignRequest(String signRequestId, CancelSignRequestHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/sign_requests/", UtilsManager.convertToString(signRequestId), "/cancel"), "POST").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), SignRequest.class);
    }

    public void resendSignRequest(String signRequestId) {
        this.resendSignRequest(signRequestId, new ResendSignRequestHeaders());
    }

    public void resendSignRequest(String signRequestId, ResendSignRequestHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/sign_requests/", UtilsManager.convertToString(signRequestId), "/resend"), "POST").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public SignRequest getSignRequestById(String signRequestId) {
        return this.getSignRequestById(signRequestId, new GetSignRequestByIdHeaders());
    }

    public SignRequest getSignRequestById(String signRequestId, GetSignRequestByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/sign_requests/", UtilsManager.convertToString(signRequestId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), SignRequest.class);
    }

    public SignRequests getSignRequests() {
        return this.getSignRequests(new GetSignRequestsQueryParams(), new GetSignRequestsHeaders());
    }

    public SignRequests getSignRequests(GetSignRequestsQueryParams queryParams) {
        return this.getSignRequests(queryParams, new GetSignRequestsHeaders());
    }

    public SignRequests getSignRequests(GetSignRequestsHeaders headers) {
        return this.getSignRequests(new GetSignRequestsQueryParams(), headers);
    }

    public SignRequests getSignRequests(GetSignRequestsQueryParams queryParams, GetSignRequestsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("senders", UtilsManager.convertToString(queryParams.getSenders())), UtilsManager.entryOf("shared_requests", UtilsManager.convertToString(queryParams.getSharedRequests()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/sign_requests"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), SignRequests.class);
    }

    public SignRequest createSignRequest(SignRequestCreateRequest requestBody) {
        return this.createSignRequest(requestBody, new CreateSignRequestHeaders());
    }

    public SignRequest createSignRequest(SignRequestCreateRequest requestBody, CreateSignRequestHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/sign_requests"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), SignRequest.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public SignRequestsManager build() {
            return new SignRequestsManager(this);
        }
    }
}

