/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.sharedlinksfolders;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.sharedlinksfolders.AddShareLinkToFolderHeaders;
import com.box.sdkgen.managers.sharedlinksfolders.AddShareLinkToFolderQueryParams;
import com.box.sdkgen.managers.sharedlinksfolders.AddShareLinkToFolderRequestBody;
import com.box.sdkgen.managers.sharedlinksfolders.FindFolderForSharedLinkHeaders;
import com.box.sdkgen.managers.sharedlinksfolders.FindFolderForSharedLinkQueryParams;
import com.box.sdkgen.managers.sharedlinksfolders.GetSharedLinkForFolderHeaders;
import com.box.sdkgen.managers.sharedlinksfolders.GetSharedLinkForFolderQueryParams;
import com.box.sdkgen.managers.sharedlinksfolders.RemoveSharedLinkFromFolderHeaders;
import com.box.sdkgen.managers.sharedlinksfolders.RemoveSharedLinkFromFolderQueryParams;
import com.box.sdkgen.managers.sharedlinksfolders.RemoveSharedLinkFromFolderRequestBody;
import com.box.sdkgen.managers.sharedlinksfolders.UpdateSharedLinkOnFolderHeaders;
import com.box.sdkgen.managers.sharedlinksfolders.UpdateSharedLinkOnFolderQueryParams;
import com.box.sdkgen.managers.sharedlinksfolders.UpdateSharedLinkOnFolderRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.folderfull.FolderFull;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class SharedLinksFoldersManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public SharedLinksFoldersManager() {
        this.networkSession = new NetworkSession();
    }

    protected SharedLinksFoldersManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public FolderFull findFolderForSharedLink(FindFolderForSharedLinkHeaders headers) {
        return this.findFolderForSharedLink(new FindFolderForSharedLinkQueryParams(), headers);
    }

    public FolderFull findFolderForSharedLink(FindFolderForSharedLinkQueryParams queryParams, FindFolderForSharedLinkHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("if-none-match", UtilsManager.convertToString(headers.getIfNoneMatch())), UtilsManager.entryOf("boxapi", UtilsManager.convertToString(headers.getBoxapi()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/shared_items#folders"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FolderFull.class);
    }

    public FolderFull getSharedLinkForFolder(String folderId, GetSharedLinkForFolderQueryParams queryParams) {
        return this.getSharedLinkForFolder(folderId, queryParams, new GetSharedLinkForFolderHeaders());
    }

    public FolderFull getSharedLinkForFolder(String folderId, GetSharedLinkForFolderQueryParams queryParams, GetSharedLinkForFolderHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "#get_shared_link"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FolderFull.class);
    }

    public FolderFull addShareLinkToFolder(String folderId, AddShareLinkToFolderQueryParams queryParams) {
        return this.addShareLinkToFolder(folderId, new AddShareLinkToFolderRequestBody(), queryParams, new AddShareLinkToFolderHeaders());
    }

    public FolderFull addShareLinkToFolder(String folderId, AddShareLinkToFolderRequestBody requestBody, AddShareLinkToFolderQueryParams queryParams) {
        return this.addShareLinkToFolder(folderId, requestBody, queryParams, new AddShareLinkToFolderHeaders());
    }

    public FolderFull addShareLinkToFolder(String folderId, AddShareLinkToFolderQueryParams queryParams, AddShareLinkToFolderHeaders headers) {
        return this.addShareLinkToFolder(folderId, new AddShareLinkToFolderRequestBody(), queryParams, headers);
    }

    public FolderFull addShareLinkToFolder(String folderId, AddShareLinkToFolderRequestBody requestBody, AddShareLinkToFolderQueryParams queryParams, AddShareLinkToFolderHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "#add_shared_link"), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FolderFull.class);
    }

    public FolderFull updateSharedLinkOnFolder(String folderId, UpdateSharedLinkOnFolderQueryParams queryParams) {
        return this.updateSharedLinkOnFolder(folderId, new UpdateSharedLinkOnFolderRequestBody(), queryParams, new UpdateSharedLinkOnFolderHeaders());
    }

    public FolderFull updateSharedLinkOnFolder(String folderId, UpdateSharedLinkOnFolderRequestBody requestBody, UpdateSharedLinkOnFolderQueryParams queryParams) {
        return this.updateSharedLinkOnFolder(folderId, requestBody, queryParams, new UpdateSharedLinkOnFolderHeaders());
    }

    public FolderFull updateSharedLinkOnFolder(String folderId, UpdateSharedLinkOnFolderQueryParams queryParams, UpdateSharedLinkOnFolderHeaders headers) {
        return this.updateSharedLinkOnFolder(folderId, new UpdateSharedLinkOnFolderRequestBody(), queryParams, headers);
    }

    public FolderFull updateSharedLinkOnFolder(String folderId, UpdateSharedLinkOnFolderRequestBody requestBody, UpdateSharedLinkOnFolderQueryParams queryParams, UpdateSharedLinkOnFolderHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "#update_shared_link"), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FolderFull.class);
    }

    public FolderFull removeSharedLinkFromFolder(String folderId, RemoveSharedLinkFromFolderQueryParams queryParams) {
        return this.removeSharedLinkFromFolder(folderId, new RemoveSharedLinkFromFolderRequestBody(), queryParams, new RemoveSharedLinkFromFolderHeaders());
    }

    public FolderFull removeSharedLinkFromFolder(String folderId, RemoveSharedLinkFromFolderRequestBody requestBody, RemoveSharedLinkFromFolderQueryParams queryParams) {
        return this.removeSharedLinkFromFolder(folderId, requestBody, queryParams, new RemoveSharedLinkFromFolderHeaders());
    }

    public FolderFull removeSharedLinkFromFolder(String folderId, RemoveSharedLinkFromFolderQueryParams queryParams, RemoveSharedLinkFromFolderHeaders headers) {
        return this.removeSharedLinkFromFolder(folderId, new RemoveSharedLinkFromFolderRequestBody(), queryParams, headers);
    }

    public FolderFull removeSharedLinkFromFolder(String folderId, RemoveSharedLinkFromFolderRequestBody requestBody, RemoveSharedLinkFromFolderQueryParams queryParams, RemoveSharedLinkFromFolderHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "#remove_shared_link"), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FolderFull.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public SharedLinksFoldersManager build() {
            return new SharedLinksFoldersManager(this);
        }
    }
}

