/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image.wms;

import com.bbn.openmap.image.wms.FeatureInfoResponse;
import com.bbn.openmap.image.wms.LayerFeatureInfoResponse;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFeatureInfoResponse
implements FeatureInfoResponse {
    private StringBuffer out;
    private String contentType;

    @Override
    public void setOutput(String contentType, StringBuffer out) {
        this.out = out;
        this.contentType = contentType;
        this.appendHeader();
    }

    @Override
    public void flush() {
        this.appendFooter();
    }

    @Override
    public Collection<String> getInfoFormats() {
        return Arrays.asList("text/html", "text/plain");
    }

    @Override
    public void output(LayerFeatureInfoResponse layerFeatureInfoResponse) {
        layerFeatureInfoResponse.output(this.contentType, this.out);
    }

    protected void write(String s) {
        this.out.append(s);
    }

    protected String getContentType() {
        return this.contentType;
    }

    protected void appendHeader() {
        if (this.getContentType().equals("text/html")) {
            this.write("<html><head>\n");
            this.write("<meta http-equiv=\"content-type\"\n");
            this.write("      content=\"text/html; charset=UTF-8\">\n");
            this.write("</head><body>\n");
        } else if (this.getContentType().equals("application/json")) {
            this.write("{\n");
            this.write("  \"type\": \"FeatureCollection\",\n");
            this.write("  \"features\": [\n");
        }
    }

    protected void appendFooter() {
        if (this.getContentType().equals("text/html")) {
            this.write("</body></html>");
        } else if (this.getContentType().equals("application/json")) {
            this.write("  ]\n");
            this.write("}\n");
        }
    }
}

