/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.BufferedMapBean;
import com.bbn.openmap.Environment;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.event.DefaultOverviewMouseMode;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.OverviewMapStatusListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.gui.OMToolComponent;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.layer.OverviewMapAreaLayer;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class OverviewMapHandler
extends OMToolComponent
implements ProjectionListener,
Serializable,
PropertyConsumer,
PropertyChangeListener,
ComponentListener {
    public static final String OverviewMapHandlerLayerProperty = "overviewLayers";
    public static final String ScaleFactorProperty = "overviewScaleFactor";
    public static final String ProjectionTypeProperty = "overviewProjectionType";
    public static final String MinScaleProperty = "overviewMinScale";
    public static final String MinScaleUomProperty = "overviewMinScaleUom";
    public static final String StatusLayerProperty = "overviewStatusLayer";
    public static final String ControlSourceMapProperty = "overviewControlSourceMap";
    public static final String BackgroundSlaveProperty = "backgroundSlave";
    public static final float defaultScaleFactor = 20.0f;
    public static final float defaultMinScale = 500000.0f;
    public static final Length defaultMinScaleUom = null;
    protected float scaleFactor;
    protected float minScale;
    protected Length minScaleUom;
    protected transient MapBean map;
    protected transient MapBean sourceMap;
    protected transient Proj projection;
    protected Layer statusLayer;
    protected transient ControlledMapSupport controlledMaps;
    protected MapMouseMode mmm;
    protected ActionListener overviewFrameActionListener = null;
    protected boolean controlSourceMap = true;
    public static final String defaultFrameTitle = "Overview Map";
    protected String frameTitle = "Overview Map";
    public static final String defaultKey = "overviewmaphandler";
    protected boolean backgroundSlave = true;
    public static final int INITIAL_WIDTH = 200;
    public static final int INITIAL_HEIGHT = 100;

    public OverviewMapHandler() {
        this.setKey(defaultKey);
        this.setLayout(new BorderLayout());
        this.createOverviewMap();
        this.projection = this.createStartingProjection(null);
        this.addComponentListener(this);
    }

    public OverviewMapHandler(Properties props) throws Exception {
        this(null, props);
    }

    public OverviewMapHandler(String prefix, Properties props) throws Exception {
        this();
        this.setProperties(prefix, props);
    }

    public OverviewMapHandler(MapBean srcMap, String prefix, Properties props) throws Exception {
        this(prefix, props);
        this.setSourceMap(srcMap);
    }

    protected void createOverviewMap() {
        MapBean.suppressCopyright = true;
        this.map = new BufferedMapBean();
        this.add((Component)this.map, "Center");
    }

    public void init(Properties props) throws Exception {
        this.setProperties(null, props);
    }

    public void init(String prefix, Properties props) throws Exception {
        this.setProperties(prefix, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.propertyPrefix = prefix;
        Vector<String> overviewLayers = PropUtils.parseSpacedMarkers(props.getProperty((prefix = PropUtils.getScopedPropertyPrefix(prefix)) + OverviewMapHandlerLayerProperty));
        if (overviewLayers.isEmpty()) {
            Debug.message("overview", "OverviewMapHandler:  created without layers!");
        }
        this.scaleFactor = PropUtils.floatFromProperties(props, prefix + ScaleFactorProperty, 20.0f);
        this.minScale = PropUtils.floatFromProperties(props, prefix + MinScaleProperty, 500000.0f);
        String uom = props.getProperty(prefix + MinScaleUomProperty);
        if (uom != null) {
            this.minScaleUom = Length.get(uom);
            this.setMinScale(this.minScale, this.minScaleUom);
        }
        this.backgroundSlave = PropUtils.booleanFromProperties(props, prefix + BackgroundSlaveProperty, this.backgroundSlave);
        this.setControlSourceMap(PropUtils.booleanFromProperties(props, prefix + ControlSourceMapProperty, this.controlSourceMap));
        String statusLayerName = props.getProperty(prefix + StatusLayerProperty + ".class");
        if (statusLayerName != null) {
            this.statusLayer = (Layer)ComponentFactory.create(statusLayerName, prefix + StatusLayerProperty, props);
            if (this.statusLayer == null) {
                Debug.error("OverviewMapHandler.setProperties: status layer not set.");
            }
        } else {
            this.statusLayer = new OverviewMapAreaLayer();
        }
        this.statusLayer.setProperties(prefix, props);
        this.projection = this.createStartingProjection(props.getProperty(prefix + ProjectionTypeProperty));
        this.setLayers(LayerHandler.getLayers(overviewLayers, overviewLayers, props));
    }

    protected ProjectionFactory getProjectionFactory() {
        if (this.sourceMap != null) {
            return this.sourceMap.getProjectionFactory();
        }
        return ProjectionFactory.loadDefaultProjections();
    }

    private Proj createStartingProjection(String projName) {
        ProjectionFactory projectionFactory = this.getProjectionFactory();
        Class<? extends Projection> projClass = projectionFactory.getProjClassForName(projName);
        if (projClass == null) {
            projClass = Mercator.class;
        }
        return (Proj)projectionFactory.makeProjection(projClass, (Point2D)new Point2D.Float(Environment.getFloat("openmap.Latitude", 0.0f), Environment.getFloat("openmap.Longitude", 0.0f)), Environment.getFloat("openmap.Scale", Float.POSITIVE_INFINITY) * this.scaleFactor, 200, 100);
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        StringBuffer layerList = new StringBuffer();
        Component[] comps = this.map.getComponents();
        int ncomponents = comps.length;
        for (int i = 0; i < ncomponents; ++i) {
            Layer layer = (Layer)comps[i];
            if (layer == this.statusLayer) continue;
            layerList.append(" ").append(layer.getPropertyPrefix());
            layer.getProperties(props);
        }
        props.put(prefix + OverviewMapHandlerLayerProperty, layerList.toString());
        props.put(prefix + ScaleFactorProperty, Float.toString(this.scaleFactor));
        props.put(prefix + ProjectionTypeProperty, this.map.getProjection().getName());
        props.put(prefix + MinScaleProperty, Float.toString(this.minScale));
        props.put(prefix + BackgroundSlaveProperty, new Boolean(this.backgroundSlave).toString());
        if (this.statusLayer != null) {
            props.put(prefix + StatusLayerProperty, this.statusLayer.getClass().getName());
            this.statusLayer.getProperties(props);
        }
        props.put(prefix + ControlSourceMapProperty, new Boolean(this.controlSourceMap).toString());
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put(OverviewMapHandlerLayerProperty, "Space separated list of marker names of layers to use as background on the overview map.");
        list.put(ScaleFactorProperty, "Multiplier reflecting the difference between the scale of the overview map and the source map (default is 20.0).");
        list.put(ProjectionTypeProperty, "Projection name to use for overview map (Default is mercator).");
        list.put(MinScaleProperty, "Minimum scale of overview map (Default is 500,000.0).");
        list.put(StatusLayerProperty, "Class name of layer to use as the active layer on the overview map, receiving mouse events (Default is com.bbn.openmap.layer.OverviewMapAreaLayer).");
        list.put(ControlSourceMapProperty, "Flag to have the source map controlled by gestures on the overview map (true/false, default is true).");
        list.put("overviewControlSourceMap.editor", "com.bbn.openmap.util.propertyEditor.TrueFalsePropertyEditor");
        list.put(BackgroundSlaveProperty, "Flag to have the map mimic any changes made to the source map's background (true/false, default is true).");
        list.put("backgroundSlave.editor", "com.bbn.openmap.util.propertyEditor.TrueFalsePropertyEditor");
        this.statusLayer.getPropertyInfo(list);
        return list;
    }

    public void setSourceMap(MapBean srcMap) {
        if (this.sourceMap != null) {
            this.removeControlledMap(this.sourceMap);
            this.sourceMap.removeProjectionListener(this);
            this.sourceMap.removePropertyChangeListener(this);
        }
        if (srcMap != null) {
            if (this.controlSourceMap) {
                this.addControlledMap(srcMap);
            }
            if (!this.getUseAsTool() && this.isVisible()) {
                srcMap.addProjectionListener(this);
            }
            srcMap.addPropertyChangeListener(this);
        }
        this.sourceMap = srcMap;
    }

    public MapBean getSourceMap() {
        return this.sourceMap;
    }

    public void setFrameTitle(String in_frameTitle) {
        this.frameTitle = in_frameTitle;
    }

    public String getFrameTitle() {
        return this.frameTitle;
    }

    public void setBackgroundSlave(boolean set) {
        this.backgroundSlave = set;
    }

    public boolean getBackgroundSlave() {
        return this.backgroundSlave;
    }

    public void setControlSourceMap(boolean value) {
        if (this.sourceMap != null) {
            if (value && !this.controlSourceMap) {
                this.addControlledMap(this.sourceMap);
            }
            if (!value && this.controlSourceMap) {
                this.removeControlledMap(this.sourceMap);
            }
        }
        this.controlSourceMap = value;
    }

    public boolean getControlSourceMap() {
        return this.controlSourceMap;
    }

    public void setLayers(Layer[] layers) {
        this.map.setLayers(new LayerEvent(this, 402, new Layer[0]));
        if (this.statusLayer != null) {
            this.map.add(this.statusLayer);
        }
        this.map.setLayers(new LayerEvent(this, 400, layers));
    }

    public void projectionChanged(ProjectionEvent projEvent) {
        Projection proj;
        if (this.sourceMap == null) {
            this.sourceMap = (MapBean)projEvent.getSource();
            this.map.setBckgrnd(this.sourceMap.getBckgrnd());
        }
        if ((proj = projEvent.getProjection()) == null) {
            return;
        }
        if (this.statusLayer instanceof OverviewMapStatusListener) {
            ((OverviewMapStatusListener)((Object)this.statusLayer)).setSourceMapProjection(proj);
        }
        float newScale = proj.getScale() * this.scaleFactor;
        Projection sourceProj = this.sourceMap.getProjection();
        if ((newScale *= (float)sourceProj.getWidth() / (float)this.projection.getWidth()) < this.minScale) {
            newScale = this.minScale;
        }
        if (this.projection != null) {
            this.projection.setScale(newScale);
            this.projection.setCenter((Point2D)proj.getCenter());
            this.map.setProjection(this.projection);
        }
    }

    public void setMouseMode(MapMouseMode ammm) {
        if (ammm == null) {
            this.deactivateMouseMode();
        }
        this.mmm = ammm;
        this.activateMouseMode();
    }

    public MapMouseMode getMouseMode() {
        return this.mmm;
    }

    public void activateMouseMode() {
        if (this.mmm == null) {
            this.mmm = new DefaultOverviewMouseMode(this);
        }
        if (this.map != null) {
            this.map.addMouseListener(this.mmm);
            this.map.addMouseMotionListener(this.mmm);
        }
    }

    public void deactivateMouseMode() {
        if (this.mmm != null) {
            this.map.removeMouseListener(this.mmm);
            this.map.removeMouseMotionListener(this.mmm);
        }
    }

    public void addControlledMap(MapBean l) {
        if (l != null) {
            if (this.controlledMaps == null) {
                this.controlledMaps = new ControlledMapSupport(this.map);
                this.activateMouseMode();
            }
            this.controlledMaps.add(l);
        }
    }

    public void removeControlledMap(MapBean l) {
        if (this.controlledMaps != null) {
            this.controlledMaps.remove(l);
            if (this.controlledMaps.isEmpty()) {
                this.deactivateMouseMode();
            }
        }
    }

    public MapBean getMap() {
        return this.map;
    }

    public void setMap(MapBean map) {
        if (map != null) {
            this.remove(map);
        }
        this.map = map;
        this.add((Component)map, "Center");
    }

    public ControlledMapSupport getControlledMapListeners() {
        return this.controlledMaps;
    }

    public void setControlledMapListeners(ControlledMapSupport list) {
        this.controlledMaps = list;
    }

    public Layer getStatusLayer() {
        return this.statusLayer;
    }

    public void setStatusLayer(Layer layer) {
        this.statusLayer = layer;
    }

    public void setScaleFactor(float setting) {
        this.scaleFactor = setting;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void setProjection(Proj proj) {
        this.projection = proj;
    }

    public Proj getProjection() {
        return this.projection;
    }

    public void setMinScale(float setting) {
        if (setting > 0.0f) {
            this.minScale = setting;
        }
    }

    public void setMinScale(float width, Length uom) {
        if (width > 0.0f) {
            Projection p = this.map.getProjection();
            Length projUom = p.getUcuom();
            if (projUom == null) {
                projUom = Length.METER;
            }
            float radius = uom.toRadians(width) / 2.0f;
            Object center = p.getCenter();
            Point2D.Double left = new Point2D.Double(((Point2D)center).getX(), ((Point2D)center).getY());
            Point2D.Double right = new Point2D.Double(((Point2D)center).getX(), ((Point2D)center).getY());
            double newLeftX = projUom.fromRadians(projUom.toRadians(((Point2D)left).getX()) - (double)radius);
            double newRightX = projUom.fromRadians(projUom.toRadians(((Point2D)right).getX()) + (double)radius);
            ((Point2D)left).setLocation(newLeftX, ((Point2D)left).getY());
            ((Point2D)right).setLocation(newRightX, ((Point2D)right).getY());
            this.minScale = ProjMath.getScale(left, right, p);
        }
    }

    public float getMinScale() {
        return this.minScale;
    }

    public void componentShown(ComponentEvent e) {
        if (this.sourceMap != null) {
            this.sourceMap.addProjectionListener(this);
        }
    }

    public void componentHidden(ComponentEvent e) {
        if (this.sourceMap != null) {
            this.sourceMap.removeProjectionListener(this);
        }
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public ActionListener getOverviewFrameActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WindowSupport ws = OverviewMapHandler.this.getWindowSupport();
                MapHandler mh = (MapHandler)OverviewMapHandler.this.getBeanContext();
                Frame frame = null;
                if (mh != null) {
                    frame = mh.get(Frame.class);
                }
                if (ws == null) {
                    ws = new WindowSupport((Component)OverviewMapHandler.this, new WindowSupport.Dlg(frame, OverviewMapHandler.defaultFrameTitle));
                    OverviewMapHandler.this.setWindowSupport(ws);
                }
                int w = 200;
                int h = 100;
                Dimension dim = ws.getComponentSize();
                if (OverviewMapHandler.this.map != null && dim != null) {
                    w = (int)dim.getWidth();
                    h = (int)dim.getHeight();
                }
                ws.displayInWindow(frame, -1, -1, w, h);
            }
        };
    }

    public Container getFace() {
        JButton b = null;
        if (this.getUseAsTool()) {
            URL url = this.getClass().getResource("overview.gif");
            b = new JButton(new ImageIcon(url, this.frameTitle));
            b.setToolTipText(this.frameTitle);
            b.setMargin(new Insets(0, 0, 0, 0));
            b.addActionListener(this.getOverviewFrameActionListener());
            b.setBorderPainted(false);
        }
        return b;
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapBean) {
            Debug.message("overview", "OverviewMapHandler found a MapBean object");
            this.setSourceMap((MapBean)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapBean && this.getSourceMap() == (MapBean)someObj) {
            Debug.message("overview", "OverviewMapHandler: removing source MapBean");
            this.setSourceMap(null);
        }
        if (someObj.equals(this)) {
            this.dispose();
        }
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName() == "MapBean.background" && this.backgroundSlave) {
            this.map.setBckgrnd((Paint)pce.getNewValue());
        }
    }

    public void dispose() {
        this.controlledMaps.clear();
        this.map.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ControlledMapSupport
    extends ListenerSupport<MapBean> {
        public ControlledMapSupport(Object aSource) {
            super(aSource);
        }

        public void setCenter(Point2D llp) {
            for (MapBean mapBean : this) {
                mapBean.setCenter(llp);
            }
        }

        public void setScale(float scale) {
            for (MapBean mapBean : this) {
                mapBean.setScale(scale);
            }
        }
    }
}

