/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.util;

import com.basho.riak.client.RiakConfig;
import com.basho.riak.client.RiakObject;
import com.basho.riak.client.request.RequestMeta;
import com.basho.riak.client.response.DefaultHttpResponse;
import com.basho.riak.client.response.HttpResponse;
import com.basho.riak.client.response.RiakExceptionHandler;
import com.basho.riak.client.response.RiakIORuntimeException;
import com.basho.riak.client.response.RiakResponseRuntimeException;
import com.basho.riak.client.response.StreamHandler;
import com.basho.riak.client.util.ClientUtils;
import com.basho.riak.client.util.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.json.JSONObject;

public class ClientHelper {
    private RiakConfig config;
    private HttpClient httpClient;
    private String clientId = null;
    private RiakExceptionHandler exceptionHandler = null;

    public ClientHelper(RiakConfig config, String clientId) {
        this.config = config;
        this.httpClient = ClientUtils.newHttpClient(config);
        this.setClientId(clientId);
    }

    void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public byte[] getClientId() {
        try {
            return Base64.decodeBase64((byte[])this.clientId.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 support required in JVM");
        }
    }

    public void setClientId(String clientId) {
        this.clientId = clientId != null ? ClientUtils.encodeClientId(clientId) : ClientUtils.randomClientId();
    }

    public HttpResponse setBucketSchema(String bucket, JSONObject schema, RequestMeta meta) {
        if (schema == null) {
            schema = new JSONObject();
        }
        if (meta == null) {
            meta = new RequestMeta();
        }
        meta.setHeader("accept", "application/json");
        PutMethod put = new PutMethod(ClientUtils.makeURI(this.config, bucket));
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(schema.toString().getBytes(), "application/json"));
        return this.executeMethod(bucket, null, (HttpMethod)put, meta);
    }

    public HttpResponse getBucketSchema(String bucket, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getQueryParam("keys") == null) {
            meta.setQueryParam("keys", "false");
        }
        return this.listBucket(bucket, meta, false);
    }

    public HttpResponse listBucket(String bucket, RequestMeta meta, boolean streamResponse) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (streamResponse && meta.getQueryParam("keys") == null) {
            meta.setQueryParam("keys", "stream");
        }
        if (meta.getHeader("content-type") == null) {
            meta.setHeader("content-type", "application/json");
        }
        if (meta.getHeader("accept") == null) {
            meta.setHeader("accept", "application/json");
        }
        GetMethod get = new GetMethod(ClientUtils.makeURI(this.config, bucket));
        return this.executeMethod(bucket, null, (HttpMethod)get, meta, streamResponse);
    }

    public HttpResponse store(RiakObject object, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getClientId() == null) {
            meta.setClientId(this.clientId);
        }
        if (meta.getHeader("connection") == null) {
            meta.setHeader("connection", "keep-alive");
        }
        String bucket = object.getBucket();
        String key = object.getKey();
        String url = ClientUtils.makeURI(this.config, bucket, key);
        PutMethod put = new PutMethod(url);
        object.writeToHttpMethod((HttpMethod)put);
        return this.executeMethod(bucket, key, (HttpMethod)put, meta);
    }

    public HttpResponse fetchMeta(String bucket, String key, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getQueryParam("r") == null) {
            meta.setQueryParam("r", Constants.DEFAULT_R.toString());
        }
        HeadMethod head = new HeadMethod(ClientUtils.makeURI(this.config, bucket, key));
        return this.executeMethod(bucket, key, (HttpMethod)head, meta);
    }

    public HttpResponse fetch(String bucket, String key, RequestMeta meta, boolean streamResponse) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getQueryParam("r") == null) {
            meta.setQueryParam("r", Constants.DEFAULT_R.toString());
        }
        GetMethod get = new GetMethod(ClientUtils.makeURI(this.config, bucket, key));
        return this.executeMethod(bucket, key, (HttpMethod)get, meta, streamResponse);
    }

    public HttpResponse fetch(String bucket, String key, RequestMeta meta) {
        return this.fetch(bucket, key, meta, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stream(String bucket, String key, StreamHandler handler, RequestMeta meta) throws IOException {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getQueryParam("r") == null) {
            meta.setQueryParam("r", Constants.DEFAULT_R.toString());
        }
        GetMethod get = new GetMethod(ClientUtils.makeURI(this.config, bucket, key));
        try {
            int status = this.httpClient.executeMethod((HttpMethod)get);
            if (handler == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = handler.process(bucket, key, status, ClientUtils.asHeaderMap(get.getResponseHeaders()), get.getResponseBodyAsStream(), (HttpMethod)get);
            return bl;
        }
        finally {
            get.releaseConnection();
        }
    }

    public HttpResponse delete(String bucket, String key, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        String url = ClientUtils.makeURI(this.config, bucket, key);
        DeleteMethod delete = new DeleteMethod(url);
        return this.executeMethod(bucket, key, (HttpMethod)delete, meta);
    }

    public HttpResponse walk(String bucket, String key, String walkSpec, RequestMeta meta) {
        GetMethod get = new GetMethod(ClientUtils.makeURI(this.config, bucket, key, walkSpec));
        return this.executeMethod(bucket, key, (HttpMethod)get, meta);
    }

    public HttpResponse mapReduce(String job, RequestMeta meta) {
        PostMethod post = new PostMethod(this.config.getMapReduceUrl());
        try {
            post.setRequestEntity((RequestEntity)new StringRequestEntity(job, "application/json", null));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("StringRequestEntity should always support no charset", e);
        }
        return this.executeMethod(null, null, (HttpMethod)post, meta);
    }

    public RiakExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(RiakExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public HttpResponse toss(RiakIORuntimeException e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
            return new DefaultHttpResponse(null, null, 0, null, null, null, null);
        }
        throw e;
    }

    public HttpResponse toss(RiakResponseRuntimeException e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
            return new DefaultHttpResponse(null, null, 0, null, null, null, null);
        }
        throw e;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public RiakConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpResponse executeMethod(String bucket, String key, HttpMethod httpMethod, RequestMeta meta, boolean streamResponse) {
        if (meta != null) {
            Map<String, String> headers = meta.getHeaders();
            for (String header : headers.keySet()) {
                httpMethod.setRequestHeader(header, headers.get(header));
            }
            String queryParams = meta.getQueryParams();
            if (queryParams != null && queryParams.length() != 0) {
                String currentQuery = httpMethod.getQueryString();
                if (currentQuery != null && currentQuery.length() != 0) {
                    httpMethod.setQueryString(currentQuery + "&" + queryParams);
                } else {
                    httpMethod.setQueryString(queryParams);
                }
            }
        }
        try {
            this.httpClient.executeMethod(httpMethod);
            int status = 0;
            if (httpMethod.getStatusLine() != null) {
                status = httpMethod.getStatusCode();
            }
            Map<String, String> headers = ClientUtils.asHeaderMap(httpMethod.getResponseHeaders());
            byte[] body = null;
            InputStream stream = null;
            if (streamResponse) {
                stream = httpMethod.getResponseBodyAsStream();
            } else {
                body = httpMethod.getResponseBody();
            }
            DefaultHttpResponse defaultHttpResponse = new DefaultHttpResponse(bucket, key, status, headers, body, stream, httpMethod);
            return defaultHttpResponse;
        }
        catch (IOException e) {
            HttpResponse httpResponse = this.toss(new RiakIORuntimeException(e));
            return httpResponse;
        }
        finally {
            if (!streamResponse) {
                httpMethod.releaseConnection();
            }
        }
    }

    HttpResponse executeMethod(String bucket, String key, HttpMethod httpMethod, RequestMeta meta) {
        return this.executeMethod(bucket, key, httpMethod, meta, false);
    }
}

