/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.request;

import com.basho.riak.client.RiakClient;
import com.basho.riak.client.RiakObject;
import com.basho.riak.client.mapreduce.LinkFunction;
import com.basho.riak.client.mapreduce.MapReduceFunction;
import com.basho.riak.client.request.RequestMeta;
import com.basho.riak.client.response.MapReduceResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapReduceBuilder {
    private String bucket = null;
    private Map<String, Set<String>> objects = new HashMap<String, Set<String>>();
    private List<MapReducePhase> phases = new LinkedList<MapReducePhase>();
    private int timeout = -1;
    private RiakClient riak = null;

    public MapReduceBuilder(RiakClient riak) {
        this.riak = riak;
    }

    public MapReduceBuilder() {
    }

    public RiakClient getRiakClient() {
        return this.riak;
    }

    public MapReduceBuilder setRiakClient(RiakClient client) {
        this.riak = client;
        return this;
    }

    public String getBucket() {
        return this.bucket;
    }

    public MapReduceBuilder setBucket(String newBucket) {
        if (this.objects.size() > 0) {
            throw new IllegalStateException("Cannot map/reduce over buckets and objects");
        }
        this.bucket = newBucket;
        return this;
    }

    public void addRiakObject(String bucket, String key) {
        if (this.bucket != null) {
            throw new IllegalStateException("Cannot map/reduce over buckets and objects");
        }
        Set<String> keys = this.objects.get(bucket);
        if (keys == null) {
            keys = new LinkedHashSet<String>();
            this.objects.put(bucket, keys);
        }
        keys.add(key);
    }

    public void removeRiakObject(String bucket, String key) {
        Set<String> keys = this.objects.get(bucket);
        if (keys != null) {
            keys.remove(key);
            if (keys.size() == 0) {
                this.objects.remove(bucket);
            }
        }
    }

    public Map<String, Set<String>> getRiakObjects() {
        return new HashMap<String, Set<String>>(this.objects);
    }

    public MapReduceBuilder setRiakObjects(Map<String, Set<String>> objects) {
        if (this.bucket != null) {
            throw new IllegalStateException("Cannot map/reduce over buckets and objects");
        }
        if (objects == null) {
            this.clearRiakObjects();
        } else {
            this.objects = new HashMap<String, Set<String>>(objects);
        }
        return this;
    }

    public MapReduceBuilder setRiakObjects(Collection<RiakObject> objects) {
        if (this.bucket != null) {
            throw new IllegalStateException("Cannot map/reduce over buckets and objects");
        }
        this.clearRiakObjects();
        if (objects != null) {
            for (RiakObject o : objects) {
                this.addRiakObject(o.getBucket(), o.getKey());
            }
        }
        return this;
    }

    public void clearRiakObjects() {
        this.objects.clear();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public MapReduceBuilder map(MapReduceFunction function, boolean keep) {
        this.addPhase(Types.MAP, function, keep);
        return this;
    }

    public MapReduceBuilder reduce(MapReduceFunction function, boolean keep) {
        this.addPhase(Types.REDUCE, function, keep);
        return this;
    }

    public MapReduceBuilder link(String bucket, boolean keep) {
        this.addPhase(Types.LINK, new LinkFunction(bucket), keep);
        return this;
    }

    public MapReduceBuilder link(String bucket, String tag, boolean keep) {
        this.addPhase(Types.LINK, new LinkFunction(bucket, tag), keep);
        return this;
    }

    public MapReduceResponse submit(RequestMeta meta) {
        if (this.riak == null) {
            throw new IllegalStateException("Cannot perform map reduce without a RiakClient");
        }
        return this.riak.mapReduce(this.toJSON().toString(), meta);
    }

    public MapReduceResponse submit() throws JSONException {
        return this.submit(null);
    }

    public JSONObject toJSON() {
        JSONObject job = new JSONObject();
        JSONArray query = new JSONArray();
        for (MapReducePhase phase : this.phases) {
            this.renderPhase(phase, query);
        }
        this.buildInputs(job);
        try {
            job.put("query", query);
        }
        catch (JSONException e) {
            throw new RuntimeException("Can always map a string to a valid JSONArray");
        }
        if (this.timeout > 0) {
            try {
                job.put("timeout", this.timeout);
            }
            catch (JSONException e) {
                throw new RuntimeException("Can always map a string to an int");
            }
        }
        return job;
    }

    private MapReduceBuilder addPhase(Types phaseType, MapReduceFunction function, boolean keep) {
        MapReducePhase phase = new MapReducePhase();
        phase.type = phaseType;
        phase.function = function;
        phase.keep = keep;
        this.phases.add(phase);
        return this;
    }

    private void buildInputs(JSONObject job) {
        if (this.bucket != null) {
            try {
                job.put("inputs", this.bucket);
            }
            catch (JSONException e) {
                throw new RuntimeException("Can always map a string to a string");
            }
        }
        JSONArray inputs = new JSONArray();
        for (String bucket : this.objects.keySet()) {
            Set<String> keys = this.objects.get(bucket);
            for (String key : keys) {
                String[] pair = new String[]{bucket, key};
                inputs.put(pair);
            }
        }
        try {
            job.put("inputs", inputs);
        }
        catch (JSONException e) {
            throw new RuntimeException("Can always map a string to a valid JSONArray");
        }
    }

    private void renderPhase(MapReducePhase phase, JSONArray query) {
        JSONObject phaseJson = new JSONObject();
        JSONObject functionJson = phase.function.toJson();
        try {
            functionJson.put("keep", phase.keep);
        }
        catch (JSONException e) {
            throw new RuntimeException("Can always map a string to a boolean");
        }
        String type = null;
        switch (phase.type) {
            case MAP: {
                type = "map";
                break;
            }
            case REDUCE: {
                type = "reduce";
                break;
            }
            case LINK: {
                type = "link";
            }
        }
        try {
            phaseJson.put(type, functionJson);
        }
        catch (JSONException e) {
            throw new RuntimeException("Can always map a string to a valid JSONObject");
        }
        query.put(phaseJson);
    }

    private class MapReducePhase {
        Types type;
        MapReduceFunction function;
        boolean keep;

        private MapReducePhase() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Types {
        MAP,
        REDUCE,
        LINK;

    }
}

