/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.http.policy.ArmChallengeAuthenticationPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.fluent.ApplicationInsightsManagementClient;
import com.azure.resourcemanager.applicationinsights.implementation.AnalyticsItemsImpl;
import com.azure.resourcemanager.applicationinsights.implementation.AnnotationsImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ApiKeysImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsManagementClientBuilder;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentAvailableFeaturesImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentCurrentBillingFeaturesImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentFeatureCapabilitiesImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentLinkedStorageAccountsOperationsImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentQuotaStatusImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentsImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ExportConfigurationsImpl;
import com.azure.resourcemanager.applicationinsights.implementation.FavoritesImpl;
import com.azure.resourcemanager.applicationinsights.implementation.LiveTokensImpl;
import com.azure.resourcemanager.applicationinsights.implementation.MyWorkbooksImpl;
import com.azure.resourcemanager.applicationinsights.implementation.OperationsImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ProactiveDetectionConfigurationsImpl;
import com.azure.resourcemanager.applicationinsights.implementation.WebTestLocationsImpl;
import com.azure.resourcemanager.applicationinsights.implementation.WebTestsImpl;
import com.azure.resourcemanager.applicationinsights.implementation.WorkItemConfigurationsImpl;
import com.azure.resourcemanager.applicationinsights.implementation.WorkbookTemplatesImpl;
import com.azure.resourcemanager.applicationinsights.implementation.WorkbooksImpl;
import com.azure.resourcemanager.applicationinsights.models.AnalyticsItems;
import com.azure.resourcemanager.applicationinsights.models.Annotations;
import com.azure.resourcemanager.applicationinsights.models.ApiKeys;
import com.azure.resourcemanager.applicationinsights.models.ComponentAvailableFeatures;
import com.azure.resourcemanager.applicationinsights.models.ComponentCurrentBillingFeatures;
import com.azure.resourcemanager.applicationinsights.models.ComponentFeatureCapabilities;
import com.azure.resourcemanager.applicationinsights.models.ComponentLinkedStorageAccountsOperations;
import com.azure.resourcemanager.applicationinsights.models.ComponentQuotaStatus;
import com.azure.resourcemanager.applicationinsights.models.Components;
import com.azure.resourcemanager.applicationinsights.models.ExportConfigurations;
import com.azure.resourcemanager.applicationinsights.models.Favorites;
import com.azure.resourcemanager.applicationinsights.models.LiveTokens;
import com.azure.resourcemanager.applicationinsights.models.MyWorkbooks;
import com.azure.resourcemanager.applicationinsights.models.Operations;
import com.azure.resourcemanager.applicationinsights.models.ProactiveDetectionConfigurations;
import com.azure.resourcemanager.applicationinsights.models.WebTestLocations;
import com.azure.resourcemanager.applicationinsights.models.WebTests;
import com.azure.resourcemanager.applicationinsights.models.WorkItemConfigurations;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplates;
import com.azure.resourcemanager.applicationinsights.models.Workbooks;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ApplicationInsightsManager {
    private Operations operations;
    private Annotations annotations;
    private ApiKeys apiKeys;
    private ExportConfigurations exportConfigurations;
    private ComponentCurrentBillingFeatures componentCurrentBillingFeatures;
    private ComponentQuotaStatus componentQuotaStatus;
    private ComponentFeatureCapabilities componentFeatureCapabilities;
    private ComponentAvailableFeatures componentAvailableFeatures;
    private ProactiveDetectionConfigurations proactiveDetectionConfigurations;
    private WorkItemConfigurations workItemConfigurations;
    private Favorites favorites;
    private WebTestLocations webTestLocations;
    private WebTests webTests;
    private AnalyticsItems analyticsItems;
    private WorkbookTemplates workbookTemplates;
    private MyWorkbooks myWorkbooks;
    private Workbooks workbooks;
    private Components components;
    private ComponentLinkedStorageAccountsOperations componentLinkedStorageAccountsOperations;
    private LiveTokens liveTokens;
    private final ApplicationInsightsManagementClient clientObject;

    private ApplicationInsightsManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new ApplicationInsightsManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static ApplicationInsightsManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return ApplicationInsightsManager.configure().authenticate(credential, profile);
    }

    public static ApplicationInsightsManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new ApplicationInsightsManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public Annotations annotations() {
        if (this.annotations == null) {
            this.annotations = new AnnotationsImpl(this.clientObject.getAnnotations(), this);
        }
        return this.annotations;
    }

    public ApiKeys apiKeys() {
        if (this.apiKeys == null) {
            this.apiKeys = new ApiKeysImpl(this.clientObject.getApiKeys(), this);
        }
        return this.apiKeys;
    }

    public ExportConfigurations exportConfigurations() {
        if (this.exportConfigurations == null) {
            this.exportConfigurations = new ExportConfigurationsImpl(this.clientObject.getExportConfigurations(), this);
        }
        return this.exportConfigurations;
    }

    public ComponentCurrentBillingFeatures componentCurrentBillingFeatures() {
        if (this.componentCurrentBillingFeatures == null) {
            this.componentCurrentBillingFeatures = new ComponentCurrentBillingFeaturesImpl(this.clientObject.getComponentCurrentBillingFeatures(), this);
        }
        return this.componentCurrentBillingFeatures;
    }

    public ComponentQuotaStatus componentQuotaStatus() {
        if (this.componentQuotaStatus == null) {
            this.componentQuotaStatus = new ComponentQuotaStatusImpl(this.clientObject.getComponentQuotaStatus(), this);
        }
        return this.componentQuotaStatus;
    }

    public ComponentFeatureCapabilities componentFeatureCapabilities() {
        if (this.componentFeatureCapabilities == null) {
            this.componentFeatureCapabilities = new ComponentFeatureCapabilitiesImpl(this.clientObject.getComponentFeatureCapabilities(), this);
        }
        return this.componentFeatureCapabilities;
    }

    public ComponentAvailableFeatures componentAvailableFeatures() {
        if (this.componentAvailableFeatures == null) {
            this.componentAvailableFeatures = new ComponentAvailableFeaturesImpl(this.clientObject.getComponentAvailableFeatures(), this);
        }
        return this.componentAvailableFeatures;
    }

    public ProactiveDetectionConfigurations proactiveDetectionConfigurations() {
        if (this.proactiveDetectionConfigurations == null) {
            this.proactiveDetectionConfigurations = new ProactiveDetectionConfigurationsImpl(this.clientObject.getProactiveDetectionConfigurations(), this);
        }
        return this.proactiveDetectionConfigurations;
    }

    public WorkItemConfigurations workItemConfigurations() {
        if (this.workItemConfigurations == null) {
            this.workItemConfigurations = new WorkItemConfigurationsImpl(this.clientObject.getWorkItemConfigurations(), this);
        }
        return this.workItemConfigurations;
    }

    public Favorites favorites() {
        if (this.favorites == null) {
            this.favorites = new FavoritesImpl(this.clientObject.getFavorites(), this);
        }
        return this.favorites;
    }

    public WebTestLocations webTestLocations() {
        if (this.webTestLocations == null) {
            this.webTestLocations = new WebTestLocationsImpl(this.clientObject.getWebTestLocations(), this);
        }
        return this.webTestLocations;
    }

    public WebTests webTests() {
        if (this.webTests == null) {
            this.webTests = new WebTestsImpl(this.clientObject.getWebTests(), this);
        }
        return this.webTests;
    }

    public AnalyticsItems analyticsItems() {
        if (this.analyticsItems == null) {
            this.analyticsItems = new AnalyticsItemsImpl(this.clientObject.getAnalyticsItems(), this);
        }
        return this.analyticsItems;
    }

    public WorkbookTemplates workbookTemplates() {
        if (this.workbookTemplates == null) {
            this.workbookTemplates = new WorkbookTemplatesImpl(this.clientObject.getWorkbookTemplates(), this);
        }
        return this.workbookTemplates;
    }

    public MyWorkbooks myWorkbooks() {
        if (this.myWorkbooks == null) {
            this.myWorkbooks = new MyWorkbooksImpl(this.clientObject.getMyWorkbooks(), this);
        }
        return this.myWorkbooks;
    }

    public Workbooks workbooks() {
        if (this.workbooks == null) {
            this.workbooks = new WorkbooksImpl(this.clientObject.getWorkbooks(), this);
        }
        return this.workbooks;
    }

    public Components components() {
        if (this.components == null) {
            this.components = new ComponentsImpl(this.clientObject.getComponents(), this);
        }
        return this.components;
    }

    public ComponentLinkedStorageAccountsOperations componentLinkedStorageAccountsOperations() {
        if (this.componentLinkedStorageAccountsOperations == null) {
            this.componentLinkedStorageAccountsOperations = new ComponentLinkedStorageAccountsOperationsImpl(this.clientObject.getComponentLinkedStorageAccountsOperations(), this);
        }
        return this.componentLinkedStorageAccountsOperations;
    }

    public LiveTokens liveTokens() {
        if (this.liveTokens == null) {
            this.liveTokens = new LiveTokensImpl(this.clientObject.getLiveTokens(), this);
        }
        return this.liveTokens;
    }

    public ApplicationInsightsManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public ApplicationInsightsManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.applicationinsights").append("/").append("1.0.0-beta.5");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new ArmChallengeAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new ApplicationInsightsManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

