// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.tables.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.data.tables.models.TableSignedIdentifier;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * A wrapper around List&lt;TableSignedIdentifier&gt; which provides top-level metadata for serialization.
 */
public final class TableSignedIdentifierWrapper implements XmlSerializable<TableSignedIdentifierWrapper> {
    private final List<TableSignedIdentifier> signedIdentifiers;

    /**
     * Creates an instance of TableSignedIdentifierWrapper.
     * 
     * @param signedIdentifiers the list.
     */
    public TableSignedIdentifierWrapper(List<TableSignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
    }

    /**
     * Get the List&lt;TableSignedIdentifier&gt; contained in this wrapper.
     * 
     * @return the List&lt;TableSignedIdentifier&gt;.
     */
    public List<TableSignedIdentifier> items() {
        return signedIdentifiers;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SignedIdentifiers" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (signedIdentifiers != null) {
            for (TableSignedIdentifier element : signedIdentifiers) {
                xmlWriter.writeXml(element, "SignedIdentifier");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static TableSignedIdentifierWrapper fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    public static TableSignedIdentifierWrapper fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SignedIdentifiers" : rootElementName;
        return xmlReader.readObject(rootElementName, reader -> {
            List<TableSignedIdentifier> items = null;

            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("SignedIdentifier".equals(elementName.getLocalPart())) {
                    if (items == null) {
                        items = new ArrayList<>();
                    }

                    items.add(TableSignedIdentifier.fromXml(reader));
                } else {
                    reader.nextElement();
                }
            }
            return new TableSignedIdentifierWrapper(items);
        });
    }
}
