/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceExistsException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingPage;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingFields;
import com.azure.data.appconfiguration.models.SettingSelector;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ConfigurationClientImpl {
    private static final String ETAG_ANY = "*";
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    private static final String APP_CONFIG_TRACING_NAMESPACE_VALUE = "Microsoft.AppConfiguration";
    private final ConfigurationService service;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final ClientLogger logger = new ClientLogger(ConfigurationClientImpl.class);

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public ConfigurationClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.service = (ConfigurationService)RestProxy.create(ConfigurationService.class, (HttpPipeline)this.getHttpPipeline(), (SerializerAdapter)this.getSerializerAdapter());
    }

    public Mono<Response<ConfigurationSetting>> addConfigurationSettingWithResponseAsync(ConfigurationSetting setting, Context context) {
        this.validateSetting(setting);
        context = context == null ? Context.NONE : context;
        return this.service.setKeyAsync(this.endpoint, setting.getKey(), setting.getLabel(), this.getApiVersion(), setting, null, this.getETagValue(ETAG_ANY), context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.verbose("Adding ConfigurationSetting - {}", new Object[]{setting})).doOnSuccess(response -> this.logger.verbose("Added ConfigurationSetting - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to add ConfigurationSetting - {}", new Object[]{setting, error}));
    }

    public Response<ConfigurationSetting> addConfigurationSettingWithResponse(ConfigurationSetting setting, Context context) {
        this.validateSetting(setting);
        context = context == null ? Context.NONE : context;
        return this.service.setKey(this.endpoint, setting.getKey(), setting.getLabel(), this.getApiVersion(), setting, null, this.getETagValue(ETAG_ANY), context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE).addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true));
    }

    public Mono<Response<ConfigurationSetting>> setConfigurationSettingWithResponseAsync(ConfigurationSetting setting, boolean ifUnchanged, Context context) {
        this.validateSetting(setting);
        context = context == null ? Context.NONE : context;
        String ifMatchETag = ifUnchanged ? this.getETagValue(setting.getETag()) : null;
        return this.service.setKeyAsync(this.getEndpoint(), setting.getKey(), setting.getLabel(), this.getApiVersion(), setting, ifMatchETag, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.verbose("Setting ConfigurationSetting - {}", new Object[]{setting})).doOnSuccess(response -> this.logger.verbose("Set ConfigurationSetting - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to set ConfigurationSetting - {}", new Object[]{setting, error}));
    }

    public Response<ConfigurationSetting> setConfigurationSettingWithResponse(ConfigurationSetting setting, boolean ifUnchanged, Context context) {
        this.validateSetting(setting);
        context = context == null ? Context.NONE : context;
        String ifMatchETag = ifUnchanged ? this.getETagValue(setting.getETag()) : null;
        return this.service.setKey(this.getEndpoint(), setting.getKey(), setting.getLabel(), this.getApiVersion(), setting, ifMatchETag, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE).addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true));
    }

    public Mono<Response<ConfigurationSetting>> getConfigurationSettingWithResponseAsync(ConfigurationSetting setting, OffsetDateTime acceptDateTime, boolean onlyIfChanged, Context context) {
        this.validateSetting(setting);
        context = context == null ? Context.NONE : context;
        String ifNoneMatchETag = onlyIfChanged ? this.getETagValue(setting.getETag()) : null;
        return this.service.getKeyValueAsync(this.getEndpoint(), setting.getKey(), setting.getLabel(), this.getApiVersion(), null, acceptDateTime == null ? null : acceptDateTime.toString(), null, ifNoneMatchETag, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).onErrorResume(HttpResponseException.class, throwable -> {
            HttpResponseException e = (HttpResponseException)throwable;
            HttpResponse httpResponse = e.getResponse();
            if (httpResponse.getStatusCode() == 304) {
                return Mono.just((Object)new ResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null, null));
            }
            return Mono.error((Throwable)throwable);
        }).doOnSubscribe(ignoredValue -> this.logger.verbose("Retrieving ConfigurationSetting - {}", new Object[]{setting})).doOnSuccess(response -> this.logger.verbose("Retrieved ConfigurationSetting - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to get ConfigurationSetting - {}", new Object[]{setting, error}));
    }

    public Response<ConfigurationSetting> getConfigurationSettingWithResponse(ConfigurationSetting setting, OffsetDateTime acceptDateTime, boolean onlyIfChanged, Context context) {
        this.validateSetting(setting);
        context = context == null ? Context.NONE : context;
        String ifNoneMatchETag = onlyIfChanged ? this.getETagValue(setting.getETag()) : null;
        try {
            return this.service.getKeyValue(this.getEndpoint(), setting.getKey(), setting.getLabel(), this.getApiVersion(), null, acceptDateTime == null ? null : acceptDateTime.toString(), null, ifNoneMatchETag, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE).addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true));
        }
        catch (HttpResponseException ex) {
            HttpResponse httpResponse = ex.getResponse();
            if (httpResponse.getStatusCode() == 304) {
                return new ResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null, null);
            }
            throw this.logger.logExceptionAsError((RuntimeException)((Object)ex));
        }
    }

    public Mono<Response<ConfigurationSetting>> deleteConfigurationSettingWithResponseAsync(ConfigurationSetting setting, boolean ifUnchanged, Context context) {
        this.validateSetting(setting);
        context = context == null ? Context.NONE : context;
        String ifMatchETag = ifUnchanged ? this.getETagValue(setting.getETag()) : null;
        return this.service.deleteAsync(this.getEndpoint(), setting.getKey(), setting.getLabel(), this.getApiVersion(), ifMatchETag, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.verbose("Deleting ConfigurationSetting - {}", new Object[]{setting})).doOnSuccess(response -> this.logger.verbose("Deleted ConfigurationSetting - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to delete ConfigurationSetting - {}", new Object[]{setting, error}));
    }

    public Response<ConfigurationSetting> deleteConfigurationSettingWithResponse(ConfigurationSetting setting, boolean ifUnchanged, Context context) {
        this.validateSetting(setting);
        context = context == null ? Context.NONE : context;
        String ifMatchETag = ifUnchanged ? this.getETagValue(setting.getETag()) : null;
        return this.service.delete(this.getEndpoint(), setting.getKey(), setting.getLabel(), this.getApiVersion(), ifMatchETag, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE).addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true));
    }

    public Mono<Response<ConfigurationSetting>> setReadOnlyWithResponseAsync(ConfigurationSetting setting, boolean isReadOnly, Context context) {
        this.validateSetting(setting);
        Context context2 = context = context == null ? Context.NONE : context;
        if (isReadOnly) {
            return this.service.lockKeyValueAsync(this.getEndpoint(), setting.getKey(), setting.getLabel(), this.getApiVersion(), null, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.verbose("Setting read only ConfigurationSetting - {}", new Object[]{setting})).doOnSuccess(response -> this.logger.verbose("Set read only ConfigurationSetting - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to set read only ConfigurationSetting - {}", new Object[]{setting, error}));
        }
        return this.service.unlockKeyValueAsync(this.getEndpoint(), setting.getKey(), setting.getLabel(), this.getApiVersion(), null, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.verbose("Clearing read only ConfigurationSetting - {}", new Object[]{setting})).doOnSuccess(response -> this.logger.verbose("Cleared read only ConfigurationSetting - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to clear read only ConfigurationSetting - {}", new Object[]{setting, error}));
    }

    public Response<ConfigurationSetting> setReadOnlyWithResponse(ConfigurationSetting setting, boolean isReadOnly, Context context) {
        this.validateSetting(setting);
        Context context2 = context = context == null ? Context.NONE : context;
        if (isReadOnly) {
            return this.service.lockKeyValue(this.getEndpoint(), setting.getKey(), setting.getLabel(), this.getApiVersion(), null, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE).addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true));
        }
        return this.service.unlockKeyValue(this.getEndpoint(), setting.getKey(), setting.getLabel(), this.getApiVersion(), null, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE).addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true));
    }

    public PagedFlux<ConfigurationSetting> listConfigurationSettingsAsync(SettingSelector selector) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listConfigurationSettingsSinglePageAsync(selector, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listConfigurationSettingsNextPageAsync((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    public PagedIterable<ConfigurationSetting> listConfigurationSettings(SettingSelector selector, Context context) {
        return new PagedIterable(() -> this.listConfigurationSettingsSinglePage(selector, context), continuationToken -> this.listConfigurationSettingsNextPage((String)continuationToken, context));
    }

    public PagedFlux<ConfigurationSetting> listRevisionsAsync(SettingSelector selector) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listRevisionsFirstPageAsync(selector, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listRevisionsNextPageAsync((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    public PagedIterable<ConfigurationSetting> listRevisions(SettingSelector selector, Context context) {
        return new PagedIterable(() -> this.listRevisionsFirstPage(selector, context), continuationToken -> this.listRevisionsNextPage((String)continuationToken, context));
    }

    private void validateSetting(ConfigurationSetting setting) {
        Objects.requireNonNull(setting);
        if (setting.getKey() == null) {
            throw new IllegalArgumentException("Parameter 'key' is required and cannot be null.");
        }
    }

    private String getETagValue(String etag) {
        return etag == null || ETAG_ANY.equals(etag) ? etag : "\"" + etag + "\"";
    }

    private Flux<ConfigurationSetting> listConfigurationSettingsAsync(String nextPageLink, Context context) {
        Mono result = this.service.listKeyValuesAsync(this.getEndpoint(), nextPageLink, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error}));
        return result.flatMapMany(r -> this.extractAndFetchConfigurationSettings((PagedResponse<ConfigurationSetting>)r, context));
    }

    private Publisher<ConfigurationSetting> extractAndFetchConfigurationSettings(PagedResponse<ConfigurationSetting> page, Context context) {
        return CoreUtils.extractAndFetch(page, (Context)context, this::listConfigurationSettingsAsync);
    }

    private Mono<PagedResponse<ConfigurationSetting>> listConfigurationSettingsSinglePageAsync(SettingSelector selector, Context context) {
        try {
            if (selector == null) {
                return this.service.listKeyValuesAsync(this.getEndpoint(), null, null, this.getApiVersion(), null, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.verbose("Listing all ConfigurationSettings")).doOnSuccess(response -> this.logger.verbose("Listed all ConfigurationSettings")).doOnError(error -> this.logger.warning("Failed to list all ConfigurationSetting", new Object[]{error}));
            }
            String fields = CoreUtils.arrayToString((Object[])selector.getFields(), SettingFields::toStringMapper);
            String keyFilter = selector.getKeyFilter();
            String labelFilter = selector.getLabelFilter();
            return this.service.listKeyValuesAsync(this.getEndpoint(), keyFilter, labelFilter, this.getApiVersion(), fields, selector.getAcceptDateTime(), context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.verbose("Listing ConfigurationSettings - {}", new Object[]{selector})).doOnSuccess(response -> this.logger.verbose("Listed ConfigurationSettings - {}", new Object[]{selector})).doOnError(error -> this.logger.warning("Failed to list ConfigurationSetting - {}", new Object[]{selector, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<ConfigurationSetting>> listConfigurationSettingsNextPageAsync(String continuationToken, Context context) {
        try {
            if (continuationToken == null || continuationToken.isEmpty()) {
                return Mono.empty();
            }
            return this.service.listKeyValuesAsync(this.getEndpoint(), continuationToken, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.verbose("Retrieving the next listing page - Page {}", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Retrieved the next listing page - Page {}", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private PagedResponse<ConfigurationSetting> listConfigurationSettingsSinglePage(SettingSelector selector, Context context) {
        if (selector == null) {
            return this.service.listKeyValues(this.getEndpoint(), null, null, this.getApiVersion(), null, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE));
        }
        String fields = CoreUtils.arrayToString((Object[])selector.getFields(), SettingFields::toStringMapper);
        String keyFilter = selector.getKeyFilter();
        String labelFilter = selector.getLabelFilter();
        return this.service.listKeyValues(this.getEndpoint(), keyFilter, labelFilter, this.getApiVersion(), fields, selector.getAcceptDateTime(), context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE));
    }

    private PagedResponse<ConfigurationSetting> listConfigurationSettingsNextPage(String continuationToken, Context context) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return null;
        }
        return this.service.listKeyValues(this.getEndpoint(), continuationToken, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE));
    }

    private Mono<PagedResponse<ConfigurationSetting>> listRevisionsFirstPageAsync(SettingSelector selector, Context context) {
        try {
            Mono result;
            if (selector != null) {
                String fields = CoreUtils.arrayToString((Object[])selector.getFields(), SettingFields::toStringMapper);
                String keyFilter = selector.getKeyFilter();
                String labelFilter = selector.getLabelFilter();
                result = this.service.listKeyValueRevisionsAsync(this.getEndpoint(), keyFilter, labelFilter, this.getApiVersion(), fields, selector.getAcceptDateTime(), null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.verbose("Listing ConfigurationSetting revisions - {}", new Object[]{selector})).doOnSuccess(response -> this.logger.verbose("Listed ConfigurationSetting revisions - {}", new Object[]{selector})).doOnError(error -> this.logger.warning("Failed to list ConfigurationSetting revisions - {}", new Object[]{selector, error}));
            } else {
                result = this.service.listKeyValueRevisionsAsync(this.getEndpoint(), null, null, this.getApiVersion(), null, null, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.verbose("Listing ConfigurationSetting revisions")).doOnSuccess(response -> this.logger.verbose("Listed ConfigurationSetting revisions")).doOnError(error -> this.logger.warning("Failed to list all ConfigurationSetting revisions", new Object[]{error}));
            }
            return result;
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<ConfigurationSetting>> listRevisionsNextPageAsync(String nextPageLink, Context context) {
        try {
            return this.service.listKeyValuesAsync(this.getEndpoint(), nextPageLink, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private PagedResponse<ConfigurationSetting> listRevisionsFirstPage(SettingSelector selector, Context context) {
        PagedResponse<ConfigurationSetting> result;
        if (selector != null) {
            String fields = CoreUtils.arrayToString((Object[])selector.getFields(), SettingFields::toStringMapper);
            String keyFilter = selector.getKeyFilter();
            String labelFilter = selector.getLabelFilter();
            result = this.service.listKeyValueRevisions(this.getEndpoint(), keyFilter, labelFilter, this.getApiVersion(), fields, selector.getAcceptDateTime(), null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE));
        } else {
            result = this.service.listKeyValueRevisions(this.getEndpoint(), null, null, this.getApiVersion(), null, null, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE));
        }
        return result;
    }

    private PagedResponse<ConfigurationSetting> listRevisionsNextPage(String nextPageLink, Context context) {
        return this.service.listKeyValues(this.getEndpoint(), nextPageLink, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE));
    }

    @Host(value="{url}")
    @ServiceInterface(name="ConfigurationClient")
    public static interface ConfigurationService {
        @Get(value="kv/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=HttpResponseException.class), @UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class)})
        public Mono<Response<ConfigurationSetting>> getKeyValueAsync(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$select") String var5, @HeaderParam(value="Accept-Datetime") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, Context var9);

        @Get(value="kv/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=HttpResponseException.class), @UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class)})
        public Response<ConfigurationSetting> getKeyValue(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$select") String var5, @HeaderParam(value="Accept-Datetime") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, Context var9);

        @Put(value="kv/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={412}, value=ResourceExistsException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<ConfigurationSetting>> setKeyAsync(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ConfigurationSetting var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, Context var8);

        @Put(value="kv/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={412}, value=ResourceExistsException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<ConfigurationSetting> setKey(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ConfigurationSetting var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, Context var8);

        @Delete(value="kv/{key}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<ConfigurationSetting>> deleteAsync(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, Context var7);

        @Delete(value="kv/{key}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<ConfigurationSetting> delete(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, Context var7);

        @Put(value="locks/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<ConfigurationSetting>> lockKeyValueAsync(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, Context var7);

        @Put(value="locks/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<ConfigurationSetting> lockKeyValue(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, Context var7);

        @Delete(value="locks/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<ConfigurationSetting>> unlockKeyValueAsync(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, Context var7);

        @Delete(value="locks/{key}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<ConfigurationSetting> unlockKeyValue(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, Context var7);

        @Get(value="kv")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=ConfigurationSettingPage.class)
        public Mono<PagedResponse<ConfigurationSetting>> listKeyValuesAsync(@HostParam(value="url") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$select") String var5, @HeaderParam(value="Accept-Datetime") String var6, Context var7);

        @Get(value="kv")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=ConfigurationSettingPage.class)
        public PagedResponse<ConfigurationSetting> listKeyValues(@HostParam(value="url") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$select") String var5, @HeaderParam(value="Accept-Datetime") String var6, Context var7);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=ConfigurationSettingPage.class)
        public Mono<PagedResponse<ConfigurationSetting>> listKeyValuesAsync(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, Context var3);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=ConfigurationSettingPage.class)
        public PagedResponse<ConfigurationSetting> listKeyValues(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, Context var3);

        @Get(value="revisions")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=ConfigurationSettingPage.class)
        public Mono<PagedResponse<ConfigurationSetting>> listKeyValueRevisionsAsync(@HostParam(value="url") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$select") String var5, @HeaderParam(value="Accept-Datetime") String var6, @HeaderParam(value="Range") String var7, Context var8);

        @Get(value="revisions")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=ConfigurationSettingPage.class)
        public PagedResponse<ConfigurationSetting> listKeyValueRevisions(@HostParam(value="url") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$select") String var5, @HeaderParam(value="Accept-Datetime") String var6, @HeaderParam(value="Range") String var7, Context var8);
    }
}

