/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.prefs.AndroidLocation;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.Navigation;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceParser;
import com.android.sdklib.devices.DeviceWriter;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.PowerType;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.State;
import com.android.sdklib.io.FileOp;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xml.sax.SAXException;

public class DeviceManager {
    private static final String DEVICE_PROFILES_PROP = "DeviceProfiles";
    private static final Pattern PATH_PROPERTY_PATTERN = Pattern.compile("^Extra.Path=DeviceProfiles$");
    private ILogger mLog;
    private Collection<Device> mVendorDevices;
    private Collection<Device> mSysImgDevices;
    private Collection<Device> mUserDevices;
    private Collection<Device> mDefaultDevices;
    private final Object mLock = new Object();
    private final List<DevicesChangedListener> sListeners = new ArrayList<DevicesChangedListener>();
    private final String mOsSdkPath;
    public static final EnumSet<DeviceFilter> ALL_DEVICES = EnumSet.allOf(DeviceFilter.class);

    public static DeviceManager createInstance(@Nullable File sdkLocation, @NonNull ILogger log) {
        return new DeviceManager(sdkLocation == null ? null : sdkLocation.getPath(), log);
    }

    private DeviceManager(@Nullable String osSdkPath, @NonNull ILogger log) {
        this.mOsSdkPath = osSdkPath;
        this.mLog = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(@NonNull DevicesChangedListener listener) {
        List<DevicesChangedListener> list = this.sListeners;
        synchronized (list) {
            if (!this.sListeners.contains(listener)) {
                this.sListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterListener(@NonNull DevicesChangedListener listener) {
        List<DevicesChangedListener> list = this.sListeners;
        synchronized (list) {
            return this.sListeners.remove(listener);
        }
    }

    @NonNull
    public DeviceStatus getDeviceStatus(@NonNull String name, @NonNull String manufacturer) {
        Device d = this.getDevice(name, manufacturer);
        if (d == null) {
            return DeviceStatus.MISSING;
        }
        return DeviceStatus.EXISTS;
    }

    @Nullable
    public Device getDevice(@NonNull String id, @NonNull String manufacturer) {
        this.initDevicesLists();
        Device d = this.getDeviceImpl(this.mUserDevices, id, manufacturer);
        if (d != null) {
            return d;
        }
        d = this.getDeviceImpl(this.mSysImgDevices, id, manufacturer);
        if (d != null) {
            return d;
        }
        d = this.getDeviceImpl(this.mDefaultDevices, id, manufacturer);
        if (d != null) {
            return d;
        }
        d = this.getDeviceImpl(this.mVendorDevices, id, manufacturer);
        return d;
    }

    @Nullable
    private Device getDeviceImpl(@NonNull Iterable<Device> devicesList, @NonNull String id, @NonNull String manufacturer) {
        for (Device d : devicesList) {
            if (!d.getId().equals(id) || !d.getManufacturer().equals(manufacturer)) continue;
            return d;
        }
        return null;
    }

    @NonNull
    public Collection<Device> getDevices(@NonNull DeviceFilter deviceFilter) {
        return this.getDevices(EnumSet.of(deviceFilter));
    }

    @NonNull
    public Collection<Device> getDevices(@NonNull EnumSet<DeviceFilter> deviceFilter) {
        this.initDevicesLists();
        LinkedHashSet<Device> devices = new LinkedHashSet<Device>();
        if (this.mUserDevices != null && deviceFilter.contains((Object)DeviceFilter.USER)) {
            devices.addAll(this.mUserDevices);
        }
        if (this.mDefaultDevices != null && deviceFilter.contains((Object)DeviceFilter.DEFAULT)) {
            devices.addAll(this.mDefaultDevices);
        }
        if (this.mVendorDevices != null && deviceFilter.contains((Object)DeviceFilter.VENDOR)) {
            devices.addAll(this.mVendorDevices);
        }
        if (this.mSysImgDevices != null && deviceFilter.contains((Object)DeviceFilter.SYSTEM_IMAGES)) {
            devices.addAll(this.mSysImgDevices);
        }
        return Collections.unmodifiableSet(devices);
    }

    private void initDevicesLists() {
        boolean changed = this.initDefaultDevices();
        changed |= this.initVendorDevices();
        changed |= this.initSysImgDevices();
        if (changed |= this.initUserDevices()) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initDefaultDevices() {
        Object object = this.mLock;
        synchronized (object) {
            block19: {
                boolean bl;
                if (this.mDefaultDevices != null) {
                    return false;
                }
                InputStream stream = null;
                try {
                    stream = DeviceManager.class.getResourceAsStream("devices.xml");
                    this.mDefaultDevices = DeviceParser.parse(stream);
                    bl = true;
                }
                catch (IllegalStateException e) {
                    this.mLog.error((Throwable)e, null, new Object[0]);
                    this.mDefaultDevices = new LinkedHashSet<Device>();
                    break block19;
                }
                catch (Exception e) {
                    this.mLog.error((Throwable)e, "Error reading default devices", new Object[0]);
                    this.mDefaultDevices = new LinkedHashSet<Device>();
                    break block19;
                }
                return bl;
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initVendorDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVendorDevices != null) {
                return false;
            }
            this.mVendorDevices = new LinkedHashSet<Device>();
            InputStream stream = null;
            try {
                stream = DeviceManager.class.getResourceAsStream("nexus.xml");
                this.mVendorDevices.addAll(DeviceParser.parse(stream));
            }
            catch (Exception e) {
                this.mLog.error((Throwable)e, null, new Object[]{"Could not load nexus devices"});
            }
            finally {
                try {
                    Closeables.close((Closeable)stream, (boolean)true);
                }
                catch (IOException e) {}
            }
            stream = null;
            try {
                stream = DeviceManager.class.getResourceAsStream("wear.xml");
                this.mVendorDevices.addAll(DeviceParser.parse(stream));
            }
            catch (Exception e) {
                this.mLog.error((Throwable)e, null, new Object[]{"Could not load wear devices"});
            }
            finally {
                try {
                    Closeables.close((Closeable)stream, (boolean)true);
                }
                catch (IOException e) {}
            }
            stream = null;
            try {
                stream = DeviceManager.class.getResourceAsStream("tv.xml");
                this.mVendorDevices.addAll(DeviceParser.parse(stream));
            }
            catch (Exception e) {
                this.mLog.error((Throwable)e, null, new Object[]{"Could not load tv devices"});
            }
            finally {
                try {
                    Closeables.close((Closeable)stream, (boolean)true);
                }
                catch (IOException e) {}
            }
            if (this.mOsSdkPath != null) {
                File extrasFolder = new File(this.mOsSdkPath, "extras");
                List<File> deviceDirs = this.getExtraDirs(extrasFolder);
                for (File deviceDir : deviceDirs) {
                    File deviceXml = new File(deviceDir, "devices.xml");
                    if (!deviceXml.isFile()) continue;
                    this.mVendorDevices.addAll(this.loadDevices(deviceXml));
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initSysImgDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSysImgDevices != null) {
                return false;
            }
            this.mSysImgDevices = new LinkedHashSet<Device>();
            if (this.mOsSdkPath == null) {
                return false;
            }
            FileOp fop = new FileOp();
            File sysImgFolder = new File(this.mOsSdkPath, "system-images");
            for (File platformFolder : fop.listFiles(sysImgFolder)) {
                if (!fop.isDirectory(platformFolder)) continue;
                for (File tagFolder : fop.listFiles(platformFolder)) {
                    if (!fop.isDirectory(tagFolder)) continue;
                    for (File abiFolder : fop.listFiles(tagFolder)) {
                        File deviceXml;
                        if (!fop.isDirectory(abiFolder) || !fop.isFile(deviceXml = new File(abiFolder, "devices.xml"))) continue;
                        this.mSysImgDevices.addAll(this.loadDevices(deviceXml));
                    }
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initUserDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices != null) {
                return false;
            }
            this.mUserDevices = new LinkedHashSet<Device>();
            File userDevicesFile = null;
            try {
                userDevicesFile = new File(AndroidLocation.getFolder(), "devices.xml");
                if (userDevicesFile.exists()) {
                    this.mUserDevices.addAll(DeviceParser.parse(userDevicesFile));
                    return true;
                }
            }
            catch (AndroidLocation.AndroidLocationException e) {
                this.mLog.warning("Couldn't load user devices: %1$s", new Object[]{e.getMessage()});
            }
            catch (SAXException e) {
                if (userDevicesFile != null) {
                    String base = userDevicesFile.getAbsoluteFile() + ".old";
                    File renamedConfig = new File(base);
                    int i = 0;
                    while (renamedConfig.exists()) {
                        renamedConfig = new File(base + '.' + i++);
                    }
                    this.mLog.error((Throwable)e, "Error parsing %1$s, backing up to %2$s", new Object[]{userDevicesFile.getAbsolutePath(), renamedConfig.getAbsolutePath()});
                    userDevicesFile.renameTo(renamedConfig);
                }
            }
            catch (ParserConfigurationException e) {
                this.mLog.error((Throwable)e, "Error parsing %1$s", new Object[]{userDevicesFile == null ? "(null)" : userDevicesFile.getAbsolutePath()});
            }
            catch (IOException e) {
                this.mLog.error((Throwable)e, "Error parsing %1$s", new Object[]{userDevicesFile == null ? "(null)" : userDevicesFile.getAbsolutePath()});
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserDevice(@NonNull Device d) {
        boolean changed = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
                assert (this.mUserDevices != null);
            }
            if (this.mUserDevices != null) {
                this.mUserDevices.add(d);
            }
            changed = true;
        }
        if (changed) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserDevice(@NonNull Device d) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
                assert (this.mUserDevices != null);
            }
            if (this.mUserDevices != null) {
                Iterator<Device> it = this.mUserDevices.iterator();
                while (it.hasNext()) {
                    Device userDevice = it.next();
                    if (!userDevice.getId().equals(d.getId()) || !userDevice.getManufacturer().equals(d.getManufacturer())) continue;
                    it.remove();
                    this.notifyListeners();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceUserDevice(@NonNull Device d) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
            }
            this.removeUserDevice(d);
            this.addUserDevice(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserDevices() {
        if (this.mUserDevices == null) {
            return;
        }
        File userDevicesFile = null;
        try {
            userDevicesFile = new File(AndroidLocation.getFolder(), "devices.xml");
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.mLog.warning("Couldn't find user directory: %1$s", new Object[]{e.getMessage()});
            return;
        }
        if (this.mUserDevices.size() == 0) {
            userDevicesFile.delete();
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices.size() > 0) {
                try {
                    DeviceWriter.writeToXml(new FileOutputStream(userDevicesFile), this.mUserDevices);
                }
                catch (FileNotFoundException e) {
                    this.mLog.warning("Couldn't open file: %1$s", new Object[]{e.getMessage()});
                }
                catch (ParserConfigurationException e) {
                    this.mLog.warning("Error writing file: %1$s", new Object[]{e.getMessage()});
                }
                catch (TransformerFactoryConfigurationError e) {
                    this.mLog.warning("Error writing file: %1$s", new Object[]{e.getMessage()});
                }
                catch (TransformerException e) {
                    this.mLog.warning("Error writing file: %1$s", new Object[]{e.getMessage()});
                }
            }
        }
    }

    @NonNull
    public static Map<String, String> getHardwareProperties(@NonNull State s) {
        Hardware hw = s.getHardware();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hw.mainKeys", DeviceManager.getBooleanVal(hw.getButtonType().equals((Object)ButtonType.HARD)));
        props.put("hw.trackBall", DeviceManager.getBooleanVal(hw.getNav().equals((Object)Navigation.TRACKBALL)));
        props.put("hw.keyboard", DeviceManager.getBooleanVal(hw.getKeyboard().equals((Object)Keyboard.QWERTY)));
        props.put("hw.dPad", DeviceManager.getBooleanVal(hw.getNav().equals((Object)Navigation.DPAD)));
        Set<Sensor> sensors = hw.getSensors();
        props.put("hw.gps", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.GPS)));
        props.put("hw.battery", DeviceManager.getBooleanVal(hw.getChargeType().equals((Object)PowerType.BATTERY)));
        props.put("hw.accelerometer", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.ACCELEROMETER)));
        props.put("hw.sensors.orientation", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.GYROSCOPE)));
        props.put("hw.audioInput", DeviceManager.getBooleanVal(hw.hasMic()));
        props.put("hw.sdCard", DeviceManager.getBooleanVal(hw.getRemovableStorage().size() > 0));
        props.put("hw.lcd.density", Integer.toString(hw.getScreen().getPixelDensity().getDpiValue()));
        props.put("hw.sensors.proximity", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.PROXIMITY_SENSOR)));
        return props;
    }

    @NonNull
    public static Map<String, String> getHardwareProperties(@NonNull Device d) {
        Map<String, String> props = DeviceManager.getHardwareProperties(d.getDefaultState());
        for (State s : d.getAllStates()) {
            if (!s.getKeyState().equals((Object)KeyboardState.HIDDEN)) continue;
            props.put("hw.keyboard.lid", DeviceManager.getBooleanVal(true));
        }
        HashFunction md5 = Hashing.md5();
        Hasher hasher = md5.newHasher();
        ArrayList<String> keys = new ArrayList<String>(props.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            if (key == null) continue;
            hasher.putString((CharSequence)key, Charsets.UTF_8);
            String value = props.get(key);
            hasher.putString((CharSequence)(value == null ? "null" : value), Charsets.UTF_8);
        }
        String hash = "MD5:" + hasher.hash().toString();
        props.put("hw.device.hash2", hash);
        props.remove("hw.device.hash");
        props.put("hw.device.name", d.getId());
        props.put("hw.device.manufacturer", d.getManufacturer());
        return props;
    }

    @Nullable
    public static String hasHardwarePropHashChanged(@NonNull Device d, @NonNull String hashV2) {
        Map<String, String> props = DeviceManager.getHardwareProperties(d);
        String newHash = props.get("hw.device.hash2");
        if (newHash != null && newHash.equals(hashV2)) {
            return null;
        }
        return newHash;
    }

    private static String getBooleanVal(boolean bool) {
        if (bool) {
            return "yes";
        }
        return "no";
    }

    @NonNull
    private Collection<Device> loadDevices(@NonNull File deviceXml) {
        try {
            return DeviceParser.parse(deviceXml);
        }
        catch (SAXException e) {
            this.mLog.error((Throwable)e, "Error parsing %1$s", new Object[]{deviceXml.getAbsolutePath()});
        }
        catch (ParserConfigurationException e) {
            this.mLog.error((Throwable)e, "Error parsing %1$s", new Object[]{deviceXml.getAbsolutePath()});
        }
        catch (IOException e) {
            this.mLog.error((Throwable)e, "Error reading %1$s", new Object[]{deviceXml.getAbsolutePath()});
        }
        catch (AssertionError e) {
            this.mLog.error((Throwable)((Object)e), "Error parsing %1$s", new Object[]{deviceXml.getAbsolutePath()});
        }
        catch (IllegalStateException e) {
            this.mLog.error((Throwable)e, null, new Object[0]);
        }
        return new LinkedHashSet<Device>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        List<DevicesChangedListener> list = this.sListeners;
        synchronized (list) {
            for (DevicesChangedListener listener : this.sListeners) {
                listener.onDevicesChanged();
            }
        }
    }

    @NonNull
    private List<File> getExtraDirs(@NonNull File extrasFolder) {
        ArrayList<File> extraDirs = new ArrayList<File>();
        if (extrasFolder != null && extrasFolder.isDirectory()) {
            for (File vendor : extrasFolder.listFiles()) {
                if (!vendor.isDirectory()) continue;
                for (File item : vendor.listFiles()) {
                    if (!item.isDirectory() || !this.isDevicesExtra(item)) continue;
                    extraDirs.add(item);
                }
            }
        }
        return extraDirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDevicesExtra(@NonNull File item) {
        File properties = new File(item, "source.properties");
        try {
            BufferedReader propertiesReader = new BufferedReader(new FileReader(properties));
            try {
                String line;
                Matcher m;
                do {
                    if ((line = propertiesReader.readLine()) == null) return false;
                } while (!(m = PATH_PROPERTY_PATTERN.matcher(line)).matches());
                boolean bl = true;
                return bl;
            }
            finally {
                propertiesReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static interface DevicesChangedListener {
        public void onDevicesChanged();
    }

    public static enum DeviceStatus {
        EXISTS,
        CHANGED,
        MISSING;

    }

    public static enum DeviceFilter {
        DEFAULT,
        USER,
        VENDOR,
        SYSTEM_IMAGES;

    }
}

