/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.prefs.AndroidLocation;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.Navigation;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceParser;
import com.android.sdklib.devices.DeviceWriter;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.PowerType;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.State;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.utils.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xml.sax.SAXException;

public class DeviceManager {
    private static final String DEVICE_PROFILES_PROP = "DeviceProfiles";
    private static final Pattern PATH_PROPERTY_PATTERN = Pattern.compile("^Extra.Path=DeviceProfiles$");
    private ILogger mLog;
    private List<Device> mVendorDevices;
    private List<Device> mUserDevices;
    private List<Device> mDefaultDevices;
    private final Object mLock = new Object();
    private final List<DevicesChangedListener> sListeners = new ArrayList<DevicesChangedListener>();
    private final String mOsSdkPath;
    public static final int USER_DEVICES = 1;
    public static final int DEFAULT_DEVICES = 2;
    public static final int VENDOR_DEVICES = 4;
    public static final int ALL_DEVICES = 7;

    public static DeviceManager createInstance(@Nullable String osSdkPath, @NonNull ILogger log) {
        return new DeviceManager(osSdkPath, log);
    }

    private DeviceManager(@Nullable String osSdkPath, @NonNull ILogger log) {
        this.mOsSdkPath = osSdkPath;
        this.mLog = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(@NonNull DevicesChangedListener listener) {
        List<DevicesChangedListener> list = this.sListeners;
        synchronized (list) {
            if (!this.sListeners.contains(listener)) {
                this.sListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterListener(@NonNull DevicesChangedListener listener) {
        List<DevicesChangedListener> list = this.sListeners;
        synchronized (list) {
            return this.sListeners.remove(listener);
        }
    }

    @NonNull
    public DeviceStatus getDeviceStatus(@NonNull String name, @NonNull String manufacturer, int hashCode) {
        Device d = this.getDevice(name, manufacturer);
        if (d == null) {
            return DeviceStatus.MISSING;
        }
        return d.hashCode() == hashCode ? DeviceStatus.EXISTS : DeviceStatus.CHANGED;
    }

    @Nullable
    public Device getDevice(@NonNull String name, @NonNull String manufacturer) {
        this.initDevicesLists();
        for (List devices : new List[]{this.mUserDevices, this.mDefaultDevices, this.mVendorDevices}) {
            if (devices == null) continue;
            List devicesList = devices;
            for (Device d : devicesList) {
                if (!d.getName().equals(name) || !d.getManufacturer().equals(manufacturer)) continue;
                return d;
            }
        }
        return null;
    }

    @NonNull
    public List<Device> getDevices(int deviceFilter) {
        this.initDevicesLists();
        ArrayList<Device> devices = new ArrayList<Device>();
        if (this.mUserDevices != null && (deviceFilter & 1) != 0) {
            devices.addAll(this.mUserDevices);
        }
        if (this.mDefaultDevices != null && (deviceFilter & 2) != 0) {
            devices.addAll(this.mDefaultDevices);
        }
        if (this.mVendorDevices != null && (deviceFilter & 4) != 0) {
            devices.addAll(this.mVendorDevices);
        }
        return Collections.unmodifiableList(devices);
    }

    private void initDevicesLists() {
        boolean changed = this.initDefaultDevices();
        changed |= this.initVendorDevices();
        if (changed |= this.initUserDevices()) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initDefaultDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDefaultDevices == null) {
                try {
                    this.mDefaultDevices = DeviceParser.parse(DeviceManager.class.getResourceAsStream("devices.xml"));
                    return true;
                }
                catch (IllegalStateException e) {
                    this.mLog.error((Throwable)e, null, new Object[0]);
                    this.mDefaultDevices = new ArrayList<Device>();
                }
                catch (Exception e) {
                    this.mLog.error((Throwable)e, "Error reading default devices", new Object[0]);
                    this.mDefaultDevices = new ArrayList<Device>();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initVendorDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVendorDevices == null) {
                this.mVendorDevices = new ArrayList<Device>();
                if (this.mOsSdkPath != null) {
                    File toolsDevices = new File(this.mOsSdkPath, SdkConstants.OS_SDK_TOOLS_LIB_FOLDER + File.separator + "devices.xml");
                    if (toolsDevices.isFile()) {
                        this.mVendorDevices.addAll(this.loadDevices(toolsDevices));
                    }
                    File extrasFolder = new File(this.mOsSdkPath, "extras");
                    List<File> deviceDirs = this.getExtraDirs(extrasFolder);
                    for (File deviceDir : deviceDirs) {
                        File deviceXml = new File(deviceDir, "devices.xml");
                        if (!deviceXml.isFile()) continue;
                        this.mVendorDevices.addAll(this.loadDevices(deviceXml));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initUserDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.mUserDevices = new ArrayList<Device>();
                File userDevicesFile = null;
                try {
                    userDevicesFile = new File(AndroidLocation.getFolder(), "devices.xml");
                    if (userDevicesFile.exists()) {
                        this.mUserDevices.addAll(DeviceParser.parse(userDevicesFile));
                        return true;
                    }
                }
                catch (AndroidLocation.AndroidLocationException e) {
                    this.mLog.warning("Couldn't load user devices: %1$s", new Object[]{e.getMessage()});
                }
                catch (SAXException e) {
                    if (userDevicesFile != null) {
                        String base = userDevicesFile.getAbsoluteFile() + ".old";
                        File renamedConfig = new File(base);
                        int i = 0;
                        while (renamedConfig.exists()) {
                            renamedConfig = new File(base + '.' + i++);
                        }
                        this.mLog.error((Throwable)e, "Error parsing %1$s, backing up to %2$s", new Object[]{userDevicesFile.getAbsolutePath(), renamedConfig.getAbsolutePath()});
                        userDevicesFile.renameTo(renamedConfig);
                    }
                }
                catch (ParserConfigurationException e) {
                    this.mLog.error((Throwable)e, "Error parsing %1$s", new Object[]{userDevicesFile == null ? "(null)" : userDevicesFile.getAbsolutePath()});
                }
                catch (IOException e) {
                    this.mLog.error((Throwable)e, "Error parsing %1$s", new Object[]{userDevicesFile == null ? "(null)" : userDevicesFile.getAbsolutePath()});
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserDevice(@NonNull Device d) {
        boolean changed = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
                assert (this.mUserDevices != null);
            }
            if (this.mUserDevices != null) {
                this.mUserDevices.add(d);
            }
            changed = true;
        }
        if (changed) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserDevice(@NonNull Device d) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
                assert (this.mUserDevices != null);
            }
            if (this.mUserDevices != null) {
                Iterator<Device> it = this.mUserDevices.iterator();
                while (it.hasNext()) {
                    Device userDevice = it.next();
                    if (!userDevice.getName().equals(d.getName()) || !userDevice.getManufacturer().equals(d.getManufacturer())) continue;
                    it.remove();
                    this.notifyListeners();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceUserDevice(@NonNull Device d) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
            }
            this.removeUserDevice(d);
            this.addUserDevice(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserDevices() {
        if (this.mUserDevices == null) {
            return;
        }
        File userDevicesFile = null;
        try {
            userDevicesFile = new File(AndroidLocation.getFolder(), "devices.xml");
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.mLog.warning("Couldn't find user directory: %1$s", new Object[]{e.getMessage()});
            return;
        }
        if (this.mUserDevices.size() == 0) {
            userDevicesFile.delete();
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices.size() > 0) {
                try {
                    DeviceWriter.writeToXml(new FileOutputStream(userDevicesFile), this.mUserDevices);
                }
                catch (FileNotFoundException e) {
                    this.mLog.warning("Couldn't open file: %1$s", new Object[]{e.getMessage()});
                }
                catch (ParserConfigurationException e) {
                    this.mLog.warning("Error writing file: %1$s", new Object[]{e.getMessage()});
                }
                catch (TransformerFactoryConfigurationError e) {
                    this.mLog.warning("Error writing file: %1$s", new Object[]{e.getMessage()});
                }
                catch (TransformerException e) {
                    this.mLog.warning("Error writing file: %1$s", new Object[]{e.getMessage()});
                }
            }
        }
    }

    @NonNull
    public static Map<String, String> getHardwareProperties(@NonNull State s) {
        Hardware hw = s.getHardware();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hw.mainKeys", DeviceManager.getBooleanVal(hw.getButtonType().equals((Object)ButtonType.HARD)));
        props.put("hw.trackBall", DeviceManager.getBooleanVal(hw.getNav().equals((Object)Navigation.TRACKBALL)));
        props.put("hw.keyboard", DeviceManager.getBooleanVal(hw.getKeyboard().equals((Object)Keyboard.QWERTY)));
        props.put("hw.dPad", DeviceManager.getBooleanVal(hw.getNav().equals((Object)Navigation.DPAD)));
        Set<Sensor> sensors = hw.getSensors();
        props.put("hw.gps", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.GPS)));
        props.put("hw.battery", DeviceManager.getBooleanVal(hw.getChargeType().equals((Object)PowerType.BATTERY)));
        props.put("hw.accelerometer", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.ACCELEROMETER)));
        props.put("hw.sensors.orientation", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.GYROSCOPE)));
        props.put("hw.audioInput", DeviceManager.getBooleanVal(hw.hasMic()));
        props.put("hw.sdCard", DeviceManager.getBooleanVal(hw.getRemovableStorage().size() > 0));
        props.put("hw.lcd.density", Integer.toString(hw.getScreen().getPixelDensity().getDpiValue()));
        props.put("hw.sensors.proximity", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.PROXIMITY_SENSOR)));
        return props;
    }

    @NonNull
    public static Map<String, String> getHardwareProperties(@NonNull Device d) {
        Map<String, String> props = DeviceManager.getHardwareProperties(d.getDefaultState());
        for (State s : d.getAllStates()) {
            if (!s.getKeyState().equals((Object)KeyboardState.HIDDEN)) continue;
            props.put("hw.keyboard.lid", DeviceManager.getBooleanVal(true));
        }
        props.put("hw.device.hash", Integer.toString(d.hashCode()));
        props.put("hw.device.name", d.getName());
        props.put("hw.device.manufacturer", d.getManufacturer());
        return props;
    }

    private static String getBooleanVal(boolean bool) {
        if (bool) {
            return HardwareProperties.BOOLEAN_VALUES[0];
        }
        return HardwareProperties.BOOLEAN_VALUES[1];
    }

    @NonNull
    private Collection<Device> loadDevices(@NonNull File deviceXml) {
        try {
            return DeviceParser.parse(deviceXml);
        }
        catch (SAXException e) {
            this.mLog.error((Throwable)e, "Error parsing %1$s", new Object[]{deviceXml.getAbsolutePath()});
        }
        catch (ParserConfigurationException e) {
            this.mLog.error((Throwable)e, "Error parsing %1$s", new Object[]{deviceXml.getAbsolutePath()});
        }
        catch (IOException e) {
            this.mLog.error((Throwable)e, "Error reading %1$s", new Object[]{deviceXml.getAbsolutePath()});
        }
        catch (IllegalStateException e) {
            this.mLog.error((Throwable)e, null, new Object[0]);
        }
        return new ArrayList<Device>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        List<DevicesChangedListener> list = this.sListeners;
        synchronized (list) {
            for (DevicesChangedListener listener : this.sListeners) {
                listener.onDevicesChanged();
            }
        }
    }

    @NonNull
    private List<File> getExtraDirs(@NonNull File extrasFolder) {
        ArrayList<File> extraDirs = new ArrayList<File>();
        if (extrasFolder != null && extrasFolder.isDirectory()) {
            for (File vendor : extrasFolder.listFiles()) {
                if (!vendor.isDirectory()) continue;
                for (File item : vendor.listFiles()) {
                    if (!item.isDirectory() || !this.isDevicesExtra(item)) continue;
                    extraDirs.add(item);
                }
            }
        }
        return extraDirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDevicesExtra(@NonNull File item) {
        File properties = new File(item, "source.properties");
        try {
            BufferedReader propertiesReader = new BufferedReader(new FileReader(properties));
            try {
                String line;
                Matcher m;
                do {
                    if ((line = propertiesReader.readLine()) == null) return false;
                } while (!(m = PATH_PROPERTY_PATTERN.matcher(line)).matches());
                boolean bl = true;
                return bl;
            }
            finally {
                propertiesReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static interface DevicesChangedListener {
        public void onDevicesChanged();
    }

    public static enum DeviceStatus {
        EXISTS,
        CHANGED,
        MISSING;

    }
}

