/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.voiceid.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.voiceid.model.InputDataConfig;

@SdkInternalApi
public class InputDataConfigMarshaller {
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").build();
    private static final InputDataConfigMarshaller instance = new InputDataConfigMarshaller();

    public static InputDataConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(InputDataConfig inputDataConfig, ProtocolMarshaller protocolMarshaller) {
        if (inputDataConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputDataConfig.getS3Uri(), S3URI_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

